/*
 * Decompiled with CFR 0.152.
 */
package com.arm.prefs;

import com.arm.prefs.PrefsIOException;
import com.arm.util.Platform;
import com.arm.util.ThrowableFormatter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.CRC32;

public class PropertiesPrefsStoreLockFile {
    private static final long LOCK_WAIT_TIMEOUT = 15000L;
    private final String storeFilePath;
    private final File lockFile;
    private Closeable lockFileWriter;
    private final Timer scheduler = new Timer("Properties preferences store lock timer", true);
    private volatile boolean waitingToLockFile;

    public PropertiesPrefsStoreLockFile(File storeFile) throws PrefsIOException {
        try {
            this.storeFilePath = storeFile.getCanonicalPath();
            this.lockFile = new File(Platform.TMP, PropertiesPrefsStoreLockFile.hash(this.storeFilePath, "MD5"));
        }
        catch (IOException ioe) {
            throw new PrefsIOException("failed to compute canonical path of file " + storeFile, ioe);
        }
    }

    private FileLock lock(FileChannel channel, long timeout) throws IOException {
        FileLock lock = channel.tryLock();
        if (lock == null) {
            this.scheduler.schedule((TimerTask)new Interrupter(), 15000L);
            this.waitingToLockFile = true;
            lock = channel.lock();
            this.waitingToLockFile = false;
            this.scheduler.cancel();
        }
        return lock;
    }

    public void acquire() throws PrefsIOException {
        try {
            long start = System.currentTimeMillis();
            while (!this.lockFile.createNewFile()) {
                if (System.currentTimeMillis() - start > 15000L) {
                    throw new PrefsIOException("gave up waiting to lock file " + this.lockFile + " (waited at least " + 15000L + " millis)");
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new PrefsIOException("interrupted while waiting to lock file " + this.lockFile, ie);
                }
            }
        }
        catch (IOException | OverlappingFileLockException ex) {
            throw new PrefsIOException("failed to create lock file " + this.lockFile, ex);
        }
        try {
            FileOutputStream out = new FileOutputStream(this.lockFile);
            this.lock(out.getChannel(), 15000L);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
            writer.append(this.storeFilePath);
            ((Writer)writer).flush();
            this.lockFileWriter = writer;
        }
        catch (IOException | OverlappingFileLockException ex) {
            throw new PrefsIOException("failed to lock file " + this.lockFile, ex);
        }
    }

    public void release() {
        block3: {
            try {
                this.lockFileWriter.close();
            }
            catch (IOException ioe) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)ThrowableFormatter.stringify(ioe));
            }
        }
        if (!this.lockFile.delete()) assert (false) : "Failed to delete lock file " + this.lockFile;
    }

    static String hash(String str, String algorithm) {
        String hash;
        try {
            MessageDigest m = MessageDigest.getInstance(algorithm);
            m.update(str.getBytes());
            byte[] digest = m.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            hash = bigInt.toString(16);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            CRC32 checksum = new CRC32();
            checksum.update(str.getBytes());
            hash = Long.toString(checksum.getValue(), 16);
        }
        return hash;
    }

    private class Interrupter
    extends TimerTask {
        private final Thread thread = Thread.currentThread();

        private Interrupter() {
        }

        @Override
        public void run() {
            if (PropertiesPrefsStoreLockFile.this.waitingToLockFile) {
                this.thread.interrupt();
            }
        }
    }
}

