/*
 * Decompiled with CFR 0.152.
 */
package com.arm.prefs;

import com.arm.io.Files;
import com.arm.prefs.CachedPrefsStore;
import com.arm.prefs.IPrefsStore;
import com.arm.prefs.PrefsIOException;
import com.arm.prefs.PropertiesPrefsStoreLockFile;
import com.arm.util.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class PropertiesPrefsStore
extends CachedPrefsStore
implements IPrefsStore {
    public static final File DEFAULT_UNIX_USER_PREFS_DIRECTORY = new File(System.getProperty("user.home"), ".arm");
    public static final File DEFAULT_WINDOWS_USER_PREFS_DIRECTORY = new File(System.getenv("APPDATA"), "ARM");
    public static final File DEFAULT_UNIX_SYSTEM_PREFS_DIRECTORY = new File("/etc/arm");
    private final File storeFile;
    private PropertiesPrefsStoreLockFile storeLockFile;

    public PropertiesPrefsStore(File propertiesFile) {
        this.storeFile = propertiesFile;
    }

    private static File getWindowsAllUsersDir() {
        String location = System.getenv("PROGRAMDATA");
        if (location == null && (location = System.getenv("ALLUSERSPROFILE")) == null) {
            throw new RuntimeException("could not determine the location of the 'all users' directory");
        }
        return new File(location);
    }

    private static File getWindowsSystemPrefsDirectory() {
        return new File(PropertiesPrefsStore.getWindowsAllUsersDir(), "ARM");
    }

    public static File getDefaultUserFile(String prefsID) {
        return Platform.isWindows() ? new File(DEFAULT_WINDOWS_USER_PREFS_DIRECTORY, prefsID) : new File(DEFAULT_UNIX_USER_PREFS_DIRECTORY, prefsID);
    }

    public static File getDefaultSystemFile(String prefsID) {
        return Platform.isWindows() ? new File(PropertiesPrefsStore.getWindowsSystemPrefsDirectory(), prefsID) : new File(DEFAULT_UNIX_SYSTEM_PREFS_DIRECTORY, prefsID);
    }

    private void lockedSync(String nodePath) throws PrefsIOException {
        Properties onDisk = new Properties();
        if (this.storeFile.exists()) {
            try {
                FileInputStream in = new FileInputStream(this.storeFile);
                onDisk.load(in);
                in.close();
            }
            catch (IOException ioe) {
                throw new PrefsIOException("failed to read preferences", ioe);
            }
        }
        boolean writeBackNeeded = false;
        Iterator iterator = this.delKeys.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!key.startsWith(nodePath)) continue;
            iterator.remove();
            onDisk.remove(key);
            writeBackNeeded = true;
        }
        Iterator iterator2 = this.modKeyValuePairs.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(nodePath)) continue;
            iterator2.remove();
            onDisk.put(key, entry.getValue());
            writeBackNeeded = true;
        }
        this.remove(nodePath, false);
        for (Map.Entry entry : onDisk.entrySet()) {
            String path;
            String propKey = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            int lastSeparatorPosition = propKey.lastIndexOf(47);
            if (lastSeparatorPosition <= 1 || !(path = propKey.substring(0, lastSeparatorPosition)).startsWith(nodePath)) continue;
            String key = propKey.substring(lastSeparatorPosition + 1);
            this.put(path, key, value, false);
        }
        if (writeBackNeeded) {
            File file = this.storeFile.getParentFile();
            try {
                if (!file.exists()) {
                    Files.mkdirs(file);
                }
                FileOutputStream out = new FileOutputStream(this.storeFile);
                onDisk.store(out, null);
                out.close();
            }
            catch (IOException ioe) {
                throw new PrefsIOException("failed to write preferences", ioe);
            }
        }
    }

    private PropertiesPrefsStoreLockFile getLockFile() throws PrefsIOException {
        if (this.storeLockFile == null) {
            this.storeLockFile = new PropertiesPrefsStoreLockFile(this.storeFile);
        }
        return this.storeLockFile;
    }

    @Override
    public synchronized void sync(String nodePath) throws PrefsIOException {
        PropertiesPrefsStoreLockFile lock = this.getLockFile();
        lock.acquire();
        try {
            this.lockedSync(nodePath);
        }
        finally {
            lock.release();
        }
    }
}

