/*
 * Decompiled with CFR 0.152.
 */
package com.arm.prefs;

import com.arm.prefs.IPrefsStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class CachedPrefsStore
implements IPrefsStore {
    protected static final char NODE_PATH_SEPARATOR = '/';
    private final SortedMap<String, Map<String, String>> path2map = new TreeMap<String, Map<String, String>>();
    protected final Map<String, String> modKeyValuePairs = new HashMap<String, String>();
    protected final Set<String> delKeys = new HashSet<String>();

    @Override
    public char getNodePathSeparator() {
        return '/';
    }

    @Override
    public synchronized Set<String> getKeys(String nodePath) {
        Set<String> keys;
        if (this.path2map.containsKey(nodePath)) {
            Map node = (Map)this.path2map.get(nodePath);
            keys = node.keySet();
        } else {
            keys = Collections.emptySet();
        }
        return keys;
    }

    private boolean isImmediateChildNode(String parentNodePath, String childNodePath) {
        boolean result = childNodePath.startsWith(parentNodePath) && !childNodePath.equals(parentNodePath) ? childNodePath.indexOf(47, parentNodePath.length() + 1) < 0 : false;
        return result;
    }

    @Override
    public synchronized Set<String> getChildNodes(String nodePath) {
        HashSet<String> children = new HashSet<String>();
        for (String path : this.path2map.keySet()) {
            if (this.isImmediateChildNode(nodePath, path)) {
                children.add(path);
                continue;
            }
            if (path.compareTo(nodePath) > 0 && !path.startsWith(nodePath)) break;
        }
        return children;
    }

    @Override
    public synchronized String get(String nodePath, String key) {
        String value;
        if (this.path2map.containsKey(nodePath)) {
            Map node = (Map)this.path2map.get(nodePath);
            value = (String)node.get(key);
        } else {
            value = null;
        }
        return value;
    }

    protected void put(String nodePath, String key, String value, boolean trackChanges) {
        Map<String, String> node;
        if (this.path2map.containsKey(nodePath)) {
            node = (Map)this.path2map.get(nodePath);
        } else {
            node = new HashMap();
            this.path2map.put(nodePath, node);
        }
        node.put(key, value);
        if (trackChanges) {
            this.keyModified(nodePath, key, value);
        }
    }

    @Override
    public synchronized void put(String nodePath, String key, String value) {
        this.put(nodePath, key, value, true);
    }

    private void keyModified(String nodePath, String key, String value) {
        String flattenedKey = String.valueOf(nodePath) + '/' + key;
        if (this.delKeys.contains(flattenedKey)) {
            this.delKeys.remove(flattenedKey);
        }
        this.modKeyValuePairs.put(flattenedKey, value);
    }

    @Override
    public synchronized void remove(String nodePath, String key) {
        if (this.path2map.containsKey(nodePath)) {
            Map node = (Map)this.path2map.get(nodePath);
            node.remove(key);
        }
        this.keyDeleted(nodePath, key);
    }

    private void keyDeleted(String nodePath, String key) {
        String flattenedKey = String.valueOf(nodePath) + '/' + key;
        if (this.modKeyValuePairs.keySet().contains(flattenedKey)) {
            this.modKeyValuePairs.remove(flattenedKey);
        }
        this.delKeys.add(flattenedKey);
    }

    protected void remove(String nodePath, boolean trackChanges) {
        Map map = (Map)this.path2map.get(nodePath);
        if (map != null) {
            if (trackChanges) {
                for (String key : map.keySet()) {
                    this.keyDeleted(nodePath, key);
                }
            }
            this.path2map.remove(nodePath);
        }
        for (String child : this.getChildNodes(nodePath)) {
            this.remove(child, trackChanges);
        }
    }

    @Override
    public synchronized void remove(String nodePath) {
        this.remove(nodePath, true);
    }
}

