/*
 * Decompiled with CFR 0.152.
 */
package com.arm.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Sets {
    public static final <T> Set<T> makeSet(T ... ts) {
        return new HashSet<T>(Arrays.asList(ts));
    }

    public static final <T> Set<T> singleton(T o) {
        HashSet<T> s = new HashSet<T>();
        s.add(o);
        return s;
    }

    public static final <T> Set<T> union(Collection<T> a, Collection<T> b) {
        HashSet<T> result = new HashSet<T>(a);
        result.addAll(b);
        return result;
    }

    public static final <T> Set<T> flatten(Collection<T> c) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (T t : c) {
            if (t instanceof Collection) {
                result.addAll(Sets.flatten((Collection)t));
                continue;
            }
            if (t instanceof Map) {
                result.addAll(Sets.flatten(((Map)t).values()));
                continue;
            }
            result.add(t);
        }
        return result;
    }

    public static final <T> Set<T> union(Collection<? extends Collection<T>> cs) {
        HashSet<T> result = new HashSet<T>();
        for (Collection<T> c : cs) {
            result.addAll(c);
        }
        return result;
    }

    public static final <T> Set<T> intersection(Collection<T> a, Collection<T> b) {
        Collection<T> big = a;
        Collection<T> small = b;
        if (a.size() < b.size()) {
            big = b;
            small = a;
        } else {
            big = a;
            small = b;
        }
        HashSet<T> result = new HashSet<T>(small);
        result.retainAll(big);
        return result;
    }

    public static final <T> Set<T> intersection(Collection<? extends Collection<T>> s) {
        if (s.isEmpty()) {
            return new HashSet();
        }
        Iterator<Collection<T>> i = s.iterator();
        HashSet<T> result = new HashSet<T>(i.next());
        while (i.hasNext()) {
            result.retainAll(i.next());
        }
        return result;
    }

    public static final <T> Set<T> less(Collection<T> a, Collection<T> b) {
        HashSet<T> result = new HashSet<T>(a);
        result.removeAll(b);
        return result;
    }

    public static final <T> Set<T> difference(Collection<T> a, Collection<T> b) {
        return Sets.union(Sets.less(a, b), Sets.less(b, a));
    }

    public static final <T> boolean areDisjoint(Collection<T> a, Collection<T> b) {
        Collection<T> big = a;
        Collection<T> small = b;
        if (a.size() < b.size()) {
            big = b;
            small = a;
        } else {
            big = a;
            small = b;
        }
        Iterator<T> i = small.iterator();
        while (i.hasNext()) {
            if (!big.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public static final <T> Set<Set<T>> powerset(Collection<T> a) {
        HashSet<Set<T>> result = new HashSet<Set<T>>();
        ArrayList<T> l = new ArrayList<T>(a);
        int i = 0;
        while (i < 1 << l.size()) {
            HashSet set = new HashSet();
            int j = 0;
            while (j < l.size()) {
                if ((i & 1 << j) != 0) {
                    set.add(l.get(j));
                }
                ++j;
            }
            result.add(set);
            ++i;
        }
        return result;
    }

    public static <T> Set<List<T>> permutations(Collection<T> s) {
        HashSet<List<T>> result = new HashSet<List<T>>();
        switch (s.size()) {
            case 0: {
                result.add(new ArrayList());
                break;
            }
            case 1: {
                result.add(new ArrayList<T>(s));
                break;
            }
            default: {
                for (T t : s) {
                    HashSet<T> rest = new HashSet<T>(s);
                    rest.remove(t);
                    for (List<T> sublist : Sets.permutations(rest)) {
                        sublist.add(t);
                        result.add(sublist);
                    }
                }
            }
        }
        return result;
    }

    public static <T> Set<T> asSet(T ... a) {
        HashSet<T> s = new HashSet<T>(a.length);
        T[] TArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            T e = TArray[n2];
            s.add(e);
            ++n2;
        }
        return s;
    }
}

