/*
 * Decompiled with CFR 0.152.
 */
package com.arm.math;

import com.arm.math.Point;
import java.util.Objects;

public final class Rectangle {
    private final Point centre;
    private final Point extent;

    public Rectangle(Point centre, Point extent) {
        if (extent.getX() < 0L || extent.getY() < 0L) {
            throw new IllegalArgumentException("Extents cannot be negative");
        }
        this.centre = centre;
        this.extent = extent;
    }

    public Point getCentre() {
        return this.centre;
    }

    public Point getExtent() {
        return this.extent;
    }

    public boolean contains(Point point) {
        return this.getDistanceFrom(point) <= 0.0;
    }

    public long getSquaredDistanceFrom(Point point) {
        long dx = Math.max(Math.abs(point.getX() - this.centre.getX()) - this.extent.getX(), 0L);
        long dy = Math.max(Math.abs(point.getY() - this.centre.getY()) - this.extent.getY(), 0L);
        return dx * dx + dy * dy;
    }

    public double getDistanceFrom(Point point) {
        return Math.sqrt(this.getSquaredDistanceFrom(point));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rectangle)) {
            return false;
        }
        Rectangle rectangle = (Rectangle)o;
        return Objects.equals(this.centre, rectangle.centre) && Objects.equals(this.extent, rectangle.extent);
    }

    public int hashCode() {
        return Objects.hash(this.centre, this.extent);
    }
}

