/*
 * Decompiled with CFR 0.152.
 */
package com.arm.math;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class Range<T extends Comparable<T>> {
    @Nullable
    private final T start;
    @Nullable
    private final T end;
    private final boolean startInclusive;
    private final boolean endInclusive;

    public Range(@Nullable T start, @Nullable T end, boolean startInclusive, boolean endInclusive) {
        if (start != null && end != null && start.compareTo(end) > 0) {
            throw new IllegalArgumentException("End before start");
        }
        if (!(start == null || end == null || start.compareTo(end) != 0 || startInclusive && endInclusive)) {
            throw new IllegalArgumentException("Single item range with exclusive bounds");
        }
        this.start = start;
        this.end = end;
        this.startInclusive = startInclusive;
        this.endInclusive = endInclusive;
    }

    static <T extends Comparable<T>> T min(@Nullable T a, @Nullable T b, boolean nullPositive) {
        if (a == null) {
            return nullPositive ? b : a;
        }
        if (b == null) {
            return nullPositive ? a : b;
        }
        return a.compareTo(b) <= 0 ? a : b;
    }

    static <T extends Comparable<T>> T max(@Nullable T a, @Nullable T b, boolean nullPositive) {
        if (a == null) {
            return nullPositive ? a : b;
        }
        if (b == null) {
            return nullPositive ? b : a;
        }
        return a.compareTo(b) >= 0 ? a : b;
    }

    @Nullable
    public T start() {
        return this.start;
    }

    @Nullable
    public T end() {
        return this.end;
    }

    public boolean startInclusive() {
        return this.startInclusive;
    }

    public boolean endInclusive() {
        return this.endInclusive;
    }

    public boolean isInfinite() {
        return this.start == null && this.end == null;
    }

    public boolean afterStart(@Nonnull T obj) {
        if (this.start == null) {
            return true;
        }
        if (this.startInclusive) {
            return this.start.compareTo(obj) <= 0;
        }
        return this.start.compareTo(obj) < 0;
    }

    public boolean beforeEnd(@Nonnull T obj) {
        if (this.end == null) {
            return true;
        }
        if (this.endInclusive) {
            return this.end.compareTo(obj) >= 0;
        }
        return this.end.compareTo(obj) > 0;
    }

    public boolean includes(@Nonnull T obj) {
        return this.afterStart(obj) && this.beforeEnd(obj);
    }

    @Nonnull
    public Optional<Range<T>> intersect(@Nonnull Range<T> other) {
        boolean newEndInclusive;
        T newEnd;
        boolean newStartInclusive;
        T newStart;
        if (Objects.equals(this.start, other.start)) {
            newStart = this.start;
            newStartInclusive = this.startInclusive && other.startInclusive;
        } else {
            newStart = Range.max(this.start, other.start, false);
            boolean bl = newStartInclusive = newStart == this.start ? this.startInclusive : other.startInclusive;
        }
        if (Objects.equals(this.end, other.end)) {
            newEnd = this.end;
            newEndInclusive = this.endInclusive && other.endInclusive;
        } else {
            newEnd = Range.min(this.end, other.end, true);
            boolean bl = newEndInclusive = newEnd == this.end ? this.endInclusive : other.endInclusive;
        }
        if (newStart != null && newEnd != null && newStart.compareTo(newEnd) > 0 || newStart != null && newEnd != null && newStart.compareTo(newEnd) == 0 && (!newStartInclusive || !newEndInclusive)) {
            return Optional.empty();
        }
        return Optional.of(new Range<T>(newStart, newEnd, newStartInclusive, newEndInclusive));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.startInclusive ? (char)'[' : '(');
        sb.append(this.start == null ? "" : this.start.toString());
        sb.append(',');
        sb.append(this.end == null ? "" : this.end.toString());
        sb.append(this.endInclusive ? (char)']' : ')');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Range) {
            Range other = (Range)obj;
            return Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && this.startInclusive == other.startInclusive && this.endInclusive == other.endInclusive;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.startInclusive, this.endInclusive);
    }
}

