/*
 * Decompiled with CFR 0.152.
 */
package com.arm.math;

import java.util.Objects;

public final class Point {
    private final long x;
    private final long y;

    public Point(long x, long y) {
        this.x = x;
        this.y = y;
    }

    public long getX() {
        return this.x;
    }

    public long getY() {
        return this.y;
    }

    public double distance(Point other) {
        return Math.sqrt(this.distanceSquared(other));
    }

    public long distanceSquared(Point other) {
        long x = other.x - this.x;
        long y = other.y - this.y;
        return x * x + y * y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point point = (Point)o;
        return this.x == point.x && this.y == point.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }
}

