/*
 * Decompiled with CFR 0.152.
 */
package com.arm.math;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class Maps {
    public static <K extends Comparable<K>, V extends Comparable<V>> int compare(Map<K, V> m1, Map<K, V> m2) {
        if (m1.size() != m2.size()) {
            return Integer.compare(m1.size(), m2.size());
        }
        TreeSet<K> sorted1 = new TreeSet<K>(m1.keySet());
        sorted1.addAll(m1.values());
        TreeSet<K> sorted2 = new TreeSet<K>(m2.keySet());
        sorted2.addAll(m2.values());
        Iterator<K> i2 = sorted2.iterator();
        for (Comparable k1 : sorted1) {
            Comparable k2;
            int c = k1.compareTo(k2 = (Comparable)i2.next());
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public static <K, T, C extends Collection<T>> Map<K, C> partitionIntoCollectionBy(Collection<T> c, Class<C> clazz, Keyer<K, T> keyer) {
        try {
            HashMap<K, Collection> result = new HashMap<K, Collection>();
            for (T item : c) {
                K key = keyer.getKey(item);
                if (!result.containsKey(key)) {
                    result.put(key, (Collection)clazz.newInstance());
                }
                ((Collection)result.get(key)).add(item);
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, T> Map<K, Set<T>> partitionIntoSetsBy(Collection<T> c, Keyer<K, T> keyer) {
        return Maps.partitionIntoCollectionBy(c, HashSet.class, keyer);
    }

    public static <K, T> Map<K, List<T>> partitionIntoListsBy(Collection<T> c, Keyer<K, T> keyer) {
        return Maps.partitionIntoCollectionBy(c, ArrayList.class, keyer);
    }

    public static <K, V extends Comparable<V>> List<K> getKeysInValueOrder(Map<K, V> map) {
        return Maps.getKeysInValueOrder(map, new Comparator<V>(){

            @Override
            public int compare(V o1, V o2) {
                return o1.compareTo(o2);
            }
        });
    }

    public static <K, V extends Comparable<V>> List<K> getKeysInValueOrder(Map<K, V> map, Comparator<V> comparator) {
        if (map.isEmpty()) {
            return new ArrayList();
        }
        ArrayList keys = new ArrayList();
        ArrayList<K> unsortedKeys = new ArrayList<K>(map.keySet());
        while (keys.size() < map.size()) {
            Object current = null;
            for (Object k : unsortedKeys) {
                if (current != null && ((Comparable)map.get(k)).compareTo((Comparable)map.get(current)) >= 0) continue;
                current = k;
            }
            keys.add(current);
            unsortedKeys.remove(current);
        }
        return keys;
    }

    public static <K, V> Map<V, K> invert(Map<K, V> map) {
        try {
            Map m = (Map)map.getClass().newInstance();
            for (Map.Entry<K, V> e : map.entrySet()) {
                m.put(e.getValue(), e.getKey());
            }
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Keyer<K, T> {
        public K getKey(T var1);
    }

    public static class MapComparator<K extends Comparable<K>, V extends Comparable<V>>
    implements Comparator<Map<K, V>>,
    Serializable {
        @Override
        public int compare(Map<K, V> m1, Map<K, V> m2) {
            return Maps.compare(m1, m2);
        }
    }

    public static interface Valuer {
        public Object getKey(Object var1);
    }
}

