/*
 * Decompiled with CFR 0.152.
 */
package com.arm.json;

import com.arm.json.IEncoder;
import com.arm.json.U64EncoderUtils;
import com.arm.json.U64Sequence;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;

public class U64JsonEncoder
implements IEncoder {
    @Override
    public U64Sequence encodeList(List<Object> objectList) {
        U64Sequence ret = new U64Sequence();
        for (Object obj : objectList) {
            ret.addAllItems(this.encode(obj).getSequence());
        }
        return ret;
    }

    @Override
    public U64Sequence encodeListUnsigned(List<Object> objectList) {
        U64Sequence ret = new U64Sequence();
        for (Object obj : objectList) {
            if (obj instanceof Long) {
                ret.addAllItems(this.encodeUnsigned((Long)obj).getSequence());
                continue;
            }
            ret.addAllItems(this.encode(obj).getSequence());
        }
        return ret;
    }

    public U64Sequence encode(Object[] obj) {
        U64Sequence ret = new U64Sequence();
        long toRet = -6917529027641081856L;
        ret.addItem(toRet |= (long)U64EncoderUtils.getContainerLength(obj));
        int length = Array.getLength(obj);
        ret.addItem(length);
        int i = 0;
        while (i < length) {
            Object o = Array.get(obj, i);
            ret = ret.addAllItems(this.encode(o).getSequence());
            ++i;
        }
        return ret;
    }

    public U64Sequence encode(int[] obj) {
        U64Sequence ret = new U64Sequence();
        long toRet = -6917529027641081856L;
        ret.addItem(toRet |= (long)U64EncoderUtils.getContainerLength(obj));
        int length = Array.getLength(obj);
        ret.addItem(length);
        int[] nArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            ret = ret.addAllItems(this.encode(i).getSequence());
            ++n2;
        }
        return ret;
    }

    public U64Sequence encode(long[] obj) {
        U64Sequence ret = new U64Sequence();
        long toRet = -6917529027641081856L;
        ret.addItem(toRet |= (long)U64EncoderUtils.getContainerLength(obj));
        int length = Array.getLength(obj);
        ret.addItem(length);
        long[] lArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            long i = lArray[n2];
            ret = ret.addAllItems(this.encode(i).getSequence());
            ++n2;
        }
        return ret;
    }

    public U64Sequence encode(byte[] obj) {
        U64Sequence ret = new U64Sequence();
        long toRet = -6917529027641081856L;
        ret.addItem(toRet |= (long)U64EncoderUtils.getContainerLength(obj));
        int length = Array.getLength(obj);
        ret.addItem(length);
        byte[] byArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            byte i = byArray[n2];
            ret = ret.addAllItems(this.encode(i).getSequence());
            ++n2;
        }
        return ret;
    }

    public U64Sequence encode(short[] obj) {
        U64Sequence ret = new U64Sequence();
        long toRet = -6917529027641081856L;
        ret.addItem(toRet |= (long)U64EncoderUtils.getContainerLength(obj));
        int length = Array.getLength(obj);
        ret.addItem(length);
        short[] sArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            short i = sArray[n2];
            ret = ret.addAllItems(this.encode(i).getSequence());
            ++n2;
        }
        return ret;
    }

    public U64Sequence encode(double[] obj) {
        U64Sequence ret = new U64Sequence();
        long toRet = -6917529027641081856L;
        ret.addItem(toRet |= (long)U64EncoderUtils.getContainerLength(obj));
        int length = Array.getLength(obj);
        ret.addItem(length);
        double[] dArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            double i = dArray[n2];
            ret = ret.addAllItems(this.encode(i).getSequence());
            ++n2;
        }
        return ret;
    }

    public U64Sequence encode(float[] obj) {
        U64Sequence ret = new U64Sequence();
        long toRet = -6917529027641081856L;
        ret.addItem(toRet |= (long)U64EncoderUtils.getContainerLength(obj));
        int length = Array.getLength(obj);
        ret.addItem(length);
        float[] fArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            float i = fArray[n2];
            ret = ret.addAllItems(this.encode(Float.valueOf(i)).getSequence());
            ++n2;
        }
        return ret;
    }

    public U64Sequence encode(Map<String, Object> obj) {
        U64Sequence ret = new U64Sequence();
        long toRet = -5764607523034234880L;
        ret.addItem(toRet |= (long)U64EncoderUtils.getContainerLength(obj));
        int length = obj.size();
        ret.addItem(length);
        for (Map.Entry<String, Object> entry : obj.entrySet()) {
            ret.addAllItems(this.encode(entry.getKey()).getSequence());
            ret.addAllItems(this.encode(entry.getValue()).getSequence());
        }
        return ret;
    }

    public U64Sequence encode(boolean obj) {
        U64Sequence ret = new U64Sequence();
        if (obj) {
            ret.addItem(-3530822107858468864L);
        } else {
            ret.addItem(-3602879701896396800L);
        }
        return ret;
    }

    public U64Sequence encode(String obj) {
        U64Sequence ret;
        block5: {
            byte[] objBytes;
            block3: {
                block4: {
                    ret = new U64Sequence();
                    objBytes = obj.getBytes();
                    if (objBytes.length > 255) break block3;
                    if (objBytes.length <= 7 || objBytes[6] < 32) break block4;
                    long toRet = 0L;
                    int startIndex = 6;
                    int endIndex = 0;
                    toRet = U64EncoderUtils.bytesToLongRevOrder(objBytes, startIndex, endIndex);
                    toRet <<= 8;
                    ret.addItem(toRet |= (long)obj.length());
                    endIndex = startIndex + 1;
                    startIndex += 8;
                    while (endIndex < objBytes.length) {
                        long newItem = 0L;
                        newItem = U64EncoderUtils.bytesToLongRevOrder(objBytes, startIndex, endIndex);
                        ret.addItem(newItem);
                        endIndex = startIndex + 1;
                        startIndex += 8;
                    }
                    break block5;
                }
                if (objBytes.length > 7) break block5;
                long toRet = 0L;
                toRet = U64EncoderUtils.bytesToLongRevOrder(objBytes, objBytes.length - 1, 0);
                if ((toRet <<= 8) <= 0x2000000000000000L) {
                    toRet |= 0x2000000000000000L;
                }
                ret.addItem(toRet |= (long)obj.length());
                break block5;
            }
            ret.addItem(0xCC00000000000000L | (long)obj.length());
            int endIndex = 0;
            int startIndex = 7;
            while (endIndex < objBytes.length) {
                long newItem = 0L;
                newItem = U64EncoderUtils.bytesToLongRevOrder(objBytes, startIndex, endIndex);
                ret.addItem(newItem);
                endIndex = startIndex + 1;
                startIndex += 8;
            }
        }
        return ret;
    }

    public U64Sequence encode(Number objNum) {
        U64Sequence ret = new U64Sequence();
        if (objNum instanceof Float || objNum instanceof Double) {
            ret.addItem(-3891110078048108544L);
            ret.addItem(Double.doubleToLongBits(objNum.doubleValue()));
            return ret;
        }
        long obj = objNum.longValue();
        if (Long.compareUnsigned(obj, 0L) >= 0 && Long.compareUnsigned(obj, 0xFFFFFFFFFFFFFFFL) <= 0) {
            ret.addItem(obj);
        } else if (Long.compareUnsigned(obj, -1152921504606846976L) >= 0 && Long.compareUnsigned(obj, -1L) <= 0) {
            obj &= 0xFFFFFFFFFFFFFFFL;
            ret.addItem(obj |= 0x1000000000000000L);
        } else if (Long.compareUnsigned(obj, -1152921504606846976L) >= 0 && Long.compareUnsigned(obj, -1L) <= 0) {
            ret.addItem(obj);
        } else if (obj >= Long.MIN_VALUE && obj <= -1152921504606846976L) {
            ret.addItem(-4539628424389459968L);
            ret.addItem(obj);
        } else if (Long.compareUnsigned(obj, 0x1000000000000000L) >= 0 && Long.compareUnsigned(obj, -1152921504606846977L) <= 0) {
            ret.addItem(-4611686018427387904L);
            ret.addItem(obj);
        }
        return ret;
    }

    @Override
    public U64Sequence encodeUnsigned(long obj) {
        U64Sequence ret = new U64Sequence();
        if (Long.compareUnsigned(obj, Long.MIN_VALUE) >= 0 && Long.compareUnsigned(obj, -1152921504606846977L) <= 0) {
            ret.addItem(-4611686018427387904L);
            ret.addItem(obj);
            return ret;
        }
        if (Long.compareUnsigned(obj, -1152921504606846976L) >= 0 && Long.compareUnsigned(obj, -1L) <= 0) {
            ret.addItem(obj);
            return ret;
        }
        return this.encode(obj);
    }

    @Override
    public U64Sequence encode(Object obj) {
        U64Sequence ret = new U64Sequence();
        if (obj == null) {
            ret.addItem(-3674937295934324736L);
            return ret;
        }
        if (obj.getClass().isArray()) {
            long toRet = -6917529027641081856L;
            ret.addItem(toRet |= (long)U64EncoderUtils.getContainerLength(obj));
            int length = Array.getLength(obj);
            ret.addItem(length);
            int i = 0;
            while (i < length) {
                Object o = Array.get(obj, i);
                ret = ret.addAllItems(this.encode(o).getSequence());
                ++i;
            }
            return ret;
        }
        if (obj instanceof String) {
            return this.encode((String)obj);
        }
        if (obj instanceof Number) {
            return this.encode((Number)obj);
        }
        if (obj instanceof Boolean) {
            return this.encode((Boolean)obj);
        }
        if (obj instanceof Map) {
            return this.encode((Map)obj);
        }
        return null;
    }
}

