/*
 * Decompiled with CFR 0.152.
 */
package com.arm.json;

import java.util.Map;

public class U64EncoderUtils {
    protected static final long XF_UPPER = -1L;
    protected static final long X1_BOTTOM = -1152921504606846976L;
    protected static final long XC0_BOTTOM = 0x1000000000000000L;
    protected static final long XC0_UPPER = -1152921504606846977L;
    protected static final long XC1_UPPER = -1152921504606846976L;
    protected static final long XC1_BOTTOM = Long.MIN_VALUE;
    protected static final long NULL_U64JSON = -3674937295934324736L;
    protected static final long BOOLEAN_TRUE_U64JSON = -3530822107858468864L;
    protected static final long BOOLEAN_FALSE_U64JSON = -3602879701896396800L;
    protected static final long XF_BOTTOM = -1152921504606846976L;
    protected static final long ZERO = 0L;
    protected static final long X1 = 0x1000000000000000L;
    protected static final long X2 = 0x2000000000000000L;
    protected static final long X8 = Long.MIN_VALUE;
    protected static final long X9 = -8070450532247928832L;
    protected static final long XA = -6917529027641081856L;
    protected static final long XB = -5764607523034234880L;
    protected static final long XC0 = -4611686018427387904L;
    protected static final long XC1 = -4539628424389459968L;
    protected static final long XC2 = -4467570830351532032L;
    protected static final long XCA = -3891110078048108544L;
    protected static final long XCB = -3819052484010180608L;
    protected static final long XCC = -3746994889972252672L;
    protected static final long XCD = -3674937295934324736L;
    protected static final long XCE = -3602879701896396800L;
    protected static final long XCF = -3530822107858468864L;
    protected static final long XD = 0xD00000000000000L;
    protected static final long XE = 0xE00000000000000L;
    protected static final long XF = 0xF00000000000000L;

    public static long bytesToLongRevOrder(byte[] b, int startIndex, int endIndex) {
        long result = 0L;
        int i = startIndex;
        while (i >= endIndex) {
            if (i < b.length) {
                result <<= 8;
                result |= (long)(b[i] & 0xFF);
            }
            --i;
        }
        return result;
    }

    public static String bytesToString(byte[] strBytes) {
        StringBuilder str = new StringBuilder();
        int i = strBytes.length - 1;
        while (i >= 0) {
            if (strBytes[i] != 0) {
                str.append((char)strBytes[i]);
            }
            --i;
        }
        return str.toString();
    }

    public static int getContainerLength(Number obj) {
        if (obj instanceof Double || obj instanceof Float) {
            return 2;
        }
        if (obj instanceof Long) {
            Long num = (Long)obj;
            if (Long.compareUnsigned(num, 0L) >= 0 && Long.compareUnsigned(num, 0xFFFFFFFFFFFFFFFL) <= 0) {
                return 1;
            }
            if (Long.compareUnsigned(num, -1152921504606846976L) >= 0 && Long.compareUnsigned(num, -1L) <= 0) {
                return 2;
            }
            if (Long.compareUnsigned(num, -1152921504606846976L) >= 0 && Long.compareUnsigned(num, -1L) <= 0) {
                return 1;
            }
            if (num >= Long.MIN_VALUE && num <= -1152921504606846976L) {
                return 2;
            }
            if (Long.compareUnsigned(num, 0x1000000000000000L) >= 0 && Long.compareUnsigned(num, -1152921504606846977L) <= 0) {
                return 2;
            }
            return 1;
        }
        return 1;
    }

    public static int getContainerLength(boolean obj) {
        return 1;
    }

    public static int getContainerLength(char obj) {
        return 1;
    }

    public static int getContainerLength(String obj) {
        if (obj == null) {
            return 0;
        }
        byte[] objByte = obj.getBytes();
        if (objByte.length <= 255 && (objByte.length <= 6 || (long)objByte[6] >= 32L)) {
            return (objByte.length >> 3) + 1;
        }
        return objByte.length + 15 >> 3;
    }

    public static int getContainerLength(int[] obj) {
        int sum = 2;
        int[] nArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            int o = nArray[n2];
            sum += U64EncoderUtils.getContainerLength(o);
            ++n2;
        }
        return sum;
    }

    public static int getContainerLength(byte[] obj) {
        int sum = 2;
        byte[] byArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            byte o = byArray[n2];
            sum += U64EncoderUtils.getContainerLength(o);
            ++n2;
        }
        return sum;
    }

    public static int getContainerLength(short[] obj) {
        int sum = 2;
        short[] sArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            short o = sArray[n2];
            sum += U64EncoderUtils.getContainerLength(o);
            ++n2;
        }
        return sum;
    }

    public static int getContainerLength(long[] obj) {
        int sum = 2;
        long[] lArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            long o = lArray[n2];
            sum += U64EncoderUtils.getContainerLength(o);
            ++n2;
        }
        return sum;
    }

    public static int getContainerLength(String[] obj) {
        int sum = 2;
        String[] stringArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            String o = stringArray[n2];
            sum += U64EncoderUtils.getContainerLength(o);
            ++n2;
        }
        return sum;
    }

    public static int getContainerLength(char[] obj) {
        int sum = 2;
        char[] cArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            char o = cArray[n2];
            sum += U64EncoderUtils.getContainerLength(o);
            ++n2;
        }
        return sum;
    }

    public static int getContainerLength(float[] obj) {
        int sum = 2;
        float[] fArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            float o = fArray[n2];
            sum += U64EncoderUtils.getContainerLength(Float.valueOf(o));
            ++n2;
        }
        return sum;
    }

    public static int getContainerLength(boolean[] obj) {
        int sum = 2;
        boolean[] blArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            boolean o = blArray[n2];
            sum += U64EncoderUtils.getContainerLength(o);
            ++n2;
        }
        return sum;
    }

    public static int getContainerLength(double[] obj) {
        int sum = 2;
        double[] dArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            double o = dArray[n2];
            sum += U64EncoderUtils.getContainerLength(o);
            ++n2;
        }
        return sum;
    }

    public static int getContainerLength(Object[] obj) {
        int sum = 2;
        Object[] objectArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sum += U64EncoderUtils.getContainerLength(o);
            ++n2;
        }
        return sum;
    }

    public static int getContainerLength(Map<String, Object> obj) {
        int sum = 2;
        for (Map.Entry<String, Object> entry : obj.entrySet()) {
            sum += U64EncoderUtils.getContainerLength(entry.getKey());
            sum += U64EncoderUtils.getContainerLength(entry.getValue());
        }
        return sum;
    }

    public static int getContainerLength(Object obj) {
        if (obj == null) {
            return 1;
        }
        if (obj instanceof Number) {
            return U64EncoderUtils.getContainerLength((Number)obj);
        }
        if (obj instanceof String) {
            return U64EncoderUtils.getContainerLength((String)obj);
        }
        if (obj.getClass().isArray()) {
            int sum = 2;
            if (obj instanceof Object[]) {
                Object[] objectArray = (Object[])obj;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    sum += U64EncoderUtils.getContainerLength(o);
                    ++n2;
                }
            } else if (obj instanceof int[]) {
                int[] nArray = (int[])obj;
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int o = nArray[n3];
                    sum += U64EncoderUtils.getContainerLength(o);
                    ++n3;
                }
            } else if (obj instanceof long[]) {
                long[] lArray = (long[])obj;
                int n = lArray.length;
                int n4 = 0;
                while (n4 < n) {
                    long o = lArray[n4];
                    sum += U64EncoderUtils.getContainerLength(o);
                    ++n4;
                }
            } else if (obj instanceof String[]) {
                String[] stringArray = (String[])obj;
                int n = stringArray.length;
                int n5 = 0;
                while (n5 < n) {
                    String o = stringArray[n5];
                    sum += U64EncoderUtils.getContainerLength(o);
                    ++n5;
                }
            } else if (obj instanceof char[]) {
                char[] cArray = (char[])obj;
                int n = cArray.length;
                int n6 = 0;
                while (n6 < n) {
                    char o = cArray[n6];
                    sum += U64EncoderUtils.getContainerLength(o);
                    ++n6;
                }
            } else if (obj instanceof double[]) {
                double[] dArray = (double[])obj;
                int n = dArray.length;
                int n7 = 0;
                while (n7 < n) {
                    double o = dArray[n7];
                    sum += U64EncoderUtils.getContainerLength(o);
                    ++n7;
                }
            } else if (obj instanceof float[]) {
                float[] fArray = (float[])obj;
                int n = fArray.length;
                int n8 = 0;
                while (n8 < n) {
                    float o = fArray[n8];
                    sum += U64EncoderUtils.getContainerLength(Float.valueOf(o));
                    ++n8;
                }
            } else if (obj instanceof boolean[]) {
                boolean[] blArray = (boolean[])obj;
                int n = blArray.length;
                int n9 = 0;
                while (n9 < n) {
                    boolean o = blArray[n9];
                    sum += U64EncoderUtils.getContainerLength(o);
                    ++n9;
                }
            } else if (obj instanceof byte[]) {
                byte[] byArray = (byte[])obj;
                int n = byArray.length;
                int n10 = 0;
                while (n10 < n) {
                    byte o = byArray[n10];
                    sum += U64EncoderUtils.getContainerLength(o);
                    ++n10;
                }
            } else if (obj instanceof short[]) {
                short[] sArray = (short[])obj;
                int n = sArray.length;
                int n11 = 0;
                while (n11 < n) {
                    short o = sArray[n11];
                    sum += U64EncoderUtils.getContainerLength(o);
                    ++n11;
                }
            }
            return sum;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            int sum = 2;
            for (Map.Entry entry : map.entrySet()) {
                sum += U64EncoderUtils.getContainerLength((String)entry.getKey());
                sum += U64EncoderUtils.getContainerLength(entry.getValue());
            }
            return sum;
        }
        return 0;
    }
}

