/*
 * Decompiled with CFR 0.152.
 */
package com.arm.json;

import com.arm.math.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;

public class JSONValidator {
    private static final Pattern validNumber = Pattern.compile("-?(0|([1-9][0-9]*))(\\.[0-9]+)?((e|E)(-|\\+)?[0-9]+)?");
    private static final Pattern validString = Pattern.compile("\"([^\\\\\"]|(\\\\(\"|\\\\|/|b|f|n|r|t|u([0-9a-fA-F]{4}))))*\"");
    private static Set<String> validTokens = Sets.asSet("{", "}", "[", "]", ",", ":", "true", "false", "null");
    private static Set<String> whitespace = Sets.asSet(" ", "\t", "\n", "\r");

    public static boolean validate(String s) {
        ArrayDeque<String> tokens = new ArrayDeque<String>(JSONValidator.tokenise(s));
        try {
            JSONValidator.parseObjectOrArray(tokens);
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        return tokens.isEmpty();
    }

    private static void consumeToken(Deque<String> tokens, String expected) {
        try {
            if (!tokens.removeFirst().equals(expected)) {
                throw new IllegalStateException();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalStateException();
        }
    }

    private static void parseObjectOrArray(Deque<String> tokens) {
        if ("[".equals(tokens.peekFirst())) {
            JSONValidator.parseArray(tokens);
        } else if ("{".equals(tokens.peekFirst())) {
            JSONValidator.parseObject(tokens);
        } else {
            throw new IllegalStateException();
        }
    }

    private static void parseArray(Deque<String> tokens) {
        JSONValidator.consumeToken(tokens, "[");
        boolean commaConsumed = false;
        while (!"]".equals(tokens.peekFirst())) {
            if (commaConsumed) {
                JSONValidator.consumeToken(tokens, ",");
            }
            JSONValidator.parseValue(tokens);
            commaConsumed = true;
        }
        JSONValidator.consumeToken(tokens, "]");
    }

    private static void parseObject(Deque<String> tokens) {
        JSONValidator.consumeToken(tokens, "{");
        boolean more = !"}".equals(tokens.peekFirst());
        while (more) {
            String s = tokens.removeFirst();
            if (!JSONValidator.isString(s)) {
                throw new IllegalStateException();
            }
            JSONValidator.consumeToken(tokens, ":");
            JSONValidator.parseValue(tokens);
            if (",".equals(tokens.peekFirst())) {
                tokens.removeFirst();
                continue;
            }
            more = false;
        }
        JSONValidator.consumeToken(tokens, "}");
    }

    private static void parseValue(Deque<String> tokens) {
        String t = tokens.peekFirst();
        if (t == null) {
            throw new IllegalStateException();
        }
        if (JSONValidator.isString(t) || JSONValidator.isNumber(t) || t.equals("true") || t.equals("false") || t.equals("null")) {
            tokens.removeFirst();
        } else if (t.equals("[")) {
            JSONValidator.parseArray(tokens);
        } else if (t.equals("{")) {
            JSONValidator.parseObject(tokens);
        } else {
            throw new IllegalStateException();
        }
    }

    private static boolean isString(String s) {
        return validString.matcher(s).matches();
    }

    private static boolean isNumber(String s) {
        return validNumber.matcher(s).matches();
    }

    private static List<String> tokenise(String str) {
        int i = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder s = new StringBuilder();
        while (i < str.length()) {
            s.append(str.charAt(i));
            ++i;
            StringBuilder token = new StringBuilder(s.toString());
            if (whitespace.contains(token.toString())) {
                s.setLength(0);
                continue;
            }
            if (validTokens.contains(token.toString())) {
                tokens.add(token.toString());
                s.setLength(0);
                continue;
            }
            if (JSONValidator.isNumber(token.toString())) {
                while (i < str.length()) {
                    String n = Character.toString(str.charAt(i));
                    if (whitespace.contains(n) || ",".equals(n) || "]".equals(n) || "}".equals(n)) break;
                    token.append(n);
                    ++i;
                }
                tokens.add(token.toString());
                s.setLength(0);
                continue;
            }
            if (!JSONValidator.isString(token.toString())) continue;
            tokens.add(token.toString());
            s.setLength(0);
        }
        if (s.length() > 0) {
            tokens.add(s.toString());
        }
        return tokens;
    }
}

