/*
 * Decompiled with CFR 0.152.
 */
package com.arm.jni;

import com.arm.jni.NativeLoadException;
import com.arm.jni.NativeLoaderHelper;
import com.arm.util.URLResolver;
import java.io.File;
import java.net.URL;

public abstract class NativeLoader {
    private boolean isNativeLoaded = false;
    public final String OS_QUALIFIER = String.valueOf(this.getOSName()) + "." + NativeLoader.getArchName();
    public final String OS_PATH = String.valueOf(this.getOSName()) + "/" + NativeLoader.getArchName();

    private static String getArchName() {
        String arch = System.getProperty("os.arch").toLowerCase();
        if (arch.startsWith("amd64")) {
            arch = "x86_64";
        } else if (arch.startsWith("aarch64")) {
            arch = "armv8l_64";
        }
        return arch;
    }

    protected String getOSName() {
        return NativeLoaderHelper.getOSName();
    }

    protected abstract Class<?> getResourceLoader();

    protected abstract String[] getPlatformLibs() throws NativeLoadException;

    protected abstract void load(String var1);

    protected void loadJNI() throws Exception {
        String[] platformLibs = this.getPlatformLibs();
        String jniLib = platformLibs[platformLibs.length - 1];
        URL jnilibURL = this.getResourceLoader().getResource(String.valueOf(this.OS_PATH) + "/" + jniLib);
        if (jnilibURL == null) {
            throw new NativeLoadException("Cannot locate library for " + this.OS_QUALIFIER);
        }
        URL libURL = new URL(jnilibURL.getProtocol(), jnilibURL.getHost(), new File(jnilibURL.getPath()).getParent().replace("\\", "/"));
        File libDir = URLResolver.resolve(libURL);
        String[] stringArray = platformLibs;
        int n = platformLibs.length;
        int n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            File libPath = new File(libDir, lib);
            this.load(libPath.getAbsolutePath());
            ++n2;
        }
        this.postLoadProcessing(libURL, libDir);
    }

    protected void postLoadProcessing(URL libURL, File libDir) throws NativeLoadException {
    }

    protected void ensureLibrariesLoaded() throws Exception {
        if (!this.isNativeLoaded) {
            this.loadJNI();
            this.isNativeLoaded = true;
        }
    }
}

