/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import com.arm.io.FileUtils;
import com.arm.util.NumberUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLParser
implements Closeable {
    private static final String SEPARATOR = "\u0000";
    private static final byte[] XML_MARKER = new byte[]{60, 63, 120, 109, 108};
    private InputStream mStream;
    private XMLStreamReader mReader;
    private int mDepth;
    private String mMarker;

    public static XMLParser create(File file) throws IOException {
        return XMLParser.create(new FileInputStream(FileUtils.getFile(file)));
    }

    public static XMLParser create(InputStream stream) throws IOException {
        byte[] buffer = new byte[XML_MARKER.length];
        FilterInputStream in = new BufferedInputStream(stream);
        ((InputStream)in).mark(XML_MARKER.length);
        int amt = ((InputStream)in).read(buffer, 0, XML_MARKER.length);
        ((InputStream)in).reset();
        if (amt == XML_MARKER.length) {
            int i = 0;
            while (i < XML_MARKER.length) {
                if (XML_MARKER[i] != buffer[i]) {
                    amt = 0;
                    break;
                }
                ++i;
            }
        }
        if (amt != XML_MARKER.length) {
            in = new GZIPInputStream(in);
        }
        return new XMLParser(in);
    }

    public XMLParser(InputStream stream) throws IOException {
        this.mStream = stream;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        try {
            this.mReader = factory.createXMLStreamReader(stream);
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public Location getLocation() {
        return this.mReader.getLocation();
    }

    public String getLocationAsString() {
        Location location = this.mReader.getLocation();
        return String.valueOf(location.getLineNumber()) + ":" + location.getColumnNumber();
    }

    public String getMarker() {
        return this.mMarker;
    }

    public String getCurrentTag() {
        return this.mReader.getLocalName();
    }

    public String nextTag() throws IOException {
        return this.nextTag(null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String nextTag(String marker) throws IOException {
        try {
            block8: while (true) {
                if (!this.mReader.hasNext()) {
                    return null;
                }
                switch (this.mReader.next()) {
                    case 1: {
                        name = this.mReader.getLocalName();
                        this.mMarker = String.valueOf(this.mDepth++) + "\u0000" + name;
                        return name;
                    }
                    case 2: {
                        this.mMarker = String.valueOf(--this.mDepth) + "\u0000" + this.mReader.getLocalName();
                        if (marker == null || !marker.equals(this.mMarker)) continue block8;
                        return null;
                    }
                    case 7: {
                        this.mMarker = null;
                        if (marker == null) ** break;
                        return null;
                    }
                    case 8: {
                        this.mMarker = null;
                        return null;
                    }
                }
            }
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public void skip() throws IOException {
        this.skip(this.getMarker());
    }

    public void skip(String marker) throws IOException {
        while (this.nextTag(marker) != null) {
        }
    }

    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    public String getAttribute(String name) {
        return this.mReader.getAttributeValue(null, name);
    }

    public String getAttribute(String name, String def) {
        String value = this.getAttribute(name);
        return value != null ? value : def;
    }

    public boolean isAttributeSet(String name) {
        return this.isAttributeSet(name, false);
    }

    public boolean isAttributeSet(String name, boolean def) {
        return NumberUtils.getBoolean(this.getAttribute(name, Boolean.toString(def)));
    }

    public int getIntegerAttribute(String name) {
        return this.getIntegerAttribute(name, 0);
    }

    public int getIntegerAttribute(String name, int def) {
        return NumberUtils.getNonLocalizedInteger(this.getAttribute(name), def);
    }

    public long getLongAttribute(String name) {
        return this.getLongAttribute(name, 0L);
    }

    public long getLongAttribute(String name, long def) {
        return NumberUtils.getNonLocalizedLong(this.getAttribute(name), def);
    }

    public double getDoubleAttribute(String name) {
        return this.getDoubleAttribute(name, 0.0);
    }

    public double getDoubleAttribute(String name, double def) {
        return NumberUtils.getNonLocalizedDouble(this.getAttribute(name), def);
    }

    public int getAttributeCount() {
        return this.mReader.getAttributeCount();
    }

    public String getAttributeName(int index) {
        return this.mReader.getAttributeLocalName(index);
    }

    public String getAttributeValue(int index) {
        return this.mReader.getAttributeValue(index);
    }

    public String getText() throws IOException {
        try {
            String text = this.mReader.getElementText();
            this.mMarker = String.valueOf(--this.mDepth) + SEPARATOR + this.mReader.getLocalName();
            return text;
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public void close() throws IOException {
        IOException ioe;
        block10: {
            ioe = null;
            try {
                try {
                    if (this.mReader != null) {
                        this.mReader.close();
                    }
                }
                catch (XMLStreamException exception) {
                    ioe = new IOException(exception);
                    this.mReader = null;
                    if (this.mStream != null) {
                        this.mStream.close();
                    }
                    this.mStream = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.mReader = null;
                if (this.mStream != null) {
                    this.mStream.close();
                }
                this.mStream = null;
                throw throwable;
            }
            this.mReader = null;
            if (this.mStream != null) {
                this.mStream.close();
            }
            this.mStream = null;
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

