/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import com.arm.util.NumberUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLGenerator
implements Closeable {
    private OutputStream mStream;
    private String mEncoding;
    private String mIndent = "\t";
    private XMLStreamWriter mWriter;
    private int mDepth;
    private boolean mHadText;

    public XMLGenerator(OutputStream stream) throws IOException {
        this(stream, "UTF-8");
    }

    public XMLGenerator(OutputStream stream, String encoding) throws IOException {
        this.mStream = stream;
        this.mEncoding = encoding;
        try {
            this.mWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(stream, encoding);
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public String getIndent() {
        return this.mIndent;
    }

    public void setIndent(String indent) {
        this.mIndent = indent;
    }

    public void startDocument() throws IOException {
        try {
            this.mWriter.writeStartDocument(this.mEncoding, "1.0");
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public void endDocument() throws IOException {
        try {
            this.mWriter.writeEndDocument();
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    private void eol() throws IOException {
        try {
            this.mWriter.writeCharacters("\n");
            int i = 0;
            while (i < this.mDepth) {
                this.mWriter.writeCharacters(this.mIndent);
                ++i;
            }
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public void startTag(String name) throws IOException {
        try {
            this.eol();
            this.mWriter.writeStartElement(name);
            ++this.mDepth;
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public void startEmptyTag(String name) throws IOException {
        try {
            this.eol();
            this.mWriter.writeEmptyElement(name);
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public void endTag() throws IOException {
        try {
            --this.mDepth;
            if (!this.mHadText) {
                this.eol();
            } else {
                this.mHadText = false;
            }
            this.mWriter.writeEndElement();
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public void addAttribute(String name, String value) throws IOException {
        try {
            this.mWriter.writeAttribute(name, value == null ? "" : value);
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public void addAttribute(String name, boolean value) throws IOException {
        try {
            this.mWriter.writeAttribute(name, value ? "yes" : "no");
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public void addAttribute(String name, int value) throws IOException {
        try {
            this.mWriter.writeAttribute(name, Integer.toString(value));
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public void addAttribute(String name, long value) throws IOException {
        try {
            this.mWriter.writeAttribute(name, Long.toString(value));
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public void addAttribute(String name, double value) throws IOException {
        try {
            this.mWriter.writeAttribute(name, NumberUtils.trimTrailingZerosAfterDecimal(Double.toString(value), false));
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public void addAttributeNotEmpty(String name, String value) throws IOException {
        if (value != null && value.length() > 0) {
            try {
                this.mWriter.writeAttribute(name, value);
            }
            catch (XMLStreamException exception) {
                throw new IOException(exception);
            }
        }
    }

    public void addAttributeNot(String name, String value, String not) throws IOException {
        if (not != null ? !not.equals(value) : value != null) {
            this.addAttribute(name, value);
        }
    }

    public void addAttributeNot(String name, boolean value, boolean not) throws IOException {
        if (value != not) {
            this.addAttribute(name, value);
        }
    }

    public void addAttributeNot(String name, int value, int not) throws IOException {
        if (value != not) {
            this.addAttribute(name, value);
        }
    }

    public void addAttributeNot(String name, long value, long not) throws IOException {
        if (value != not) {
            this.addAttribute(name, value);
        }
    }

    public void addAttributeNot(String name, double value, double not) throws IOException {
        if (value != not) {
            this.addAttribute(name, value);
        }
    }

    public void addText(String text) throws IOException {
        try {
            this.mWriter.writeCharacters(text);
            this.mHadText = true;
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    public void comment(String comment) throws IOException {
        try {
            this.eol();
            this.mWriter.writeComment(String.valueOf(' ') + comment + ' ');
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mWriter != null) {
            IOException ioe;
            block7: {
                ioe = null;
                try {
                    try {
                        this.mWriter.writeCharacters("\n");
                        this.mWriter.close();
                    }
                    catch (XMLStreamException exception) {
                        ioe = new IOException(exception);
                        this.mWriter = null;
                        this.mStream.close();
                        this.mStream = null;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.mWriter = null;
                    this.mStream.close();
                    this.mStream = null;
                    throw throwable;
                }
                this.mWriter = null;
                this.mStream.close();
                this.mStream = null;
            }
            if (ioe != null) {
                throw ioe;
            }
        }
    }
}

