/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import com.arm.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;

public class TextFileUtils {
    public static List<String> readContent(File file) throws IOException {
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
        }
        finally {
            Files.closeIgnoringExceptions(reader);
        }
        return lines;
    }

    public static List<String> readContent(Path path) throws IOException {
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader reader = java.nio.file.Files.newBufferedReader(path);
        try {
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
        }
        finally {
            Files.closeIgnoringExceptions(reader);
        }
        return lines;
    }

    public static void writeContent(Path path, List<String> lines) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
        }
    }
}

