/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class RewindableWriter
extends Writer {
    private boolean closed;
    private Writer wrappedWriter;
    private boolean holding;
    private CharArrayWriter buffer;

    public RewindableWriter(OutputStream out) {
        this.wrappedWriter = new BufferedWriter(new OutputStreamWriter(out));
        this.buffer = new CharArrayWriter();
        this.holding = false;
        this.closed = false;
    }

    public RewindableWriter(Writer out) {
        this.wrappedWriter = out;
        this.buffer = new CharArrayWriter();
        this.holding = false;
        this.closed = false;
    }

    public String getHeld() throws IOException {
        if (this.closed) {
            throw new IOException("writer is closed");
        }
        if (this.holding) {
            return this.buffer.toString();
        }
        return "";
    }

    public void hold() throws IOException {
        if (this.closed) {
            throw new IOException("writer is closed");
        }
        this.holding = true;
    }

    public void release() throws IOException {
        if (this.closed) {
            throw new IOException("writer is closed");
        }
        this.holding = false;
    }

    public void discard() throws IOException {
        if (this.closed) {
            throw new IOException("writer is closed");
        }
        if (this.buffer.size() > 1024) {
            this.buffer = new CharArrayWriter();
        } else {
            this.buffer.reset();
        }
    }

    public void commit() throws IOException {
        if (this.closed) {
            throw new IOException("writer is closed");
        }
        this.holding = false;
        this.buffer.writeTo(this.wrappedWriter);
        this.buffer.flush();
        this.discard();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.wrappedWriter.close();
        this.buffer = null;
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("writer is closed");
        }
        this.wrappedWriter.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("writer is closed");
        }
        if (this.holding) {
            this.buffer.write(cbuf, off, len);
        } else {
            this.wrappedWriter.write(cbuf, off, len);
        }
    }

    public String toString() {
        return "RewindableWriter(written: " + this.wrappedWriter + ", buffered: " + (this.holding ? this.buffer.toString() : "<not buffering>") + ")";
    }
}

