/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import com.arm.io.InterruptibleInputStream;
import com.arm.io.ProcessEndOfStreamListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;

public final class ProcessWrapper
extends Process {
    private final Process process;
    public final PrintWriter in;
    public final BufferedReader out;
    public final BufferedReader err;
    private final InputStream processInputStream;
    private final InputStream processErrorStream;
    private final ProcessEndOfStreamListener eosListener;

    public ProcessWrapper(Process process) {
        this.process = process;
        this.eosListener = new ProcessEndOfStreamListener(process);
        this.processInputStream = new InterruptibleInputStream(process.getInputStream(), this.eosListener);
        this.processErrorStream = new InterruptibleInputStream(process.getErrorStream(), this.eosListener);
        this.in = new PrintWriter(this.getOutputStream(), true);
        this.out = new BufferedReader(new InputStreamReader(this.getInputStream()));
        this.err = new BufferedReader(new InputStreamReader(this.getErrorStream()));
    }

    @Override
    public void destroy() {
        this.process.destroy();
    }

    @Override
    public int exitValue() {
        return this.process.exitValue();
    }

    @Override
    public InputStream getInputStream() {
        return this.processInputStream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.processErrorStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    public boolean hasExited() {
        return this.eosListener.isDepleted();
    }

    ProcessEndOfStreamListener getProcessEndOfStreamListener() {
        return this.eosListener;
    }

    public long getPid() {
        return this.process.pid();
    }
}

