/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import com.arm.io.Messages;
import com.arm.shell.Shell;
import com.arm.shell.ShellException;
import com.arm.util.HostInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Paths {
    private static final Pattern windowsDriveSpecPattern = Pattern.compile("([A-Za-z]:).*");
    private static final Pattern envVarRegex = Pattern.compile("\\$([\\(\\):=_\\w]+)|\\$\\{(.+?)\\}|%(.+?)%");
    private static Map<String, File> user2home = new HashMap<String, File>();

    public static List<String> pathToList(File path) {
        String driveSpec;
        ArrayList<String> result = new ArrayList<String>();
        File f = path;
        while (f != null) {
            String name = f.getName();
            if (name.length() != 0) {
                result.add(0, name);
            }
            f = f.getParentFile();
        }
        if (path.isAbsolute() && HostInfo.isWindows() && (driveSpec = Paths.getDriveSpecifier(path)) != null) {
            result.add(0, driveSpec);
        }
        return result;
    }

    private static String getDriveSpecifier(File path) {
        Matcher m = windowsDriveSpecPattern.matcher(path.getAbsolutePath());
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public static List<String> pathToList(String path) {
        return Arrays.asList(path.split("(/|\\\\)+"));
    }

    public static File listToPath(List<String> l) {
        StringBuffer s = new StringBuffer();
        Iterator<String> i = l.iterator();
        while (i.hasNext()) {
            s.append(i.next());
            s.append(i.hasNext() ? File.separator : "");
        }
        return new File(s.toString());
    }

    public static String componentsToPath(List<String> components, int maxComponent) {
        StringBuffer s = new StringBuffer();
        int i = maxComponent;
        while (i >= 0) {
            s.append(components.get(i));
            s.append(File.separator);
            --i;
        }
        s.setLength(s.length() - 1);
        return s.toString();
    }

    public static File normalize(File path) {
        File result = Paths.listToPath(Paths.normalize(Paths.pathToList(path)));
        if (HostInfo.isUnix() && path.isAbsolute()) {
            result = new File("", result.getPath());
        }
        return result;
    }

    @Deprecated
    public static List<String> normalize(List<String> l) {
        ArrayList<String> result = new ArrayList<String>();
        for (String element : l) {
            if (element.equals("..")) {
                if (result.size() > 0) {
                    String before = (String)result.get(result.size() - 1);
                    if (!before.equals("..")) {
                        result.remove(result.size() - 1);
                        continue;
                    }
                    result.add(element);
                    continue;
                }
                result.add(element);
                continue;
            }
            result.add(element);
        }
        return result;
    }

    public static boolean startsWith(File path, String subpath) {
        List<String> toMatch = Paths.pathToList(subpath);
        List<String> pathList = Paths.pathToList(path);
        return pathList.size() >= toMatch.size() && pathList.subList(0, toMatch.size()).equals(toMatch);
    }

    public static File getRelativeTo(File base, File friend) {
        if (base.equals(friend)) {
            return new File("");
        }
        StringBuilder result = new StringBuilder();
        File theBase = null;
        theBase = base;
        while (theBase != null && !Paths.startsWith(theBase, friend)) {
            result.append("../");
            theBase = theBase.getParentFile();
        }
        if (theBase == null) {
            throw new RuntimeException(Messages.PATH_NOT_RELATIVE_TO_BASE.getLocalisedValue(String.valueOf(base.getAbsolutePath()) + " " + friend.getAbsolutePath() + " " + result));
        }
        String absB = theBase.getAbsolutePath();
        String absF = friend.getAbsolutePath();
        if (!absB.endsWith(File.separator)) {
            absB = String.valueOf(absB) + File.separator;
        }
        return new File(result + absF.substring(absB.length()));
    }

    private static boolean startsWith(File prefix, File candidate) {
        String sb = prefix.getAbsolutePath();
        String sbp = candidate.getAbsolutePath();
        if (!sb.endsWith(File.separator)) {
            sb = String.valueOf(sb) + File.separator;
        }
        return sbp.startsWith(sb);
    }

    public static File expandFilename(File path, Map<String, String> customEnvVars) throws IOException {
        return Paths.expandFilename(path.getPath(), customEnvVars);
    }

    public static File expandFilename(String path) {
        Map<String, String> emptyVars = Collections.emptyMap();
        return Paths.expandFilename(path, emptyVars);
    }

    public static File expandFilename(String path, Map<String, String> customEnvVars) {
        if (path.startsWith("~/") || path.startsWith("~\\") || path.equals("~")) {
            File home = HostInfo.getHome();
            if (home != null) {
                path = path.equals("~") ? home.getPath() : new File(home, path.substring(2)).getPath();
            }
        } else if (path.startsWith("~")) {
            int i1 = path.indexOf("/");
            int i2 = path.indexOf("\\");
            if (i2 < i1 && i2 != -1) {
                i1 = i2;
            }
            String name = i1 != -1 ? path.substring(1, i1) : path.substring(1);
            File dir = null;
            if (user2home.containsKey(name)) {
                dir = user2home.get(name);
            } else if (HostInfo.isUnix()) {
                try {
                    Shell s = new Shell(null, "ls -d ~" + name);
                    if (s.executeAndWait() == 0) {
                        dir = new File(s.getStdout().trim());
                    }
                }
                catch (ShellException shellException) {}
            } else {
                String username = System.getProperty("user.name");
                if (username != null && username.equals(name)) {
                    dir = HostInfo.getHome();
                }
            }
            user2home.put(name, dir);
            if (dir != null) {
                path = i1 == -1 ? dir.getPath() : String.valueOf(dir.getPath()) + path.substring(i1 + 1);
            }
        }
        Matcher m = envVarRegex.matcher(path);
        int start = 0;
        while (m.find(start)) {
            String val;
            String var = m.group(1);
            if (var == null) {
                var = m.group(2);
            }
            if (var == null) {
                var = m.group(3);
            }
            if ((val = customEnvVars != null && customEnvVars.containsKey(var) ? customEnvVars.get(var) : System.getenv(var)) != null) {
                path = String.valueOf(path.substring(0, m.start())) + val + path.substring(m.end(0));
                start += val.length();
                m = envVarRegex.matcher(path);
                continue;
            }
            start = m.end(0);
        }
        if (HostInfo.isWindows() && path.startsWith("//")) {
            path = "\\\\" + path.substring(2);
        }
        return new File(path);
    }

    public static boolean isAbsolute(String path) {
        if (path.length() > 0) {
            switch (path.charAt(0)) {
                case '/': {
                    return true;
                }
                case '\\': {
                    return path.length() > 1 && path.charAt(1) == '\\';
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    return path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '\\';
                }
            }
        }
        return false;
    }
}

