/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import com.arm.text.FormattedMessage;
import com.arm.text.IFormattedMessage;
import com.arm.text.ILayer;
import com.arm.text.IMessage;
import jakarta.annotation.Nullable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;

public enum Messages implements IMessage
{
    IS_NOT_DIRECTORY("001_isNotDirectory", 1),
    SOURCE_TARGET_INCONSISTENT("002_sourceTargetInconsistent", 2),
    NOT_USING_SHELL_FOLDER("003_notUsingShellFolder", 3),
    ENTER_ABSOLUTE_PATH("004_enterAbsolutePath", 4),
    PLEASE_ENTER_DIRECTORY("005_pleaseEnterDirectory", 5),
    IS_NOT_WRITEABLE("006_isNotWriteable", 6),
    SYMLINKS_NOT_SUPPORTED("007_symlinksNotSupported", 7),
    PROCESS_INTERRUPTED("008_processInterrupted", 8),
    PATH_NOT_RELATIVE_TO_BASE("009_pathNotRelativeToBase", 9),
    HAS_VERSION("010_hasVersion", 10),
    STD_OUT_IS("011_stdOutIs", 11),
    STD_ERR_IS("012_stdErrIs", 12),
    TOOK("013_took", 13),
    SOURCE_MUST_EXIST("014_sourceMustExist", 14),
    SOURCE_MUST_BE_ABSOLUTE("015_sourceMustBeAbsolute", 15),
    MISSING_FILE("016_missingFile", 16),
    FILE_IS_DIRECTORY("017_fileIsDirectory", 17),
    CONTENT_ENDED_PREMATURELY("018_contentEndedPrematurely", 18),
    UNABLE_TO_CREATE_LOCK_FILE("019_unableToCreateLockFile", 19),
    UNABLE_TO_LOCK_FILE("020_unableToLockFile", 20),
    UNABLE_TO_OPEN_URL_CONNECTION("021_unableToOpenUrlConnection", 21);

    private static final ResourceBundle RESOURCE_BUNDLE_ENGLISH;
    private static ResourceBundle RESOURCE_BUNDLE_LOCALISED;
    private final String key;
    private final int code;

    static {
        RESOURCE_BUNDLE_ENGLISH = ResourceBundle.getBundle("com/arm/io/messages", Locale.ROOT);
        Messages.refreshLocalized();
    }

    public static void refreshLocalized() {
        RESOURCE_BUNDLE_LOCALISED = ResourceBundle.getBundle("com/arm/io/messages");
    }

    private Messages(String key, int code) {
        this.key = key;
        this.code = code;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getEnglishValue(Object ... args) {
        String englishMessage = RESOURCE_BUNDLE_ENGLISH.getString(this.key);
        englishMessage = Messages.removeParameterNames(englishMessage);
        return (args = Messages.removeNesting(args, false)) != null && args.length > 0 ? MessageFormat.format(englishMessage, args) : englishMessage;
    }

    @Override
    public String getLocalisedValue(Object ... args) {
        String localMessage = RESOURCE_BUNDLE_LOCALISED.getString(this.key);
        localMessage = Messages.removeParameterNames(localMessage);
        return (args = Messages.removeNesting(args, true)) != null && args.length > 0 ? MessageFormat.format(localMessage, args) : localMessage;
    }

    private static Object[] removeNesting(@Nullable Object[] args, boolean localise) {
        if (args != null) {
            boolean isCopy = false;
            int i = 0;
            while (i < args.length) {
                Object a = args[i];
                if (a instanceof IFormattedMessage || a instanceof IMessage) {
                    if (!isCopy) {
                        isCopy = true;
                        args = Arrays.copyOf(args, args.length);
                    }
                    args[i] = a instanceof IFormattedMessage ? (localise ? ((IFormattedMessage)a).getLocalisedValue() : ((IFormattedMessage)a).getEnglishValue()) : (localise ? ((IMessage)a).getLocalisedValue(new Object[0]) : ((IMessage)a).getEnglishValue(new Object[0]));
                }
                ++i;
            }
        }
        return args;
    }

    private static String removeParameterNames(String message) {
        if (message.indexOf(123) < 0) {
            return message;
        }
        StringBuilder builder = new StringBuilder();
        boolean strip = false;
        boolean quoted = false;
        int i = 0;
        while (i < message.length()) {
            char current = message.charAt(i);
            switch (current) {
                case '\'': {
                    builder.append(current);
                    if (quoted) {
                        quoted = false;
                        break;
                    }
                    quoted = true;
                    break;
                }
                case '{': {
                    builder.append(current);
                    if (!quoted) {
                        int end = message.indexOf(125, i);
                        int colon = message.indexOf(58, i);
                        if (colon > 0 && colon < end) {
                            strip = true;
                        }
                    }
                    quoted = false;
                    break;
                }
                case ':': {
                    if (!strip) {
                        builder.append(current);
                    }
                    strip = false;
                    quoted = false;
                    break;
                }
                default: {
                    if (!strip) {
                        builder.append(current);
                    }
                    quoted = false;
                }
            }
            ++i;
        }
        return builder.toString();
    }

    @Override
    public IFormattedMessage format(Object ... args) {
        return new FormattedMessage(this, args);
    }

    @Override
    public ILayer getLayer() {
        return null;
    }
}

