/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import com.arm.io.EndOfStreamListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class InterruptibleInputStream
extends InputStream {
    private final InputStream in;
    private final EndOfStreamListener eosListener;
    private boolean isClosed;

    public InterruptibleInputStream(InputStream in, EndOfStreamListener eosListener) {
        if (in == null) {
            throw new NullPointerException("in can't be null");
        }
        if (eosListener == null) {
            throw new NullPointerException("eosListener can't be null");
        }
        this.in = in;
        this.eosListener = eosListener;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nbByteToRead = Math.min(Math.max(this.available(), 1), len);
        return super.read(b, off, nbByteToRead);
    }

    @Override
    public int read() throws IOException {
        try {
            while (this.in.available() < 1 && !this.isClosed && !this.eosListener.isDepleted()) {
                Thread.sleep(50L);
            }
            int read = this.isClosed ? -1 : (this.in.available() > 0 ? this.in.read() : -1);
            return read;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.in.close();
    }
}

