/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import com.arm.io.IFileWatcherListener;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FileWatcher {
    private WatchService mWatchService;
    private Path mFilePath;
    private Path mFileParentPath;
    private WatchKey mKey;
    private Set<IFileWatcherListener> mListeners = new HashSet<IFileWatcherListener>();
    private Thread mWatcherThread;

    public FileWatcher(Path file) throws IOException {
        this.mWatchService = FileSystems.getDefault().newWatchService();
        this.mFilePath = file;
        this.mFileParentPath = file.getParent();
        if (this.mFileParentPath == null) {
            throw new IllegalArgumentException("Cannot watch directory without parent");
        }
        this.mKey = this.mFileParentPath.register(this.mWatchService, StandardWatchEventKinds.ENTRY_MODIFY);
        this.mWatcherThread = new Thread(() -> this.processEvents());
        this.mWatcherThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Set<IFileWatcherListener> set = this.mListeners;
        synchronized (set) {
            this.mListeners.clear();
        }
        this.mWatcherThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(IFileWatcherListener listener) {
        Set<IFileWatcherListener> set = this.mListeners;
        synchronized (set) {
            this.mListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(IFileWatcherListener listener) {
        Set<IFileWatcherListener> set = this.mListeners;
        synchronized (set) {
            this.mListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFileChangedEvent(Path path) {
        Set<IFileWatcherListener> set = this.mListeners;
        synchronized (set) {
            for (IFileWatcherListener listener : this.mListeners) {
                listener.fileChanged(path);
            }
        }
    }

    private void processEvents() {
        while (true) {
            WatchKey eventKey;
            try {
                eventKey = this.mWatchService.take();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (!eventKey.equals(this.mKey)) continue;
            List<WatchEvent<?>> gevents = eventKey.pollEvents();
            for (WatchEvent<?> gevent : gevents) {
                Path eventPath;
                WatchEvent<?> event = gevent;
                WatchEvent.Kind<?> eventKind = event.kind();
                if (eventKind == StandardWatchEventKinds.OVERFLOW || !(eventPath = (Path)event.context()).equals(this.mFilePath.getFileName())) continue;
                this.fireFileChangedEvent(this.mFilePath);
            }
            if (!eventKey.reset()) break;
        }
    }
}

