/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import com.arm.io.IStreamParser;
import com.arm.util.Platform;
import com.arm.util.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DocStreamParser
implements IStreamParser<String, HelpEntry> {
    public static final byte ALIAS_PREFIX = 31;
    public static final byte NAME_PREFIX = 30;
    public static final byte TEXT_PREFIX = 29;
    private Charset charset;

    public DocStreamParser(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Map<String, HelpEntry> parse(InputStream stream) throws IOException {
        int read;
        Objects.requireNonNull(stream);
        HashMap<String, HelpEntry> textHelp = new HashMap<String, HelpEntry>();
        ParseState state = ParseState.NAME;
        CharsetEncoder charsetEncoder = this.charset.newEncoder();
        InputStreamReader isr = new InputStreamReader(stream, this.charset);
        BufferedReader reader = new BufferedReader(isr);
        CommandDoc doc = new CommandDoc();
        while ((read = reader.read()) != -1) {
            char c = (char)read;
            if (!charsetEncoder.canEncode(c)) {
                throw new CharacterCodingException();
            }
            switch (state) {
                case NAME: {
                    state = this.consumeNameChar(doc, c, textHelp);
                    break;
                }
                case ALIAS: {
                    state = this.consumeAliasChar(doc, c, textHelp);
                    break;
                }
                case TEXT: {
                    state = this.consumeTextChar(doc, c, textHelp);
                }
            }
        }
        if (doc.canCommit()) {
            doc.commitTo(textHelp);
        }
        return textHelp;
    }

    private ParseState consumeNameChar(CommandDoc doc, char c, Map<String, HelpEntry> targetMap) {
        switch ((byte)c) {
            case 31: {
                if (doc.name.length() == 0) {
                    throw new IllegalStateException("Command cannot have an alias without a name");
                }
                return ParseState.ALIAS;
            }
            case 29: {
                return ParseState.TEXT;
            }
            case 30: {
                return ParseState.NAME;
            }
        }
        doc.appendToName(c);
        return ParseState.NAME;
    }

    private ParseState consumeAliasChar(CommandDoc doc, char c, Map<String, HelpEntry> targetMap) {
        switch ((byte)c) {
            case 31: {
                doc.commitAlias();
                return ParseState.ALIAS;
            }
            case 29: {
                doc.commitAlias();
                return ParseState.TEXT;
            }
            case 30: {
                doc.commitTo(targetMap);
                return ParseState.NAME;
            }
        }
        doc.appendToAlias(c);
        return ParseState.ALIAS;
    }

    private ParseState consumeTextChar(CommandDoc doc, char c, Map<String, HelpEntry> targetMap) {
        switch ((byte)c) {
            case 31: {
                throw new IllegalStateException("Command cannot have an alias without a name");
            }
            case 29: {
                return ParseState.TEXT;
            }
            case 30: {
                doc.commitTo(targetMap);
                return ParseState.NAME;
            }
        }
        doc.appendToCommandText(c);
        return ParseState.TEXT;
    }

    private static class CommandDoc {
        private final StringBuilder name;
        private final StringBuilder aliasBuffer;
        private final StringBuilder commandText;
        private final List<String> aliasList = new ArrayList<String>();

        public CommandDoc() {
            this.name = new StringBuilder();
            this.aliasBuffer = new StringBuilder();
            this.commandText = new StringBuilder();
        }

        public void reset() {
            this.name.setLength(0);
            this.commandText.setLength(0);
            this.aliasBuffer.setLength(0);
            this.aliasList.clear();
        }

        public void appendToName(char name) {
            this.name.append(name);
        }

        public void appendToCommandText(char commandText) {
            this.commandText.append(commandText);
        }

        public void appendToAlias(char alias) {
            this.aliasBuffer.append(alias);
        }

        public void commitAlias() {
            this.aliasList.add(this.aliasBuffer.toString());
            this.aliasBuffer.setLength(0);
        }

        public boolean canCommit() {
            return this.name.length() > 0;
        }

        public void commitTo(Map<String, HelpEntry> destMap) {
            if (this.aliasBuffer.length() > 0) {
                this.commitAlias();
            }
            String cmdText = this.commandText.toString();
            String name = this.name.toString();
            destMap.put(name.toLowerCase(), new HelpEntry(name, false, cmdText));
            this.aliasList.forEach(alias -> destMap.put(alias.toLowerCase(), new HelpEntry((String)alias, true, cmdText)));
            this.reset();
        }
    }

    public static class HelpEntry {
        private String text;
        private boolean hasBeenNormalized;
        private final String name;
        private final boolean isAlias;

        public HelpEntry(String name, boolean isAlias, String text) {
            this.name = name;
            this.isAlias = isAlias;
            this.text = text;
            this.hasBeenNormalized = false;
        }

        public String getName() {
            return this.name;
        }

        public boolean isAlias() {
            return this.isAlias;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HelpEntry)) {
                return false;
            }
            HelpEntry helpEntry = (HelpEntry)o;
            return Objects.equals(this.text, helpEntry.text) && Objects.equals(this.name, helpEntry.name);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.name);
        }

        public String toString() {
            if (!this.hasBeenNormalized) {
                this.text = this.normalizeString(this.text);
                this.hasBeenNormalized = true;
            }
            return this.text;
        }

        private String normalizeString(String text) {
            if (text == null) {
                return null;
            }
            text = this.hostLineEndings(text);
            text = this.removeTrailingSpaces(text);
            return text;
        }

        private String removeTrailingSpaces(String text) {
            return Arrays.stream(text.split(Platform.LS)).map(Strings::rtrim).collect(Collectors.joining(Platform.LS));
        }

        private String hostLineEndings(String text) {
            if (text == null) {
                return null;
            }
            return text.replaceAll("\\r?\\n", Platform.LS);
        }
    }

    static enum ParseState {
        NAME,
        ALIAS,
        TEXT;

    }
}

