/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;

    public ByteBufferInputStream(@Nonnull ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public int read() {
        return this.buffer.hasRemaining() ? 0xFF & this.buffer.get() : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b.length == 0) {
            return 0;
        }
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        if (len > this.buffer.remaining()) {
            len = this.buffer.remaining();
        }
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) {
        if (n > (long)this.buffer.remaining()) {
            n = this.buffer.remaining();
        }
        this.buffer.position(this.buffer.position() + (int)n);
        return n;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.buffer.mark();
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.buffer.reset();
        }
        catch (InvalidMarkException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() {
    }
}

