/*
 * Decompiled with CFR 0.152.
 */
package com.arm.ini;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class IniFile {
    static final char COMMENT_START = ';';
    static final char COMMENT_START_ALT = '#';
    static final char PROPERTY_SEPARATOR = '=';
    static final char QUOTE = '\"';
    static final char SECTION_START = '[';
    static final char SECTION_END = ']';
    private final List<Section> sections = new ArrayList<Section>();

    protected IniFile() {
    }

    protected Optional<Section> lookupSection(String name) {
        return this.sections.stream().filter(s -> ((Section)s).name.equalsIgnoreCase(name)).findFirst();
    }

    protected Section getSection(String name) {
        return this.lookupSection(name).orElseGet(() -> {
            Section section = new Section(name);
            this.sections.add(section);
            return section;
        });
    }

    public List<Section> sections() {
        return this.sections;
    }

    public Section section(String name) {
        return this.lookupSection(name).orElse(null);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IniFile) {
            IniFile other = (IniFile)obj;
            return this.sections.equals(other.sections);
        }
        return false;
    }

    public int hashCode() {
        return this.sections.hashCode();
    }

    private static class Property {
        private final String key;
        private String value;

        public Property(String key, String value) {
            this.key = key;
            this.value = value;
        }

        protected void setValue(String newValue) {
            this.value = newValue;
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Property) {
                Property other = (Property)obj;
                return this.key.equalsIgnoreCase(other.key) && this.value.equals(other.value);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.key.toLowerCase(), this.value);
        }
    }

    public static class Section {
        private final String name;
        private final List<Property> properties;

        protected Section(String name) {
            this.name = name;
            this.properties = new ArrayList<Property>();
        }

        protected Optional<Property> lookupProperty(String key) {
            return this.properties.stream().filter(p -> ((Property)p).key.equalsIgnoreCase(key)).findFirst();
        }

        protected void setProperty(String key, String value, boolean keepFirst) {
            Optional<Property> existing = this.lookupProperty(key);
            if (!existing.isPresent()) {
                this.properties.add(new Property(key, value));
            } else if (!keepFirst) {
                existing.get().setValue(value);
            }
        }

        public String name() {
            return this.name;
        }

        public List<String> keys() {
            return this.properties.stream().map(Property::key).collect(Collectors.toList());
        }

        public String property(String key) {
            return this.lookupProperty(key).map(Property::value).orElse(null);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Section) {
                Section other = (Section)obj;
                return this.name.equalsIgnoreCase(other.name) && this.properties.equals(other.properties);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.name.toLowerCase(), this.properties);
        }
    }
}

