/*
 * Decompiled with CFR 0.152.
 */
package com.arm.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CSVFile {
    private static final String SEPARATOR = ",";
    private static final String SEPARATOR_REGX = "(?<!\\\\),";
    private static final String SEPARATOR_ESCAPE_REGX = "\\\\,";
    private static final String INNER_SEPARATOR = ";";
    private static final String INNER_SEPARATOR_REGX = "(?<!\\\\);";
    private static final String INNER_SEPARATOR_ESCAPE_REGX = "\\\\;";
    private String[] columns = new String[0];
    private ArrayList<CSVRow> rows = new ArrayList();

    private CSVFile() {
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
        if (this.columns == null) {
            this.columns = new String[0];
        }
    }

    public String[] getColumns() {
        return this.columns;
    }

    public void addRow(Map<String, String[]> row) {
        if (row == null) {
            return;
        }
        this.rows.add(new CSVRow(row));
    }

    public void addRow(int index, Map<String, String[]> row) {
        if (row == null) {
            return;
        }
        this.rows.add(index, new CSVRow(row));
    }

    public void parseAndAddRow(int index, String line) {
        this.addRow(index, CSVFile.parseLine(this.getColumns(), line));
    }

    public ArrayList<CSVRow> getRows() {
        return this.rows;
    }

    public CSVRow getRow(int index) {
        return this.rows.get(index);
    }

    public String[] getValues(String columnID, int rowIndex) {
        if (columnID == null || columnID.isEmpty()) {
            return new String[0];
        }
        CSVRow row = this.rows.get(rowIndex);
        if (row == null) {
            return new String[0];
        }
        return row.getColumnValues(columnID);
    }

    public static CSVFile parse(BufferedReader reader) {
        CSVFile csvFile = new CSVFile();
        try {
            boolean firstLine = true;
            String line = reader.readLine();
            while (line != null) {
                if (!line.isEmpty()) {
                    if (firstLine) {
                        String[] columns = line.split(SEPARATOR_REGX);
                        int i = 0;
                        while (i < columns.length) {
                            columns[i] = columns[i].trim();
                            ++i;
                        }
                        csvFile.setColumns(columns);
                        firstLine = false;
                    } else {
                        HashMap<String, String[]> row = CSVFile.parseLine(csvFile.getColumns(), line);
                        if (row != null) {
                            csvFile.addRow(row);
                        }
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {}
        return csvFile;
    }

    private static HashMap<String, String[]> parseLine(String[] columns, String line) {
        if (columns == null || line == null || line.isEmpty()) {
            return null;
        }
        HashMap<String, String[]> row = new HashMap<String, String[]>();
        String[] values = line.trim().split(SEPARATOR_REGX, columns.length);
        int i = 0;
        while (i < values.length) {
            String value = values[i];
            value = value.trim().replaceAll(SEPARATOR_ESCAPE_REGX, SEPARATOR);
            ArrayList<String> columnValues = new ArrayList<String>();
            if (!value.isEmpty()) {
                String[] stringArray = value.split(INNER_SEPARATOR_REGX);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String v = stringArray[n2];
                    v = v.trim().replaceAll(INNER_SEPARATOR_ESCAPE_REGX, INNER_SEPARATOR);
                    columnValues.add(v);
                    ++n2;
                }
            }
            row.put(columns[i], columnValues.toArray(new String[0]));
            ++i;
        }
        i = values.length;
        while (i < columns.length) {
            row.put(columns[i], new String[0]);
            ++i;
        }
        return row;
    }

    public static String createRow(String[] values) {
        StringBuilder strBuilder = new StringBuilder();
        int i = 0;
        while (i < values.length) {
            if (i != 0) {
                strBuilder.append(SEPARATOR);
            }
            strBuilder.append(values[i]);
            ++i;
        }
        return strBuilder.append("\n").toString();
    }

    public class CSVRow {
        private Map<String, String[]> data = new HashMap<String, String[]>();

        public CSVRow(Map<String, String[]> data) {
            this.data = data;
        }

        public boolean isEmpty() {
            return this.data == null ? true : this.data.isEmpty();
        }

        public String[] getColumnValues(String columnID) {
            return this.data == null ? new String[]{} : this.data.get(columnID);
        }
    }
}

