/*
 * Decompiled with CFR 0.152.
 */
package com.arm.concurrent;

public class ThreadHolder {
    private final Thread thread;
    private volatile Throwable throwable;

    public ThreadHolder(final RunnableWithThrowable runnable, String name) {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    ThreadHolder.this.throwable = t;
                }
            }
        }, name);
    }

    public Thread getThread() {
        return this.thread;
    }

    public Throwable getThrowable() {
        if (this.thread.isAlive()) {
            throw new IllegalStateException();
        }
        return this.throwable;
    }

    public static interface RunnableWithThrowable {
        public void run() throws Throwable;
    }
}

