/*
 * Decompiled with CFR 0.152.
 */
package com.arm.bytearray;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class FloatPrinter {
    private static final boolean DEBUG = false;
    private static final Consumer<Object> LOGGER = null;
    private final int size;
    private final int precision;
    private final int bias;
    private final Printer printer;
    private final int maxExponent;
    private final int hiddenBit;
    private final BigInteger TWO = BigInteger.valueOf(2L);
    public static final Printer SIMPLE_PRINTER = (digits, h, n) -> {
        int dotPoint;
        StringBuilder b = new StringBuilder();
        int leadingZeroes = -h;
        if (leadingZeroes > 0) {
            b.append(0);
            b.append(".");
            int i = 1;
            while (i < leadingZeroes) {
                b.append(0);
                ++i;
            }
            dotPoint = -1;
        } else {
            dotPoint = h + 1;
        }
        int digitCount = 0;
        int i = 0;
        while (i < digits.size()) {
            if (digitCount == dotPoint) {
                b.append(".");
            }
            b.append(digits.get(i));
            ++digitCount;
            ++i;
        }
        i = 0;
        while (i <= n) {
            if (digitCount == dotPoint) {
                b.append(".");
            }
            b.append(0);
            ++digitCount;
            ++i;
        }
        return b.toString();
    };
    public static final Printer EXP_PRINTER = (digits, h, n) -> {
        StringBuilder b = new StringBuilder();
        b.append(digits.get(0));
        b.append(".");
        if (digits.size() == 1) {
            b.append(0);
        } else {
            int i = 1;
            while (i < digits.size()) {
                b.append(digits.get(i));
                ++i;
            }
        }
        b.append("E");
        b.append(h);
        return b.toString();
    };
    public static final Printer THRESHOLD_PRINTER = (digits, h, n) -> {
        if (h < 7 && h >= -3) {
            return SIMPLE_PRINTER.print(digits, h, n);
        }
        return EXP_PRINTER.print(digits, h, n);
    };
    public static final FloatPrinter F32_SIMPLE = new FloatPrinter(32, SIMPLE_PRINTER);
    public static final FloatPrinter F32_EXP = new FloatPrinter(32, EXP_PRINTER);
    public static final FloatPrinter F32_THRESHOLD = new FloatPrinter(32, THRESHOLD_PRINTER);
    public static final FloatPrinter F128_SIMPLE = new FloatPrinter(128, SIMPLE_PRINTER);
    public static final FloatPrinter F128_EXP = new FloatPrinter(128, EXP_PRINTER);
    public static final FloatPrinter F128_THRESHOLD = new FloatPrinter(128, THRESHOLD_PRINTER);

    private FloatPrinter(int size, Printer printer) {
        this.size = size;
        switch (size) {
            case 128: {
                this.precision = 113;
                this.bias = 16383;
                this.hiddenBit = 1;
                this.maxExponent = Short.MAX_VALUE;
                break;
            }
            case 32: {
                this.precision = 24;
                this.bias = 127;
                this.hiddenBit = 128;
                this.maxExponent = 255;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.printer = printer;
    }

    private static final boolean allZero(byte[] bytes) {
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String asDecimalString(byte[] bytes) {
        String digitString;
        FloatType floatType;
        int exponent;
        byte[] significandBytes;
        boolean negative = (bytes[0] & 0x80) != 0;
        switch (this.size) {
            case 128: {
                significandBytes = new byte[15];
                System.arraycopy(bytes, 2, significandBytes, 1, 14);
                exponent = (0x7F & bytes[0]) << 8 | 0xFF & bytes[1];
                break;
            }
            case 32: {
                significandBytes = new byte[3];
                System.arraycopy(bytes, 1, significandBytes, 0, 3);
                significandBytes[0] = (byte)(significandBytes[0] & 0x7F);
                exponent = (bytes[0] & 0x7F) << 1 | (bytes[1] & 0x80) >> 7;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (exponent == 0) {
            if (FloatPrinter.allZero(significandBytes)) {
                floatType = FloatType.ZERO;
            } else {
                floatType = FloatType.DENORM;
                exponent = -this.bias + 1;
            }
        } else if (exponent == this.maxExponent) {
            floatType = FloatPrinter.allZero(significandBytes) ? FloatType.INF : FloatType.NAN;
        } else {
            floatType = FloatType.NORM;
            exponent -= this.bias;
            significandBytes[0] = (byte)(significandBytes[0] | this.hiddenBit);
        }
        switch (floatType) {
            case NORM: 
            case DENORM: {
                BigInteger mantissa = new BigInteger(1, significandBytes);
                digitString = this.fppTwo(exponent, mantissa);
                break;
            }
            case ZERO: {
                digitString = "0.0";
                break;
            }
            case INF: {
                digitString = "Infinity";
                break;
            }
            default: {
                digitString = "NaN";
            }
        }
        if (negative && floatType != FloatType.NAN) {
            return "-" + digitString;
        }
        return digitString;
    }

    private BigInteger shift2(BigInteger x, int n) {
        return x.shiftLeft(n);
    }

    private BigInteger shift2(int x, int n) {
        return this.shift2(BigInteger.valueOf(x), n);
    }

    private BigInteger ceilDivide(BigInteger a, BigInteger b) {
        BigInteger[] result = a.divideAndRemainder(b);
        if (result[1].equals(BigInteger.ZERO)) {
            return result[0];
        }
        return result[0].add(BigInteger.ONE);
    }

    public String fppTwo(int exponent, BigInteger f) {
        boolean high;
        boolean low;
        BigInteger u;
        BigInteger mLow;
        int p = this.precision - 1;
        int e = exponent;
        BigInteger r = this.shift2(f, FloatPrinter.max(e - p, 0));
        BigInteger s = this.shift2(1, FloatPrinter.max(0, -(e - p)));
        BigInteger mHigh = mLow = this.shift2(1, FloatPrinter.max(e - p, 0));
        if (f.equals(this.shift2(1, p - 1))) {
            mHigh = this.shift2(mHigh, 1);
            r = this.shift2(r, 1);
            s = this.shift2(s, 1);
        }
        int k = 0;
        while (r.compareTo(this.ceilDivide(s, BigInteger.TEN)) < 0) {
            --k;
            r = r.multiply(BigInteger.TEN);
            mLow = mLow.multiply(BigInteger.TEN);
            mHigh = mHigh.multiply(BigInteger.TEN);
        }
        while (this.TWO.multiply(r).add(mHigh).compareTo(this.TWO.multiply(s)) >= 0) {
            s = s.multiply(BigInteger.TEN);
            ++k;
        }
        ArrayList<Integer> buf = new ArrayList<Integer>();
        int h = k - 1;
        while (true) {
            --k;
            BigInteger tenR = r.multiply(BigInteger.TEN);
            u = tenR.divide(s);
            r = r.multiply(BigInteger.TEN).mod(s);
            mLow = mLow.multiply(BigInteger.TEN);
            mHigh = mHigh.multiply(BigInteger.TEN);
            BigInteger twoR = this.TWO.multiply(r);
            low = twoR.compareTo(mLow) < 0;
            BigInteger twoS = this.TWO.multiply(s);
            boolean bl = high = twoR.compareTo(twoS.subtract(mHigh)) > 0;
            if (low || high) break;
            buf.add((int)u.longValue());
        }
        if (low && !high) {
            buf.add((int)u.longValue());
        } else if (high && !low) {
            buf.add((int)u.longValue() + 1);
        } else {
            int comparison = r.multiply(this.TWO).compareTo(s);
            if (comparison <= 0) {
                buf.add((int)u.longValue());
            } else {
                buf.add((int)u.longValue() + 1);
            }
        }
        int n = k;
        return this.printer.print(buf, h, n);
    }

    public static int max(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    private static enum FloatType {
        NORM,
        DENORM,
        ZERO,
        INF,
        NAN;

    }

    @FunctionalInterface
    private static interface Printer {
        public String print(List<Integer> var1, int var2, int var3);
    }
}

