/*
 * Decompiled with CFR 0.152.
 */
package com.arm.bytearray;

import com.arm.bytearray.IByteArrayConverter;
import java.util.Arrays;

public class ByteArrayConverterLittleEndian
implements IByteArrayConverter {
    private static final ByteArrayConverterLittleEndian instance = new ByteArrayConverterLittleEndian();

    private ByteArrayConverterLittleEndian() {
    }

    public static ByteArrayConverterLittleEndian getInstance() {
        return instance;
    }

    @Override
    public short convertByteArrayToShort(byte[] array) {
        return (short)((array[1] & 0xFF) << 8 | array[0] & 0xFF);
    }

    @Override
    public int convertByteArrayToInt(byte[] array) {
        return (array[3] & 0xFF) << 24 | (array[2] & 0xFF) << 16 | (array[1] & 0xFF) << 8 | array[0] & 0xFF;
    }

    @Override
    public long convertByteArrayToLong(byte[] array) {
        return ((long)array[7] & 0xFFL) << 56 | ((long)array[6] & 0xFFL) << 48 | ((long)array[5] & 0xFFL) << 40 | ((long)array[4] & 0xFFL) << 32 | ((long)array[3] & 0xFFL) << 24 | ((long)array[2] & 0xFFL) << 16 | ((long)array[1] & 0xFFL) << 8 | (long)array[0] & 0xFFL;
    }

    @Override
    public short convertByteArrayToShort(byte[] first, int offset, byte[] second) {
        return (short)this.convertArrays(first, offset, second, 2, 8);
    }

    @Override
    public int convertByteArrayToInt(byte[] first, int offset, byte[] second) {
        return (int)this.convertArrays(first, offset, second, 4, 24);
    }

    @Override
    public long convertByteArrayToLong(byte[] first, int offset, byte[] second) {
        return this.convertArrays(first, offset, second, 8, 56);
    }

    @Override
    public byte[] convertIntToByteArray(int value) {
        byte[] data = new byte[4];
        data[3] = (byte)(value >> 24 & 0xFF);
        data[2] = (byte)(value >> 16 & 0xFF);
        data[1] = (byte)(value >> 8 & 0xFF);
        data[0] = (byte)(value & 0xFF);
        return data;
    }

    @Override
    public byte[] convertLongToByteArray(long value) {
        byte[] data = new byte[8];
        data[7] = (byte)(value >> 56 & 0xFFL);
        data[6] = (byte)(value >> 48 & 0xFFL);
        data[5] = (byte)(value >> 40 & 0xFFL);
        data[4] = (byte)(value >> 32 & 0xFFL);
        data[3] = (byte)(value >> 24 & 0xFFL);
        data[2] = (byte)(value >> 16 & 0xFFL);
        data[1] = (byte)(value >> 8 & 0xFFL);
        data[0] = (byte)(value & 0xFFL);
        return data;
    }

    @Override
    public byte[] convertShortToByteArray(short value) {
        byte[] data = new byte[2];
        data[1] = (byte)(value >> 8 & 0xFF);
        data[0] = (byte)(value & 0xFF);
        return data;
    }

    private long convertArrays(byte[] first, int offset, byte[] second, int noBytes, int shift) {
        long result = 0L;
        int remain = first.length - offset;
        int length = remain < noBytes ? noBytes - remain : -1;
        int i = length - 1;
        while (i >= 0) {
            result |= ((long)second[i] & 0xFFL) << shift;
            --i;
            shift -= 8;
        }
        length = remain > noBytes ? noBytes : remain;
        i = offset + length - 1;
        while (i >= offset) {
            result |= ((long)first[i] & 0xFFL) << shift;
            --i;
            shift -= 8;
        }
        return result;
    }

    @Override
    public byte[] copyOf(byte[] original, int newLength) {
        return Arrays.copyOf(original, newLength);
    }
}

