/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.v22.perf;

import com.arm.streamline.protocol.gator.io.ByteArrayOutputStreamAPCByteWriter;
import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.IIntProperty;
import com.arm.streamline.protocol.gator.messages.ILongProperty;
import com.arm.streamline.protocol.gator.messages.IMessage;
import com.arm.streamline.protocol.gator.messages.IMessageCodec;
import com.arm.streamline.protocol.gator.messages.IMessageRecord;
import com.arm.streamline.protocol.gator.messages.IMessageRecordCodec;
import com.arm.streamline.protocol.gator.messages.IRecordListProperty;
import com.arm.streamline.protocol.gator.messages.LE32IntProperty;
import com.arm.streamline.protocol.gator.messages.PackedIntProperty;
import com.arm.streamline.protocol.gator.messages.PackedLongProperty;
import com.arm.streamline.protocol.gator.messages.SingleRecordListProperty;
import com.arm.streamline.protocol.gator.v22.perf.IMessageCodecContextPerfV22;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class PerfDataFrame
implements IMessage<Codec> {
    public final @NonNull List<@NonNull PerfDataFrameRecord> records;

    public PerfDataFrame(@NonNull List<@NonNull PerfDataFrameRecord> records) {
        this.records = Collections.unmodifiableList(records);
    }

    @Override
    public @NonNull Codec getCodec() {
        return Codec.INSTANCE;
    }

    public @NonNull String toString() {
        return String.format("PerfDataFrame(%d)", this.records.size());
    }

    public static final class Codec
    extends Enum<Codec>
    implements IMessageCodec<PerfDataFrame, IPerfDataFrameConsumer, IMessageCodecContextPerfV22> {
        public static final /* enum */ Codec INSTANCE = new Codec();
        public static final @NonNull IRecordListProperty<PerfDataFrameRecord, @NonNull IMessageCodecContextPerfV22> PROPERTY_RECORDS;
        private static final /* synthetic */ Codec[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Codec[]{INSTANCE};
            PROPERTY_RECORDS = new SingleRecordListProperty<PerfDataFrameRecord, IMessageCodecContextPerfV22>("records", PerfDataFrameRecord.Codec.INSTANCE);
        }

        @Override
        public void decode(int token, @NonNull IMessageCodecContextPerfV22 context, @NonNull IAPCByteReader stream, @NonNull IPerfDataFrameConsumer consumer) throws IOException {
            assert (token == this.token());
            Throwable throwable = null;
            Object var6_7 = null;
            try (IPerfDataFrameMessageConsumer recordsConsumer = consumer.consumePerfDataFrame();){
                PROPERTY_RECORDS.stream(context, stream, recordsConsumer::consume);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        public int encode(@NonNull PerfDataFrame message, @NonNull IMessageCodecContextPerfV22 context, @NonNull IAPCByteWriter stream) throws IOException {
            PROPERTY_RECORDS.write(context, stream, message.records);
            return this.token();
        }

        @Override
        public int token() {
            return 12;
        }

        public static Codec[] values() {
            Codec[] codecArray = ENUM$VALUES;
            int n = codecArray.length;
            Codec[] codecArray2 = new Codec[n];
            System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
            return codecArray2;
        }

        public static Codec valueOf(String string) {
            return Enum.valueOf(Codec.class, string);
        }
    }

    public static interface IPerfDataFrameConsumer {
        public @NonNull IPerfDataFrameMessageConsumer consumePerfDataFrame() throws IOException;
    }

    public static interface IPerfDataFrameMessageConsumer
    extends Closeable {
        public void consume(@NonNull PerfDataFrameRecord var1) throws IOException;
    }

    public static final class PerfDataFrameRecord
    implements IMessageRecord<PerfDataFrameRecord, IMessageCodecContextPerfV22> {
        public final int cpu;
        public final byte @NonNull [] data;

        public PerfDataFrameRecord(int cpu, byte @NonNull [] data) {
            this.cpu = cpu;
            this.data = data;
        }

        @Override
        public @NonNull IMessageRecordCodec<PerfDataFrameRecord, @NonNull IMessageCodecContextPerfV22> getCodec() {
            return Codec.INSTANCE;
        }

        public static enum Codec implements IMessageRecordCodec<PerfDataFrameRecord, IMessageCodecContextPerfV22>
        {
            INSTANCE;

            public static final @NonNull IIntProperty PROPERTY_CPU;
            public static final @NonNull IIntProperty PROPERTY_LENGTH;
            public static final @NonNull ILongProperty PROPERTY_PACKED_WORD;

            static {
                PROPERTY_CPU = new PackedIntProperty("cpu");
                PROPERTY_LENGTH = new LE32IntProperty("length");
                PROPERTY_PACKED_WORD = new PackedLongProperty("packed-word");
            }

            @Override
            public @NonNull PerfDataFrameRecord decode(@NonNull IMessageCodecContextPerfV22 context, @NonNull IAPCByteReader stream) throws IOException {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int cpu = PROPERTY_CPU.read(stream);
                int length = PROPERTY_LENGTH.read(stream);
                int end = stream.position() + length;
                while (stream.position() < end) {
                    long v = PROPERTY_PACKED_WORD.read(stream);
                    baos.write((byte)(v >>> 0 & 0xFFL));
                    baos.write((byte)(v >>> 8 & 0xFFL));
                    baos.write((byte)(v >>> 16 & 0xFFL));
                    baos.write((byte)(v >>> 24 & 0xFFL));
                    baos.write((byte)(v >>> 32 & 0xFFL));
                    baos.write((byte)(v >>> 40 & 0xFFL));
                    baos.write((byte)(v >>> 48 & 0xFFL));
                    baos.write((byte)(v >>> 56 & 0xFFL));
                }
                if (stream.position() != end) {
                    throw new IOException("Invalid length");
                }
                return new PerfDataFrameRecord(cpu, baos.toByteArray());
            }

            @Override
            public void encode(@NonNull PerfDataFrameRecord message, @NonNull IMessageCodecContextPerfV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                ByteArrayOutputStreamAPCByteWriter dataWriter = new ByteArrayOutputStreamAPCByteWriter();
                ByteBuffer buffer = ByteBuffer.wrap(message.data).order(ByteOrder.LITTLE_ENDIAN);
                while (buffer.hasRemaining()) {
                    long v = buffer.getLong();
                    PROPERTY_PACKED_WORD.write(dataWriter, v);
                }
                byte @NonNull [] data = dataWriter.data();
                PROPERTY_CPU.write(stream, message.cpu);
                PROPERTY_LENGTH.write(stream, data.length);
                stream.write(data);
            }
        }
    }
}

