/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.v22;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.GatorStringProperty;
import com.arm.streamline.protocol.gator.messages.IIntProperty;
import com.arm.streamline.protocol.gator.messages.ILongProperty;
import com.arm.streamline.protocol.gator.messages.IMessage;
import com.arm.streamline.protocol.gator.messages.IMessageCodec;
import com.arm.streamline.protocol.gator.messages.IObjectProperty;
import com.arm.streamline.protocol.gator.messages.ITaggedMessageRecord;
import com.arm.streamline.protocol.gator.messages.ITaggedMessageRecordCodec;
import com.arm.streamline.protocol.gator.messages.ITaggedRecordListProperty;
import com.arm.streamline.protocol.gator.messages.PackedIntProperty;
import com.arm.streamline.protocol.gator.messages.PackedLongProperty;
import com.arm.streamline.protocol.gator.messages.TaggedRecordListProperty;
import com.arm.streamline.protocol.gator.v22.IMessageCodecContextV22;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public final class SummaryFrame
implements IMessage<Codec> {
    public static final int TOKEN_CORE = 3;
    public static final int TOKEN_SUMMARY = 1;
    public final @NonNull List<@NonNull ISummaryFrameRecord<?>> records;

    public SummaryFrame(@NonNull List<@NonNull ISummaryFrameRecord<?>> records) {
        this.records = Collections.unmodifiableList(records);
    }

    @Override
    public @NonNull Codec getCodec() {
        return Codec.INSTANCE;
    }

    public @NonNull String toString() {
        return String.format("SummaryFrame(%s)", this.records);
    }

    public static final class Codec
    extends Enum<Codec>
    implements IMessageCodec<SummaryFrame, ISummaryFrameConsumer, IMessageCodecContextV22> {
        public static final /* enum */ Codec INSTANCE = new Codec();
        public static final @NonNull ITaggedRecordListProperty<ISummaryFrameRecord<?>, @NonNull IMessageCodecContextV22> PROPERTY_RECORDS;
        private static final /* synthetic */ Codec[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Codec[]{INSTANCE};
            PROPERTY_RECORDS = new TaggedRecordListProperty("records", SummaryMessage.Codec.INSTANCE, CoreNameMessage.Codec.INSTANCE);
        }

        @Override
        public void decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream, @NonNull ISummaryFrameConsumer consumer) throws IOException {
            assert (token == this.token());
            Throwable throwable = null;
            Object var6_7 = null;
            try (ISummaryFrameMessageConsumer recordConsumer = consumer.consumeSummaryFrame();){
                PROPERTY_RECORDS.stream(context, stream, record -> record.consume(recordConsumer));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        public int encode(@NonNull SummaryFrame message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
            PROPERTY_RECORDS.write(context, stream, message.records);
            return this.token();
        }

        @Override
        public int token() {
            return 1;
        }

        public static Codec[] values() {
            Codec[] codecArray = ENUM$VALUES;
            int n = codecArray.length;
            Codec[] codecArray2 = new Codec[n];
            System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
            return codecArray2;
        }

        public static Codec valueOf(String string) {
            return Enum.valueOf(Codec.class, string);
        }
    }

    public static final class CoreNameMessage
    implements ISummaryFrameRecord<CoreNameMessage> {
        public final int core;
        public final int cpuid;
        public final @NonNull String name;

        public CoreNameMessage(int core, int cpuid, @NonNull String name) {
            this.core = core;
            this.cpuid = cpuid;
            this.name = name;
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull ISummaryFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ISummaryFrameMessageConsumer consumer) throws IOException {
            consumer.consume(this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<CoreNameMessage, IMessageCodecContextV22> getCodec() {
            return Codec.INSTANCE;
        }

        public @NonNull String toString() {
            return String.format("CoreNameMessage(%d, 0x%05x, %s)", this.core, this.cpuid, this.name);
        }

        public static final class Codec
        extends Enum<Codec>
        implements ITaggedMessageRecordCodec<CoreNameMessage, IMessageCodecContextV22> {
            public static final /* enum */ Codec INSTANCE = new Codec();
            public static final @NonNull IIntProperty PROPERTY_CORE;
            public static final @NonNull IIntProperty PROPERTY_CPUID;
            public static final @NonNull IObjectProperty<String> PROPERTY_NAME;
            private static final /* synthetic */ Codec[] ENUM$VALUES;

            static {
                ENUM$VALUES = new Codec[]{INSTANCE};
                PROPERTY_CORE = new PackedIntProperty("core");
                PROPERTY_CPUID = new PackedIntProperty("cpuid");
                PROPERTY_NAME = new GatorStringProperty("name");
            }

            @Override
            public @NonNull CoreNameMessage decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                assert (token == this.token());
                int core = PROPERTY_CORE.read(stream);
                int cpuid = PROPERTY_CPUID.read(stream);
                @NonNull String name = PROPERTY_NAME.read(stream);
                return new CoreNameMessage(core, cpuid, name);
            }

            @Override
            public int encode(@NonNull CoreNameMessage message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                PROPERTY_CORE.write(stream, message.core);
                PROPERTY_CPUID.write(stream, message.cpuid);
                PROPERTY_NAME.write(stream, message.name);
                return this.token();
            }

            @Override
            public int token() {
                return 3;
            }

            public static Codec[] values() {
                Codec[] codecArray = ENUM$VALUES;
                int n = codecArray.length;
                Codec[] codecArray2 = new Codec[n];
                System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
                return codecArray2;
            }

            public static Codec valueOf(String string) {
                return Enum.valueOf(Codec.class, string);
            }
        }
    }

    public static interface ISummaryFrameConsumer {
        public @NonNull ISummaryFrameMessageConsumer consumeSummaryFrame() throws IOException;
    }

    public static interface ISummaryFrameMessageConsumer
    extends Closeable {
        public void consume(@NonNull CoreNameMessage var1) throws IOException;

        public void consume(@NonNull SummaryMessage var1) throws IOException;
    }

    public static interface ISummaryFrameRecord<T extends ISummaryFrameRecord<? extends T>>
    extends ITaggedMessageRecord<T, IMessageCodecContextV22> {
        public <U, R, E extends Throwable> R accept(@NonNull ISummaryFrameRecordVisitor<U, R, E> var1, U var2) throws E;

        public void consume(@NonNull ISummaryFrameMessageConsumer var1) throws IOException;
    }

    public static interface ISummaryFrameRecordVisitor<U, R, E extends Throwable> {
        public R visit(@NonNull CoreNameMessage var1, U var2) throws E;

        public R visit(@NonNull SummaryMessage var1, U var2) throws E;
    }

    public static final class SummaryMessage
    implements ISummaryFrameRecord<SummaryMessage> {
        public static final @NonNull String ATTRIBUTE_KEY_NOSYNC = "nosync";
        public final @NonNull Map<@NonNull String, @NonNull String> attributes;
        public final long bootTime;
        public final long monotonicTime;
        public final long wallClockTime;

        public SummaryMessage(long wallClockTime, long bootTime, long monotonicTime, @NonNull Map<@NonNull String, @NonNull String> attributes) {
            this.wallClockTime = wallClockTime;
            this.bootTime = bootTime;
            this.monotonicTime = monotonicTime;
            this.attributes = Collections.unmodifiableMap(attributes);
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull ISummaryFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ISummaryFrameMessageConsumer consumer) throws IOException {
            consumer.consume(this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<SummaryMessage, IMessageCodecContextV22> getCodec() {
            return Codec.INSTANCE;
        }

        public @NonNull String toString() {
            return String.format("SummaryMessage(%d, %d, %d, %s)", this.wallClockTime, this.bootTime, this.monotonicTime, this.attributes);
        }

        public static final class Codec
        extends Enum<Codec>
        implements ITaggedMessageRecordCodec<SummaryMessage, IMessageCodecContextV22> {
            public static final /* enum */ Codec INSTANCE = new Codec();
            public static final @NonNull String CANARY = "1\n2\r\n3\r4\n\r5";
            public static final @NonNull ILongProperty PROPERTY_BOOT_TIME;
            public static final @NonNull IObjectProperty<String> PROPERTY_CANARY;
            public static final @NonNull IObjectProperty<String> PROPERTY_KEY;
            public static final @NonNull ILongProperty PROPERTY_MONOTONIC_TIME;
            public static final @NonNull ILongProperty PROPERTY_CLOCK_MONOTONIC_START;
            public static final @NonNull IObjectProperty<String> PROPERTY_VALUE;
            public static final @NonNull ILongProperty PROPERTY_WALLCLOCK_TIME;
            private static final @NonNull String MAGIC_KEY_END_OF_ATTRIBUTES = "";
            private static final /* synthetic */ Codec[] ENUM$VALUES;

            static {
                ENUM$VALUES = new Codec[]{INSTANCE};
                PROPERTY_BOOT_TIME = new PackedLongProperty("bootTime");
                PROPERTY_CANARY = new GatorStringProperty("canary");
                PROPERTY_KEY = new GatorStringProperty("attribute.key");
                PROPERTY_MONOTONIC_TIME = new PackedLongProperty("monotonicTime");
                PROPERTY_CLOCK_MONOTONIC_START = new PackedLongProperty("clockMonotonicStart");
                PROPERTY_VALUE = new GatorStringProperty("attribute.value");
                PROPERTY_WALLCLOCK_TIME = new PackedLongProperty("wallClockTime");
            }

            @Override
            public @NonNull SummaryMessage decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                assert (token == this.token());
                @NonNull HashMap<@NonNull String, @NonNull String> attributes = new HashMap<String, String>();
                @NonNull String canary = PROPERTY_CANARY.read(stream);
                if (!CANARY.equals(canary)) {
                    throw new IOException("Invalid canary value");
                }
                long wallClockTime = PROPERTY_WALLCLOCK_TIME.read(stream);
                long bootTime = PROPERTY_BOOT_TIME.read(stream);
                long monotonicTime = PROPERTY_MONOTONIC_TIME.read(stream);
                if (context.getProtocolVersionNo() >= 910 || context.getProtocolVersionNo() < 0) {
                    PROPERTY_CLOCK_MONOTONIC_START.read(stream);
                }
                while (stream.hasRemaining()) {
                    @NonNull String key = PROPERTY_KEY.read(stream);
                    if (key.equals(MAGIC_KEY_END_OF_ATTRIBUTES)) break;
                    @NonNull String value = PROPERTY_VALUE.read(stream);
                    attributes.put(key, value);
                }
                return new SummaryMessage(wallClockTime, bootTime, monotonicTime, attributes);
            }

            @Override
            public int encode(@NonNull SummaryMessage message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                PROPERTY_CANARY.write(stream, CANARY);
                PROPERTY_WALLCLOCK_TIME.write(stream, message.wallClockTime);
                PROPERTY_BOOT_TIME.write(stream, message.bootTime);
                PROPERTY_MONOTONIC_TIME.write(stream, message.monotonicTime);
                for (Map.Entry<String, String> entry : message.attributes.entrySet()) {
                    assert (!entry.getKey().equals(MAGIC_KEY_END_OF_ATTRIBUTES));
                    PROPERTY_KEY.write(stream, entry.getKey());
                    PROPERTY_VALUE.write(stream, entry.getValue());
                }
                PROPERTY_KEY.write(stream, MAGIC_KEY_END_OF_ATTRIBUTES);
                return this.token();
            }

            @Override
            public int token() {
                return 1;
            }

            public static Codec[] values() {
                Codec[] codecArray = ENUM$VALUES;
                int n = codecArray.length;
                Codec[] codecArray2 = new Codec[n];
                System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
                return codecArray2;
            }

            public static Codec valueOf(String string) {
                return Enum.valueOf(Codec.class, string);
            }
        }
    }
}

