/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.v22;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.IIntProperty;
import com.arm.streamline.protocol.gator.messages.ILongProperty;
import com.arm.streamline.protocol.gator.messages.IMessage;
import com.arm.streamline.protocol.gator.messages.IMessageCodec;
import com.arm.streamline.protocol.gator.messages.IObjectProperty;
import com.arm.streamline.protocol.gator.messages.PackedIntProperty;
import com.arm.streamline.protocol.gator.messages.PackedLongProperty;
import com.arm.streamline.protocol.gator.messages.RemainingBytesProperty;
import com.arm.streamline.protocol.gator.v22.IMessageCodecContextV22;
import java.io.Closeable;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ExternalFrame
implements IMessage<Codec> {
    public final @Nullable IExternalFrameRecord<?> record;

    public ExternalFrame(@Nullable IExternalFrameRecord<?> record) {
        this.record = record;
    }

    @Override
    public @NonNull Codec getCodec() {
        return Codec.INSTANCE;
    }

    public @NonNull String toString() {
        return String.format("ExternalFrame(%s)", this.record);
    }

    public static final class Codec
    extends Enum<Codec>
    implements IMessageCodec<ExternalFrame, IExternalFrameConsumer, IMessageCodecContextV22> {
        public static final /* enum */ Codec INSTANCE = new Codec();
        public static final int MAGIC_FD_CLOSE = -1;
        public static final @NonNull IIntProperty PROPERTY_FD;
        private static final /* synthetic */ Codec[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Codec[]{INSTANCE};
            PROPERTY_FD = new PackedIntProperty("fd");
        }

        @Override
        public void decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream, @NonNull IExternalFrameConsumer consumer) throws IOException {
            assert (token == this.token());
            Throwable throwable = null;
            Object var6_7 = null;
            try (IExternalFrameMessageConsumer recordConsumer = consumer.consumeExternalFrame();){
                if (stream.hasRemaining()) {
                    int fd = PROPERTY_FD.read(stream);
                    if (fd != -1) {
                        @NonNull ExternalDataRecord record = ExternalDataRecord.decode(fd, stream);
                        recordConsumer.consume(record);
                    } else {
                        @NonNull ExternalDataChannelCloseRecord record = ExternalDataChannelCloseRecord.decode(context, stream);
                        recordConsumer.consume(record);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        public int encode(@NonNull ExternalFrame message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
            @Nullable IExternalFrameRecord<?> record = message.record;
            if (record != null) {
                record.encode(context, stream);
            }
            return this.token();
        }

        @Override
        public int token() {
            return 10;
        }

        public static Codec[] values() {
            Codec[] codecArray = ENUM$VALUES;
            int n = codecArray.length;
            Codec[] codecArray2 = new Codec[n];
            System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
            return codecArray2;
        }

        public static Codec valueOf(String string) {
            return Enum.valueOf(Codec.class, string);
        }
    }

    public static final class ExternalDataChannelCloseRecord
    implements IExternalFrameRecord<ExternalDataChannelCloseRecord> {
        public static final @NonNull IIntProperty PROPERTY_TID = new PackedIntProperty("tid");
        public static final @NonNull ILongProperty PROPERTY_TIMESTAMP = new PackedLongProperty("timestamp");
        public final int fd;

        public static @NonNull ExternalDataChannelCloseRecord decode(@NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
            int fd = Codec.PROPERTY_FD.read(stream);
            return new ExternalDataChannelCloseRecord(fd);
        }

        public static void encode(@NonNull ExternalDataChannelCloseRecord message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
            Codec.PROPERTY_FD.write(stream, -1);
            Codec.PROPERTY_FD.write(stream, message.fd);
        }

        public ExternalDataChannelCloseRecord(int fd) {
            this.fd = fd;
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IExternalFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void encode(@NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
            ExternalDataChannelCloseRecord.encode(this, context, stream);
        }

        public @NonNull String toString() {
            return String.format("CloseRecord(%d)", this.fd);
        }
    }

    public static final class ExternalDataRecord
    implements IExternalFrameRecord<ExternalDataRecord> {
        public static final @NonNull IObjectProperty<byte[]> PROPERTY_DATA = new RemainingBytesProperty("data");
        public final byte @NonNull [] data;
        public final int fd;
        public final int offset;

        public static @NonNull ExternalDataRecord decode(int fd, @NonNull IAPCByteReader stream) throws IOException {
            byte @NonNull [] data = PROPERTY_DATA.read(stream);
            int offset = stream.position() - data.length;
            return new ExternalDataRecord(fd, offset, data);
        }

        public static void encode(@NonNull ExternalDataRecord message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
            Codec.PROPERTY_FD.write(stream, message.fd);
            PROPERTY_DATA.write(stream, message.data);
        }

        public ExternalDataRecord(int fd, int offset, byte @NonNull [] data) {
            if (fd == -1) {
                throw new IllegalArgumentException("fd cannot be -1");
            }
            this.fd = fd;
            this.offset = offset;
            this.data = data;
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IExternalFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void encode(@NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
            ExternalDataRecord.encode(this, context, stream);
        }

        public @NonNull String toString() {
            return String.format("DataRecord(%d, %d, %d)", this.fd, this.offset, this.data.length);
        }
    }

    public static interface IExternalFrameConsumer {
        public @NonNull IExternalFrameMessageConsumer consumeExternalFrame() throws IOException;
    }

    public static interface IExternalFrameMessageConsumer
    extends Closeable {
        public void consume(@NonNull ExternalDataChannelCloseRecord var1) throws IOException;

        public void consume(@NonNull ExternalDataRecord var1) throws IOException;
    }

    public static interface IExternalFrameRecord<T extends IExternalFrameRecord<? extends T>> {
        public <U, R, E extends Throwable> R accept(@NonNull IExternalFrameRecordVisitor<U, R, E> var1, U var2) throws E;

        public void encode(@NonNull IMessageCodecContextV22 var1, @NonNull IAPCByteWriter var2) throws IOException;
    }

    public static interface IExternalFrameRecordVisitor<U, R, E extends Throwable> {
        public R visit(@NonNull ExternalDataChannelCloseRecord var1, U var2) throws E;

        public R visit(@NonNull ExternalDataRecord var1, U var2) throws E;
    }
}

