/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.messages;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.ILongProperty;
import com.arm.streamline.protocol.gator.messages.IOptionalLongProperty;
import com.arm.streamline.protocol.gator.messages.IOptionalObjectProperty;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class PackedLongProperty
implements ILongProperty,
IOptionalLongProperty {
    private final @NonNull String name;

    public PackedLongProperty(@NonNull String name) {
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public long read(@NonNull IAPCByteReader stream) throws IOException {
        return stream.getPackedLong();
    }

    @Override
    public @Nullable Long readOptional(@NonNull IAPCByteReader stream) throws IOException {
        if (!IOptionalObjectProperty.test(stream)) {
            return null;
        }
        return this.read(stream);
    }

    @Override
    public void write(@NonNull IAPCByteWriter stream, long value) throws IOException {
        stream.writePackedLong(value);
    }

    @Override
    public void writeOptional(@NonNull IAPCByteWriter stream, @Nullable Long value) throws IOException {
        if (IOptionalObjectProperty.set(stream, value)) {
            assert (value != null);
            this.write(stream, value);
        }
    }
}

