/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.io;

import com.arm.streamline.protocol.gator.io.APCByteDataCodec;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNull;

public interface IAPCByteReader {
    public byte @NonNull [] bytes();

    default public void get(byte @NonNull [] data) throws IOException {
        this.get(data, 0, data.length);
    }

    public void get(byte @NonNull [] var1, int var2, int var3) throws IOException;

    default public void get(@NonNull OutputStream dest, int length) throws IOException {
        byte[] data = new byte[length];
        this.get(data);
        dest.write(data);
    }

    public int getLEInt() throws IOException;

    public long getLELong() throws IOException;

    public short getLEShort() throws IOException;

    default public int getPackedInt() throws IOException {
        return APCByteDataCodec.getPackedInt(this);
    }

    default public long getPackedLong() throws IOException {
        return APCByteDataCodec.getPackedLong(this);
    }

    public byte getSignedByte() throws IOException;

    default public int getUnsignedByte() throws IOException {
        return this.getSignedByte() & 0xFF;
    }

    public boolean hasRemaining();

    public int peekUnsignedByte() throws IOException;

    public int position();

    default public @NonNull String readCString() throws IOException {
        return this.readNullTerminatedString(StandardCharsets.US_ASCII);
    }

    default public @NonNull String readGatorString() throws IOException {
        return APCByteDataCodec.readGatorString(this);
    }

    default public @NonNull String readNullTerminatedString(@NonNull Charset characterSet) throws IOException {
        return APCByteDataCodec.readNullTerminatedString(this, characterSet);
    }

    default public @NonNull String readNullTerminatedUTF8String() throws IOException {
        return this.readNullTerminatedString(StandardCharsets.UTF_8);
    }

    default public @NonNull String readRemainingAsUTF8String() throws IOException {
        return this.readUTF8String(this.remaining());
    }

    default public @NonNull String readUTF8String(int len) throws IOException {
        if (len <= 0) {
            return "";
        }
        byte[] data = new byte[len];
        this.get(data);
        return new String(data, StandardCharsets.UTF_8);
    }

    public int remaining();

    public void skipBytes(int var1) throws IOException;
}

