/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.mipe;

import com.arm.streamline.protocol.ProtocolException;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipeHeader;
import gnu.trove.TCollections;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNull;

public final class MipePacket_Control_HW_Counter_Directory {
    public final @NonNull TIntObjectMap<String> counterNames;
    public final @NonNull MipeHeader header;

    public static @NonNull MipePacket_Control_HW_Counter_Directory create(@NonNull MipeHeader header, byte @NonNull [] data) throws ProtocolException {
        if (header.getPacketFamily() != 0 || header.getPacketId() != 2) {
            throw new IllegalArgumentException();
        }
        int dataLength = header.getDataLength();
        if (dataLength > data.length) {
            throw new IllegalArgumentException();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, 0, dataLength);
        byteBuffer.order(header.getByteOrder());
        TIntObjectHashMap counterNames = new TIntObjectHashMap(10, 0.5f, -1);
        while (byteBuffer.remaining() >= 6) {
            String counterName;
            int counterIndex = byteBuffer.getShort() & 0xFFFF;
            int counterNameLength = byteBuffer.getInt();
            assert (counterNameLength >= 0);
            assert (counterNameLength < 1024);
            assert (byteBuffer.remaining() >= counterNameLength);
            byte[] bytes = new byte[counterNameLength];
            byteBuffer.get(bytes);
            assert (bytes.length == 0 || bytes[bytes.length - 1] == 0);
            String string = counterName = bytes.length > 0 ? new String(bytes, 0, bytes.length - 1, StandardCharsets.US_ASCII) : "";
            assert (!counterNames.containsKey(counterIndex));
            counterNames.put(counterIndex, (Object)counterName);
        }
        return new MipePacket_Control_HW_Counter_Directory(header, (TIntObjectMap<String>)counterNames);
    }

    protected MipePacket_Control_HW_Counter_Directory(@NonNull MipeHeader header, @NonNull TIntObjectMap<String> counterNames) {
        this.header = header;
        this.counterNames = TCollections.unmodifiableMap(counterNames);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MipePacket_Control_HW_Counter_Directory) {
            MipePacket_Control_HW_Counter_Directory that = (MipePacket_Control_HW_Counter_Directory)obj;
            return this.header.equals(that.header) && this.counterNames.equals(that.counterNames);
        }
        return false;
    }

    public int hashCode() {
        return this.header.hashCode() * 31 + this.counterNames.hashCode();
    }

    public String toString() {
        return String.format("MipePacket_Control_HW_Counter_Directory [header=%s, counterNames=%s]", this.header, this.counterNames);
    }
}

