/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.mipe;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MipePacketBuffer {
    private static final byte @NonNull [] EMPTY = new byte[0];
    private byte @NonNull [] currentBuffer = EMPTY;

    public byte @NonNull [] data() {
        return this.currentBuffer;
    }

    public void mergeBuffers(byte @NonNull [] data) {
        byte[] newBuffer;
        byte @Nullable [] currentBuffer = this.currentBuffer;
        if (currentBuffer.length > 0) {
            if (data.length == 0) {
                return;
            }
            newBuffer = new byte[currentBuffer.length + data.length];
            System.arraycopy(currentBuffer, 0, newBuffer, 0, currentBuffer.length);
            System.arraycopy(data, 0, newBuffer, currentBuffer.length, data.length);
        } else {
            newBuffer = data;
        }
        this.currentBuffer = newBuffer;
    }

    public byte @Nullable [] removePacket(int headerSize, int payloadSize) {
        byte[] newBuffer;
        byte[] payloadData;
        if (headerSize < 0 || payloadSize < 0) {
            throw new IllegalArgumentException();
        }
        byte @NonNull [] currentBuffer = this.currentBuffer;
        int totalRemoved = headerSize + payloadSize;
        int remainingBytes = currentBuffer.length - totalRemoved;
        if (totalRemoved == 0) {
            return EMPTY;
        }
        if (remainingBytes < 0) {
            return null;
        }
        if (headerSize == 0 && remainingBytes == 0) {
            payloadData = currentBuffer;
        } else if (payloadSize == 0) {
            payloadData = EMPTY;
        } else {
            payloadData = new byte[payloadSize];
            System.arraycopy(currentBuffer, headerSize, payloadData, 0, payloadData.length);
        }
        if (remainingBytes == 0) {
            newBuffer = EMPTY;
        } else {
            newBuffer = new byte[remainingBytes];
            System.arraycopy(currentBuffer, totalRemoved, newBuffer, 0, newBuffer.length);
        }
        this.currentBuffer = newBuffer;
        return payloadData;
    }
}

