/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.StaticCounterSeriesKey;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.protocol.external.IMidgardActivityParser;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.misc.TaskId;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.OptionalInt;
import java.util.Queue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MidgardActivityParser
implements IMidgardActivityParser {
    private static final String ATTRIB_MATCH_LIST_CTX_NR_ATOM_NR = "ctx_nr,atom_nr";
    private static final int GIVE_UP_THRESHOLD = 16;
    private static final int NR_JOB_SLOTS = 3;
    private final @Nullable StaticCounterSeriesKey @NonNull [] activityCounterSeries = new StaticCounterSeriesKey[3];
    private long lastCheckedTimestamp = Long.MIN_VALUE;
    private final TLongObjectHashMap<CinstrAtom> mCinstrAtomsByNr = new TLongObjectHashMap();
    private final TLongObjectHashMap<CinstrAtom> mCinstrAtomsByPtr = new TLongObjectHashMap();
    private final TLongObjectHashMap<CinstrContext> mCinstrContextsByPtr = new TLongObjectHashMap();
    private final Queue<Event> mCinstrEvents = new ArrayDeque<Event>();
    private boolean mGaveUp = false;
    private boolean mGotCinstr = false;
    private boolean mGotKbase = false;
    private final @NonNull Queue<@NonNull OptionalInt> @NonNull [] mJobSlotPidQueues;
    private final TLongObjectHashMap<KbaseAtom> mKbaseAtomsByPtr = new TLongObjectHashMap();
    private final TLongObjectHashMap<KbaseContext> mKbaseContextsByPtr = new TLongObjectHashMap();
    private final Queue<Event> mKbaseEvents = new ArrayDeque<Event>();
    private final TLongObjectHashMap<KbaseJobSlot> mKbaseJobSlotsByPtr = new TLongObjectHashMap();
    private final int mPid;
    private final @NonNull IExternalProtocolEventStream outputStream;
    private final @Nullable ProcessingElementReference @NonNull [] peReferences = new ProcessingElementReference[3];

    public MidgardActivityParser(long vmUID, int pid, @NonNull IExternalProtocolPassTwoState passTwoState, @NonNull IExternalProtocolEventStream outputStream) {
        this.outputStream = outputStream;
        this.mPid = pid;
        this.mJobSlotPidQueues = new Queue[]{new ArrayDeque(), new ArrayDeque(), new ArrayDeque()};
        @NonNull ProcessingElementReferenceSet peReferenceSet = passTwoState.getPeReferenceSet();
        for (StaticCounterSeriesKey counterSeriesKey : passTwoState.getStaticCounterSeries().getAllStaticCounterSeries()) {
            @NonNull CounterRecord counterRecord = counterSeriesKey.getCounterRecord();
            switch (counterRecord.getCounter()) {
                case "ARM_Mali-Midgard_fragment": {
                    this.activityCounterSeries[0] = counterSeriesKey;
                    this.peReferences[0] = peReferenceSet.get(counterSeriesKey.getDeviceTypeOrDefault(), vmUID, 0);
                    break;
                }
                case "ARM_Mali-Midgard_vertex": {
                    this.activityCounterSeries[1] = counterSeriesKey;
                    this.peReferences[1] = peReferenceSet.get(counterSeriesKey.getDeviceTypeOrDefault(), vmUID, 0);
                    break;
                }
                case "ARM_Mali-Midgard_opencl": {
                    this.activityCounterSeries[2] = counterSeriesKey;
                    this.peReferences[2] = peReferenceSet.get(counterSeriesKey.getDeviceTypeOrDefault(), vmUID, 0);
                    break;
                }
            }
        }
    }

    @Override
    public final void cinstrContextAddNr(long time, long ctxPtr, long ctxNr) throws IOException {
        this.pushCinstr(new CinstrContextAddNr(time, ctxPtr, ctxNr));
    }

    @Override
    public final void cinstrDeleteAtom(long time, long atomPtr) throws IOException {
        this.pushCinstr(new CinstrDeleteAtom(time, atomPtr));
    }

    @Override
    public final void cinstrDeleteContext(long time, long ctxPtr) throws IOException {
        this.pushCinstr(new CinstrDeleteContext(time, ctxPtr));
    }

    @Override
    public final void cinstrNewAtom(long time, long atomPtr, long atomNr) throws IOException {
        this.pushCinstr(new CinstrNewAtom(time, atomPtr, atomNr));
    }

    @Override
    public final void cinstrNewContext(long time, long ctxPtr) throws IOException {
        this.pushCinstr(new CinstrNewContext(time, ctxPtr));
    }

    @Override
    public final void cinstrRetainAtomContext(long time, long atomPtr, long ctxPtr) throws IOException {
        this.pushCinstr(new CinstrRetainAtomContext(time, atomPtr, ctxPtr));
    }

    @Override
    public final void cinstrUnretainAtomContext(long time, long atomPtr, long ctxPtr) throws IOException {
        this.pushCinstr(new CinstrUnretainAtomContext(time, atomPtr, ctxPtr));
    }

    @Override
    public final void gotCinstr() {
        if (this.mGaveUp) {
            throw new RuntimeException("Got cinstr after giving up waiting for it");
        }
        this.mGotCinstr = true;
    }

    @Override
    public final void gotKbase() {
        if (this.mGaveUp) {
            throw new RuntimeException("Got kbase after giving up waiting for it");
        }
        this.mGotKbase = true;
    }

    @Override
    public final void kbaseDeleteAtom(long time, long atomPtr) throws IOException {
        this.pushKbase(new KbaseDeleteAtom(time, atomPtr));
    }

    @Override
    public final void kbaseDeleteContext(long time, long ctxPtr) throws IOException {
        this.pushKbase(new KbaseDeleteContext(time, ctxPtr));
    }

    @Override
    public final void kbaseNewAtom(long time, long atomPtr, long atomNr) throws IOException {
        this.pushKbase(new KbaseNewAtom(time, atomPtr, atomNr));
    }

    @Override
    public final void kbaseNewContext(long time, long ctxPtr, long contextNr) throws IOException {
        this.pushKbase(new KbaseNewContext(time, ctxPtr, contextNr));
    }

    @Override
    public final void kbaseNewJobSlot(long time, long lpuPtr, long lpuNr, long lpuFn) throws IOException {
        this.pushKbase(new KbaseNewJobSlot(time, lpuPtr, lpuNr));
    }

    @Override
    public final void kbaseRetainAtomContext(long time, long atomPtr, long ctxPtr) throws IOException {
        this.pushKbase(new KbaseRetainAtomContext(time, atomPtr, ctxPtr));
    }

    @Override
    public final void kbaseRetainAtomJobSlot(long time, long atomPtr, long lpuPtr, String attribMatchList) throws IOException {
        this.pushKbase(new KbaseRetainAtomJobSlot(time, atomPtr, lpuPtr, attribMatchList));
    }

    @Override
    public final void kbaseUnretainAtomContext(long time, long atomPtr, long ctxPtr) throws IOException {
        this.pushKbase(new KbaseUnretainAtomContext(time, atomPtr, ctxPtr));
    }

    @Override
    public final void kbaseUnretainAtomJobSlot(long time, long atomPtr, long lpuPtr) throws IOException {
        this.pushKbase(new KbaseUnretainAtomJobSlot(time, atomPtr, lpuPtr));
    }

    protected final void cinstEvalContextAddNr(long time, long ctxPtr, long ctxNr) {
        this.checkTimestamp(time);
        CinstrContext context = (CinstrContext)this.mCinstrContextsByPtr.get(ctxPtr);
        if (context == null) {
            throw new RuntimeException("Unknown cinstr context " + ctxPtr + " referenced");
        }
        context.setNr(ctxNr);
    }

    protected final void cinstEvalDeleteAtom(long time, long atomPtr) {
        this.checkTimestamp(time);
        CinstrAtom atom = (CinstrAtom)this.mCinstrAtomsByPtr.remove(atomPtr);
        if (atom == null) {
            return;
        }
        CinstrAtom oldAtom = (CinstrAtom)this.mCinstrAtomsByNr.remove(atom.getNr());
        if (atom != oldAtom) {
            throw new RuntimeException(String.valueOf(atom) + " by number also matches " + String.valueOf(oldAtom));
        }
        atom.verifyUnreferenced();
    }

    protected final void cinstEvalDeleteContext(long time, long ctxPtr) {
        this.checkTimestamp(time);
        CinstrContext context = (CinstrContext)this.mCinstrContextsByPtr.remove(ctxPtr);
        if (context == null) {
            throw new RuntimeException("Unknown context deleted");
        }
        context.verifyUnreferenced();
    }

    protected final void cinstEvalNewAtom(long time, long atomPtr, long atomNr) {
        this.checkTimestamp(time);
        CinstrAtom atom = new CinstrAtom(atomNr);
        CinstrAtom oldAtom = (CinstrAtom)this.mCinstrAtomsByPtr.put(atomPtr, (Object)atom);
        if (oldAtom != null) {
            throw new RuntimeException("New atom created with the same ptr as an existing one");
        }
        oldAtom = (CinstrAtom)this.mCinstrAtomsByNr.put(atomNr, (Object)atom);
        if (oldAtom != null) {
            throw new RuntimeException("New atom created with the same nr as an existing one");
        }
    }

    protected final void cinstEvalNewContext(long time, long ctxPtr) {
        this.checkTimestamp(time);
        CinstrContext oldContext = (CinstrContext)this.mCinstrContextsByPtr.put(ctxPtr, (Object)new CinstrContext());
        if (oldContext != null) {
            throw new RuntimeException("New context created with the same ptr as an existing one");
        }
    }

    protected final void cinstEvalRetainAtomContext(long time, long atomPtr, long ctxPtr) {
        this.checkTimestamp(time);
        CinstrAtom atom = (CinstrAtom)this.mCinstrAtomsByPtr.get(atomPtr);
        if (atom == null) {
            throw new RuntimeException("Unknown cinstr atom " + atomPtr + " referenced");
        }
        CinstrContext context = (CinstrContext)this.mCinstrContextsByPtr.get(ctxPtr);
        if (context == null) {
            throw new RuntimeException("Unknown cinstr context " + ctxPtr + " referenced");
        }
        atom.retain(context);
    }

    protected final void cinstEvalUnretainAtomContext(long time, long atomPtr, long ctxPtr) {
        this.checkTimestamp(time);
        CinstrAtom atom = (CinstrAtom)this.mCinstrAtomsByPtr.get(atomPtr);
        if (atom == null) {
            return;
        }
        CinstrContext context = (CinstrContext)this.mCinstrContextsByPtr.get(ctxPtr);
        if (context == null) {
            throw new RuntimeException("Unknown cinstr context " + ctxPtr + " referenced");
        }
        atom.unretain(context);
    }

    protected final void kbaseEvalDeleteAtom(long time, long atomPtr) {
        this.checkTimestamp(time);
        KbaseAtom atom = (KbaseAtom)this.mKbaseAtomsByPtr.remove(atomPtr);
        if (atom == null) {
            return;
        }
        atom.verifyUnreferenced();
    }

    protected final void kbaseEvalDeleteContext(long time, long ctxPtr) {
        this.checkTimestamp(time);
        KbaseContext context = (KbaseContext)this.mKbaseContextsByPtr.remove(ctxPtr);
        if (context == null) {
            throw new RuntimeException("Unknown context deleted");
        }
        context.verifyUnreferenced();
    }

    protected final void kbaseEvalNewAtom(long time, long atomPtr, long atomNr) {
        this.checkTimestamp(time);
        KbaseAtom oldAtom = (KbaseAtom)this.mKbaseAtomsByPtr.put(atomPtr, (Object)new KbaseAtom(atomNr));
        if (oldAtom != null) {
            throw new RuntimeException("New atom created with the same ptr as an existing one");
        }
    }

    protected final void kbaseEvalNewContext(long time, long ctxPtr, long contextNr) {
        this.checkTimestamp(time);
        KbaseContext oldContext = (KbaseContext)this.mKbaseContextsByPtr.put(ctxPtr, (Object)new KbaseContext(contextNr));
        if (oldContext != null) {
            throw new RuntimeException("New context created with the same ptr as an existing one");
        }
    }

    protected final void kbaseEvalNewJobSlot(long time, long lpuPtr, long lpuNr) {
        this.checkTimestamp(time);
        KbaseJobSlot oldJobSlot = (KbaseJobSlot)this.mKbaseJobSlotsByPtr.put(lpuPtr, (Object)new KbaseJobSlot((int)lpuNr));
        if (oldJobSlot != null) {
            throw new RuntimeException("New job slot created with the same ptr as an existing one");
        }
    }

    protected final void kbaseEvalRetainAtomContext(long time, long atomPtr, long ctxPtr) {
        this.checkTimestamp(time);
        KbaseAtom atom = (KbaseAtom)this.mKbaseAtomsByPtr.get(atomPtr);
        if (atom == null) {
            throw new RuntimeException("Unknown kbase atom " + atomPtr + " referenced");
        }
        KbaseContext context = (KbaseContext)this.mKbaseContextsByPtr.get(ctxPtr);
        if (context == null) {
            throw new RuntimeException("Unknown kbase context " + ctxPtr + " referenced");
        }
        atom.retain(context);
    }

    protected final void kbaseEvalRetainAtomJobSlot(long time, long atomPtr, long lpuPtr, String attribMatchList) throws IOException {
        this.checkTimestamp(time);
        KbaseAtom atom = (KbaseAtom)this.mKbaseAtomsByPtr.get(atomPtr);
        if (atom == null) {
            throw new RuntimeException("Unknown kbase atom " + atomPtr + " referenced");
        }
        KbaseJobSlot jobSlot = (KbaseJobSlot)this.mKbaseJobSlotsByPtr.get(lpuPtr);
        if (jobSlot == null) {
            throw new RuntimeException("Unknown kbase job slot " + lpuPtr + " referenced");
        }
        StaticCounterSeriesKey key = this.activityCounterSeries[jobSlot.getNr()];
        ProcessingElementReference peReference = this.peReferences[jobSlot.getNr()];
        if (key != null) {
            TaskId taskId;
            assert (peReference != null);
            Queue<OptionalInt> atoms = this.mJobSlotPidQueues[jobSlot.getNr()];
            @NonNull OptionalInt pid = this.getPid(atom, attribMatchList);
            TaskId taskId2 = taskId = pid.isPresent() ? new TaskId(pid.getAsInt()) : null;
            if (atoms.isEmpty() && time >= 0L) {
                this.outputStream.activitySwitch((ICounterSeriesKey)key, ClockSource.MONOTONIC_RAW, time, peReference, taskId, 1, 0);
            }
            atoms.add(pid);
        }
    }

    protected final void kbaseEvalUnretainAtomContext(long time, long atomPtr, long ctxPtr) {
        this.checkTimestamp(time);
        KbaseAtom atom = (KbaseAtom)this.mKbaseAtomsByPtr.get(atomPtr);
        if (atom == null) {
            return;
        }
        KbaseContext context = (KbaseContext)this.mKbaseContextsByPtr.get(ctxPtr);
        if (context == null) {
            throw new RuntimeException("Unknown kbase context " + ctxPtr + " referenced");
        }
        atom.unretain(context);
    }

    protected final void kbaseEvalUnretainAtomJobSlot(long time, long atomPtr, long lpuPtr) throws IOException {
        this.checkTimestamp(time);
        KbaseAtom atom = (KbaseAtom)this.mKbaseAtomsByPtr.get(atomPtr);
        if (atom == null) {
            return;
        }
        KbaseJobSlot jobSlot = (KbaseJobSlot)this.mKbaseJobSlotsByPtr.get(lpuPtr);
        if (jobSlot == null) {
            throw new RuntimeException("Unknown kbase job slot " + lpuPtr + " referenced");
        }
        StaticCounterSeriesKey key = this.activityCounterSeries[jobSlot.getNr()];
        ProcessingElementReference peReference = this.peReferences[jobSlot.getNr()];
        if (key != null) {
            assert (peReference != null);
            Queue<OptionalInt> atoms = this.mJobSlotPidQueues[jobSlot.getNr()];
            atoms.remove();
            if (time >= 0L) {
                if (atoms.isEmpty()) {
                    this.outputStream.activitySwitch((ICounterSeriesKey)key, ClockSource.MONOTONIC_RAW, time, peReference, null, 0, 0);
                } else {
                    @NonNull OptionalInt pid = atoms.element();
                    TaskId taskId = pid.isPresent() ? new TaskId(pid.getAsInt()) : null;
                    this.outputStream.activitySwitch((ICounterSeriesKey)key, ClockSource.MONOTONIC_RAW, time, peReference, taskId, 1, 0);
                }
            }
        }
    }

    private final void checkTimestamp(long time) {
        if (this.lastCheckedTimestamp > time) {
            throw new RuntimeException("Non-monotonic timestamp encountered");
        }
        this.lastCheckedTimestamp = time;
    }

    private final @NonNull OptionalInt getPid(KbaseAtom kbaseAtom, String attribMatchList) {
        CinstrContext cinstrContext;
        CinstrAtom cinstrAtom;
        KbaseContext kbaseContext;
        OptionalInt pid = OptionalInt.empty();
        if (ATTRIB_MATCH_LIST_CTX_NR_ATOM_NR.equals(attribMatchList) && (kbaseContext = kbaseAtom.getContext()) != null && (cinstrAtom = (CinstrAtom)this.mCinstrAtomsByNr.get(kbaseAtom.getNr())) != null && (cinstrContext = cinstrAtom.getContext()) != null && kbaseContext.getNr() == cinstrContext.getNr()) {
            pid = OptionalInt.of(this.mPid);
        }
        return pid;
    }

    private final void push(boolean gotOther, Queue<Event> events, Event e) throws IOException {
        if (!this.mGaveUp) {
            Event cinstrEvent;
            Event kbaseEvent;
            if (!gotOther && events.size() > 16) {
                events.clear();
                this.mGaveUp = true;
                return;
            }
            events.add(e);
            while ((kbaseEvent = this.mKbaseEvents.peek()) != null && (cinstrEvent = this.mCinstrEvents.peek()) != null) {
                if (kbaseEvent.getTime() > cinstrEvent.getTime()) {
                    this.mCinstrEvents.remove().eval(this);
                    continue;
                }
                this.mKbaseEvents.remove().eval(this);
            }
        }
    }

    private final void pushCinstr(Event e) throws IOException {
        this.push(this.mGotKbase, this.mCinstrEvents, e);
    }

    private final void pushKbase(Event e) throws IOException {
        this.push(this.mGotCinstr, this.mKbaseEvents, e);
    }

    private static final class CinstrAtom {
        private CinstrContext mContext;
        private final long mNr;

        public CinstrAtom(long nr) {
            this.mNr = nr;
        }

        public final CinstrContext getContext() {
            return this.mContext;
        }

        public final long getNr() {
            return this.mNr;
        }

        public final void retain(CinstrContext context) {
            if (this.mContext != null) {
                throw new RuntimeException(String.valueOf(this) + " has more than one context retained at a time");
            }
            this.mContext = context;
        }

        public final String toString() {
            return "CinstrAtom {nr: " + this.mNr + "}";
        }

        public final void unretain(CinstrContext context) {
            if (context != this.mContext) {
                throw new RuntimeException(String.valueOf(this) + " has different " + String.valueOf(context) + " unretained than last retained, " + String.valueOf(this.mContext));
            }
            this.mContext = null;
        }

        public final void verifyUnreferenced() {
            if (this.mContext != null) {
                throw new RuntimeException(String.valueOf(this) + " is being deleted but is still referenced");
            }
        }
    }

    private static final class CinstrContext {
        private long mNr = -1L;

        public final long getNr() {
            return this.mNr;
        }

        public final void setNr(long nr) {
            this.mNr = nr;
        }

        public final String toString() {
            return "CinstrContext {nr: " + this.mNr + "}";
        }

        public final void verifyUnreferenced() {
        }
    }

    private static final class CinstrContextAddNr
    extends Event {
        private final long mCtxNr;
        private final long mCtxPtr;

        public CinstrContextAddNr(long time, long ctxPtr, long ctxNr) {
            super(time);
            this.mCtxPtr = ctxPtr;
            this.mCtxNr = ctxNr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) {
            midgardActivityParser.cinstEvalContextAddNr(this.getTime(), this.mCtxPtr, this.mCtxNr);
        }
    }

    private static final class CinstrDeleteAtom
    extends Event {
        private final long mAtomPtr;

        public CinstrDeleteAtom(long time, long atomPtr) {
            super(time);
            this.mAtomPtr = atomPtr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) {
            midgardActivityParser.cinstEvalDeleteAtom(this.getTime(), this.mAtomPtr);
        }
    }

    private static final class CinstrDeleteContext
    extends Event {
        private final long mCtxPtr;

        public CinstrDeleteContext(long time, long ctxPtr) {
            super(time);
            this.mCtxPtr = ctxPtr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) {
            midgardActivityParser.cinstEvalDeleteContext(this.getTime(), this.mCtxPtr);
        }
    }

    private static final class CinstrNewAtom
    extends Event {
        private final long mAtomNr;
        private final long mAtomPtr;

        public CinstrNewAtom(long time, long atomPtr, long atomNr) {
            super(time);
            this.mAtomPtr = atomPtr;
            this.mAtomNr = atomNr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) {
            midgardActivityParser.cinstEvalNewAtom(this.getTime(), this.mAtomPtr, this.mAtomNr);
        }
    }

    private static final class CinstrNewContext
    extends Event {
        private final long mCtxPtr;

        public CinstrNewContext(long time, long ctxPtr) {
            super(time);
            this.mCtxPtr = ctxPtr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) {
            midgardActivityParser.cinstEvalNewContext(this.getTime(), this.mCtxPtr);
        }
    }

    private static final class CinstrRetainAtomContext
    extends Event {
        private final long mAtomPtr;
        private final long mCtxPtr;

        public CinstrRetainAtomContext(long time, long atomPtr, long ctxPtr) {
            super(time);
            this.mAtomPtr = atomPtr;
            this.mCtxPtr = ctxPtr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) {
            midgardActivityParser.cinstEvalRetainAtomContext(this.getTime(), this.mAtomPtr, this.mCtxPtr);
        }
    }

    private static final class CinstrUnretainAtomContext
    extends Event {
        private final long mAtomPtr;
        private final long mCtxPtr;

        public CinstrUnretainAtomContext(long time, long atomPtr, long ctxPtr) {
            super(time);
            this.mAtomPtr = atomPtr;
            this.mCtxPtr = ctxPtr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) {
            midgardActivityParser.cinstEvalUnretainAtomContext(this.getTime(), this.mAtomPtr, this.mCtxPtr);
        }
    }

    private static abstract class Event {
        private final long mTime;

        public Event(long time) {
            this.mTime = time;
        }

        public abstract void eval(MidgardActivityParser var1) throws IOException;

        public final long getTime() {
            return this.mTime;
        }
    }

    private static final class KbaseAtom {
        private KbaseContext mContext;
        private final long mNr;

        public KbaseAtom(long nr) {
            this.mNr = nr;
        }

        public final KbaseContext getContext() {
            return this.mContext;
        }

        public final long getNr() {
            return this.mNr;
        }

        public final void retain(KbaseContext context) {
            if (this.mContext != null) {
                throw new RuntimeException(String.valueOf(this) + " has more than one context retained at a time");
            }
            this.mContext = context;
        }

        public final String toString() {
            return "KbaseAtom {nr: " + this.mNr + "}";
        }

        public final void unretain(KbaseContext context) {
            if (context != this.mContext) {
                throw new RuntimeException(String.valueOf(this) + " has different " + String.valueOf(context) + " unretained than last retained, " + String.valueOf(this.mContext));
            }
            this.mContext = null;
        }

        public final void verifyUnreferenced() {
            if (this.mContext != null) {
                throw new RuntimeException(String.valueOf(this) + " is being deleted but is still referenced");
            }
        }
    }

    private static final class KbaseContext {
        private final long mNr;

        public KbaseContext(long nr) {
            this.mNr = nr;
        }

        public final long getNr() {
            return this.mNr;
        }

        public final String toString() {
            return "KbaseContext {nr: " + this.mNr + "}";
        }

        public final void verifyUnreferenced() {
        }
    }

    private static final class KbaseDeleteAtom
    extends Event {
        private final long mAtomPtr;

        public KbaseDeleteAtom(long time, long atomPtr) {
            super(time);
            this.mAtomPtr = atomPtr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) {
            midgardActivityParser.kbaseEvalDeleteAtom(this.getTime(), this.mAtomPtr);
        }
    }

    private static final class KbaseDeleteContext
    extends Event {
        private final long mCtxPtr;

        public KbaseDeleteContext(long time, long ctxPtr) {
            super(time);
            this.mCtxPtr = ctxPtr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) {
            midgardActivityParser.kbaseEvalDeleteContext(this.getTime(), this.mCtxPtr);
        }
    }

    private static final class KbaseJobSlot {
        private final int mNr;

        public KbaseJobSlot(int nr) {
            this.mNr = nr;
        }

        public final int getNr() {
            return this.mNr;
        }

        public final String toString() {
            return "KbaseJobSlot {nr: " + this.mNr + "}";
        }
    }

    private static final class KbaseNewAtom
    extends Event {
        private final long mAtomNr;
        private final long mAtomPtr;

        public KbaseNewAtom(long time, long atomPtr, long atomNr) {
            super(time);
            this.mAtomPtr = atomPtr;
            this.mAtomNr = atomNr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) {
            midgardActivityParser.kbaseEvalNewAtom(this.getTime(), this.mAtomPtr, this.mAtomNr);
        }
    }

    private static final class KbaseNewContext
    extends Event {
        private final long mContextNr;
        private final long mCtxPtr;

        public KbaseNewContext(long time, long ctxPtr, long contextNr) {
            super(time);
            this.mCtxPtr = ctxPtr;
            this.mContextNr = contextNr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) {
            midgardActivityParser.kbaseEvalNewContext(this.getTime(), this.mCtxPtr, this.mContextNr);
        }
    }

    private static final class KbaseNewJobSlot
    extends Event {
        private final long mLpuNr;
        private final long mLpuPtr;

        public KbaseNewJobSlot(long time, long lpuPtr, long lpuNr) {
            super(time);
            this.mLpuPtr = lpuPtr;
            this.mLpuNr = lpuNr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) {
            midgardActivityParser.kbaseEvalNewJobSlot(this.getTime(), this.mLpuPtr, this.mLpuNr);
        }
    }

    private static final class KbaseRetainAtomContext
    extends Event {
        private final long mAtomPtr;
        private final long mCtxPtr;

        public KbaseRetainAtomContext(long time, long atomPtr, long ctxPtr) {
            super(time);
            this.mAtomPtr = atomPtr;
            this.mCtxPtr = ctxPtr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) {
            midgardActivityParser.kbaseEvalRetainAtomContext(this.getTime(), this.mAtomPtr, this.mCtxPtr);
        }
    }

    private static final class KbaseRetainAtomJobSlot
    extends Event {
        private final long mAtomPtr;
        private final String mAttribMatchList;
        private final long mLpuPtr;

        public KbaseRetainAtomJobSlot(long time, long atomPtr, long lpuPtr, String attribMatchList) {
            super(time);
            this.mAtomPtr = atomPtr;
            this.mLpuPtr = lpuPtr;
            this.mAttribMatchList = attribMatchList;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) throws IOException {
            midgardActivityParser.kbaseEvalRetainAtomJobSlot(this.getTime(), this.mAtomPtr, this.mLpuPtr, this.mAttribMatchList);
        }
    }

    private static final class KbaseUnretainAtomContext
    extends Event {
        private final long mAtomPtr;
        private final long mCtxPtr;

        public KbaseUnretainAtomContext(long time, long atomPtr, long ctxPtr) {
            super(time);
            this.mAtomPtr = atomPtr;
            this.mCtxPtr = ctxPtr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) {
            midgardActivityParser.kbaseEvalUnretainAtomContext(this.getTime(), this.mAtomPtr, this.mCtxPtr);
        }
    }

    private static final class KbaseUnretainAtomJobSlot
    extends Event {
        private final long mAtomPtr;
        private final long mLpuPtr;

        public KbaseUnretainAtomJobSlot(long time, long atomPtr, long lpuPtr) {
            super(time);
            this.mAtomPtr = atomPtr;
            this.mLpuPtr = lpuPtr;
        }

        @Override
        public final void eval(MidgardActivityParser midgardActivityParser) throws IOException {
            midgardActivityParser.kbaseEvalUnretainAtomJobSlot(this.getTime(), this.mAtomPtr, this.mLpuPtr);
        }
    }
}

