/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import perfetto.protos.GpuRenderStageEventOuterClass;

public class MaliEventDependencyTracker {
    public static final int DEFAULT_BUCKET_COUNT = 10;
    public static final long DEFAULT_BUCKET_SIZE_NSEC = 100000000L;
    private static final int NO_DEPENDENCY_ID = -1;
    private final long bucketSizeNs;
    private final long windowSizeNs;
    private @NonNull LinkedList<@NonNull EventBucket> buckets;

    public MaliEventDependencyTracker(long bucketSizeNanoSeconds, int bucketCount) {
        this.bucketSizeNs = bucketSizeNanoSeconds;
        this.windowSizeNs = bucketSizeNanoSeconds * (long)bucketCount;
        this.buckets = new LinkedList();
    }

    public long trackEvent(long timestamp, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull GpuRenderStageEventOuterClass.GpuRenderStageEvent event) {
        EventBucket bucket = null;
        if (this.buckets.isEmpty() || timestamp >= this.buckets.getFirst().endTimestamp) {
            long bucketStart = timestamp / this.bucketSizeNs * this.bucketSizeNs;
            long bucketEnd = bucketStart + this.bucketSizeNs;
            bucket = new EventBucket(bucketStart, bucketEnd);
            this.buckets.add(0, bucket);
            this.pruneOldBuckets();
        }
        long dependencyId = this.findLastEvent(event.getContext(), event.getSubmissionId());
        for (EventBucket it : this.buckets) {
            if (it.recordEvent(timestamp, event)) break;
        }
        return dependencyId;
    }

    private long findLastEvent(long contextId, int submissionId) {
        for (EventBucket bucket : this.buckets) {
            long lastEvent = bucket.findEventForSubmission(contextId, submissionId);
            if (lastEvent == -1L) continue;
            return lastEvent;
        }
        return -1L;
    }

    private void pruneOldBuckets() {
        long threshold = this.buckets.getFirst().startTimestamp - this.windowSizeNs;
        Iterator<EventBucket> it = this.buckets.descendingIterator();
        while (it.hasNext()) {
            EventBucket bucket = it.next();
            if (bucket.startTimestamp > threshold) break;
            it.remove();
        }
    }

    private static class EventBucket {
        private final long startTimestamp;
        private final long endTimestamp;
        private Map<Key, Long> lastEventBySubmission;

        public EventBucket(long startTimestamp, long endTimestamp) {
            this.startTimestamp = startTimestamp;
            this.endTimestamp = endTimestamp;
            this.lastEventBySubmission = new HashMap<Key, Long>();
        }

        public boolean recordEvent(long timestamp, GpuRenderStageEventOuterClass.GpuRenderStageEvent event) {
            if (timestamp >= this.startTimestamp && timestamp < this.endTimestamp) {
                this.lastEventBySubmission.put(new Key(event.getContext(), event.getSubmissionId()), event.getEventId());
                return true;
            }
            return false;
        }

        public long findEventForSubmission(long contextId, int submissionId) {
            Long value = this.lastEventBySubmission.get(new Key(contextId, submissionId));
            return value == null ? -1L : value;
        }

        private static class Key {
            long contextId;
            int submissionId;

            public Key(long contextId, int submissionId) {
                this.contextId = contextId;
                this.submissionId = submissionId;
            }

            public int hashCode() {
                return Objects.hash(this.contextId, this.submissionId);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                return this.contextId == other.contextId && this.submissionId == other.submissionId;
            }
        }
    }
}

