/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.eclipse.jdt.annotation.NonNull;

public class BufferSequenceInputStream
extends InputStream {
    private @NonNull LinkedList<byte @NonNull []> buffers = new LinkedList();
    private int bufferIndex;
    private int readIndex = 0;
    private int available = 0;
    private int markPosition = -1;
    private int markedAvailable;

    public void appendBuffer(byte @NonNull [] buffer) {
        this.buffers.add(buffer);
        this.available += buffer.length;
    }

    public void clearBuffers() {
        this.buffers.clear();
        this.readIndex = 0;
        this.available = 0;
        this.markPosition = -1;
    }

    @Override
    public int read() throws IOException {
        if (this.buffers.isEmpty()) {
            return -1;
        }
        if (this.readIndex >= this.buffers.get(this.bufferIndex).length) {
            if (this.markPosition < 0) {
                this.buffers.removeFirst();
            } else {
                ++this.bufferIndex;
            }
            this.readIndex = 0;
            return this.read();
        }
        int value = this.buffers.get(this.bufferIndex)[this.readIndex] & 0xFF;
        ++this.readIndex;
        --this.available;
        return value;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.available() < len) {
            return -1;
        }
        int leftToRead = len;
        while (leftToRead > 0) {
            byte[] buffer = this.buffers.get(this.bufferIndex);
            int remainingInBuffer = buffer.length - this.readIndex;
            int amountToRead = Math.min(remainingInBuffer, leftToRead);
            System.arraycopy(buffer, this.readIndex, b, off, amountToRead);
            off += amountToRead;
            leftToRead -= amountToRead;
            this.available -= amountToRead;
            this.readIndex += amountToRead;
            if (this.readIndex < buffer.length) continue;
            ++this.bufferIndex;
            this.readIndex = 0;
        }
        if (this.markPosition < 0) {
            while (this.bufferIndex > 0) {
                this.buffers.removeFirst();
                --this.bufferIndex;
            }
        }
        return len;
    }

    @Override
    public int available() {
        return this.available;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readAhead) {
        if (this.markPosition >= 0) {
            throw new IllegalStateException("Buffer is already marked. Multiple marks are not supported");
        }
        this.markPosition = this.readIndex;
        this.markedAvailable = this.available;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markPosition < 0) {
            throw new IOException("Cannot reset: no previous calls to mark().");
        }
        this.readIndex = this.markPosition;
        this.bufferIndex = 0;
        this.markPosition = -1;
        this.available = this.markedAvailable;
    }
}

