/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two.warnings;

import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.streamline.protocol.capture.apc.pass_two.warnings.Messages;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;

public class WarningsFactory {
    public static @NonNull WarningItem ftraceDataLost() {
        return new WarningItem(WarningType.CORRUPTION, WarningSeverity.HIGH, Messages.FTRACE_DATA_LOST_TITLE, Messages.FTRACE_DATA_LOST_DESCRIPTION);
    }

    public static @NonNull WarningItem inaccurateOpenCLTimestamps() {
        return new WarningItem(WarningType.OPENCL, WarningSeverity.LOW, Messages.INACCURATE_OPENCL_TIMESTAMPS_TITLE, Messages.INACCURATE_OPENCL_TIMESTAMPS_DESCRIPTION);
    }

    public static @NonNull WarningItem incompletePartialCAMJobReceived() {
        return new WarningItem(WarningType.CAM, WarningSeverity.MEDIUM, Messages.INCOMPLETE_PARTIAL_CAM_JOB_RECEIVED_TITLE, Messages.INCOMPLETE_PARTIAL_CAM_JOB_RECEIVED_DESCRIPTION);
    }

    public static @NonNull WarningItem lostData() {
        return new WarningItem(WarningType.CORRUPTION, WarningSeverity.HIGH, Messages.LOST_DATA_EVENT_TITLE, Messages.LOST_DATA_EVENT_DESCRIPTION);
    }

    public static @NonNull WarningItem missingTracepointFormat(int id) {
        return new WarningItem(WarningType.GATOR_PROTOCOL, WarningSeverity.HIGH, Messages.FTRACE_DATA_LOST_TITLE, MessageFormat.format(Messages.MISSING_FTRACE_TRACEPOINT, id));
    }

    public static @NonNull WarningItem unsupportedExternalProtocol(@NonNull String channelName) {
        return new WarningItem(WarningType.GATOR_PROTOCOL, WarningSeverity.MEDIUM, Messages.UNSUPPORTED_EXTERNAL_PROTOCOL_TITLE, MessageFormat.format(Messages.UNSUPPORTED_EXTERNAL_PROTOCOL_DESCRIPTION, channelName));
    }

    public static @NonNull WarningItem unsupportedGatorOpenCLAnnotation() {
        return new WarningItem(WarningType.ANNOTATE, WarningSeverity.MEDIUM, Messages.UNSUPPORTED_OPENCL_ANNOTATION_TITLE, Messages.UNSUPPORTED_OPENCL_ANNOTATION_DESCRIPTION);
    }

    public static @NonNull WarningItem unsupportedMaliProtocol(int version) {
        return new WarningItem(WarningType.GATOR_PROTOCOL, WarningSeverity.MEDIUM, Messages.UNSUPPORTED_MALI_PROTOCOL_TITLE, MessageFormat.format(Messages.UNSUPPORTED_MALI_PROTOCOL_DESCRIPTION, version));
    }

    public static @NonNull WarningItem unsupportedMaliStreamId() {
        return new WarningItem(WarningType.GATOR_PROTOCOL, WarningSeverity.HIGH, Messages.UNSUPPORTED_MALI_STREAM_ID_TITLE, Messages.UNSUPPORTED_MALI_STREAM_ID_DESCRIPTION);
    }

    public static @NonNull WarningItem unsupportedMaliTiebreak(int tiebreak, int maxSupportedTiebreak) {
        return new WarningItem(WarningType.GATOR_PROTOCOL, WarningSeverity.HIGH, Messages.UNSUPPORTED_MALI_TIEBREAK_TITLE, MessageFormat.format(Messages.UNSUPPORTED_MALI_TIEBREAK_DESCRIPTION, tiebreak, maxSupportedTiebreak));
    }

    public static @NonNull WarningItem unsupportedMaliVideoMessageType(@NonNull String type) {
        return new WarningItem(WarningType.GATOR_PROTOCOL, WarningSeverity.HIGH, Messages.UNSUPPORTED_MALI_VIDEO_MESSAGE_TYPE_TITLE, MessageFormat.format(Messages.UNSUPPORTED_MALI_VIDEO_MESSAGE_TYPE_DESCRIPTION, type));
    }

    public static @NonNull WarningItem unknownMaliTimelineQueue(long id) {
        return new WarningItem(WarningType.CAM, WarningSeverity.LOW, Messages.MALI_TIMELINE_TITLE, MessageFormat.format(Messages.MALI_TIMELINE_UNKNOWN_QUEUE, "0x" + Long.toHexString(id)));
    }

    public static @NonNull WarningItem missingMaliTimelineData() {
        return new WarningItem(WarningType.CAM, WarningSeverity.LOW, Messages.MALI_TIMELINE_TITLE, Messages.MALI_TIMELINE_MISSING);
    }
}

