/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two.event_queue;

import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.model.DynamicCounterSeriesKey;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.KernelAnnotationSeriesKey;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.xml.spe.SpeOperationTypeClass;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoEventStream;
import com.arm.streamline.protocol.misc.TaskId;
import com.arm.streamline.protocol.misc.event_queue.AbstractEventQueueItem;
import com.arm.streamline.protocol.misc.event_queue.IEventQueueSink;
import gnu.trove.map.TByteShortMap;
import gnu.trove.set.TShortSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GatorPassTwoQueueingEventStream
implements IGatorPassTwoEventStream {
    private final @NonNull IEventQueueSink<AbstractEventQueueItem> eventQueue;
    private final @NonNull LongSupplier ordinalSupplier;
    private final @NonNull IGatorPassTwoEventStream stream;

    public GatorPassTwoQueueingEventStream(@NonNull IGatorPassTwoEventStream stream, @NonNull IEventQueueSink<AbstractEventQueueItem> eventQueue, @NonNull LongSupplier ordinalSupplier) {
        this.stream = stream;
        this.eventQueue = eventQueue;
        this.ordinalSupplier = ordinalSupplier;
    }

    @Override
    public void absoluteBacktrace(long timestamp, IBacktraceSource backtraceSource, @NonNull ProcessingElementReference peReference, @NonNull TaskId taskId, long @NonNull [] addresses) throws IOException {
        this.eventQueue.enqueue(new AbsoluteBacktraceEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), backtraceSource, peReference, taskId, addresses));
    }

    @Override
    public void activityStop(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, int activity) throws IOException {
        this.eventQueue.enqueue(new ActivityStopEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), counterKey, peReference, taskId, activity));
    }

    @Override
    public void activitySwitch(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, int activity, int reason) throws IOException {
        this.eventQueue.enqueue(new ActivitySwitchEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), counterKey, peReference, taskId, activity, reason));
    }

    @Override
    public void annotationMarker(long timestamp, @Nullable TaskId taskId, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.eventQueue.enqueue(new AnnotationMarkerEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, colour, text));
    }

    @Override
    public void annotationText(long timestamp, @NonNull TaskId taskId, int channel, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.eventQueue.enqueue(new AnnotationTextEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, channel, colour, text));
    }

    @Override
    public void annotationTextAsync(long timestamp, @NonNull TaskId taskId, @NonNull String title, int id, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.eventQueue.enqueue(new AnnotationTextAsyncEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, title, id, colour, text));
    }

    @Override
    public void annotationTextAsyncEnd(long timestamp, @NonNull TaskId taskId, @NonNull String title, int id) throws IOException {
        this.eventQueue.enqueue(new AnnotationTextAsyncEndEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, title, id));
    }

    @Override
    public void annotationTextNameChannel(long timestamp, @NonNull TaskId taskId, int channel, int group, @NonNull String text) throws IOException {
        this.eventQueue.enqueue(new AnnotationTextNameChannelEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, channel, group, text));
    }

    @Override
    public void annotationTextNameGroup(long timestamp, @NonNull TaskId taskId, int group, @NonNull String text) throws IOException {
        this.eventQueue.enqueue(new AnnotationTextNameGroupEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, group, text));
    }

    @Override
    public void annotationTextPop(long timestamp, @NonNull TaskId taskId, @NonNull String title) throws IOException {
        this.eventQueue.enqueue(new AnnotationTextPopEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, title));
    }

    @Override
    public void annotationTextPush(long timestamp, @NonNull TaskId taskId, @NonNull String title, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.eventQueue.enqueue(new AnnotationTextPushEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, title, colour, text));
    }

    @Override
    public void annotationVisual(long timestamp, @NonNull TaskId taskId, @NonNull String text, byte @NonNull [] image) throws IOException {
        this.eventQueue.enqueue(new AnnotationVisualEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, text, image));
    }

    @Override
    public void atraceCounter(long timestamp, @NonNull String name, @NonNull TaskId taskId, long value) throws IOException {
        this.eventQueue.enqueue(new AtraceCounterEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), name, taskId, value));
    }

    @Override
    public void attributes(long vmUID, Map<@NonNull String, @NonNull String> attributes) throws IOException {
        this.stream.attributes(vmUID, attributes);
    }

    @Override
    public void camJob(int viewUID, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.stream.camJob(viewUID, startTime, duration, track, jobUID, name, colour, primaryDependency, dependencies);
    }

    @Override
    public void camJob(@NonNull TaskId taskId, int viewUID, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.eventQueue.enqueue(new CamJobEventQueueItem(this.eventQueue.clampTimestamp(startTime), this.ordinalSupplier.getAsLong(), taskId, viewUID, duration, track, jobUID, name, colour, primaryDependency, dependencies));
    }

    @Override
    public void camJobDependencies(@NonNull TaskId taskId, int viewUID, long timestamp, int jobUID, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.eventQueue.enqueue(new CamJobDependenciesEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, viewUID, jobUID, primaryDependency, dependencies));
    }

    @Override
    public void camJobStart(@NonNull TaskId taskId, int viewUID, long timestamp, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour) throws IOException {
        this.eventQueue.enqueue(new CamJobStartEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, viewUID, track, jobUID, name, colour));
    }

    @Override
    public void camJobStop(@NonNull TaskId taskId, int viewUID, long timestamp, int jobUID) throws IOException {
        this.eventQueue.enqueue(new CamJobStopEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, viewUID, jobUID));
    }

    @Override
    public void camTrack(int viewUID, int parentTrack, int trackUID, @NonNull String name) throws IOException {
        this.stream.camTrack(viewUID, parentTrack, trackUID, name);
    }

    @Override
    public void camTrack(long timestamp, @NonNull TaskId taskId, int viewUID, int parentTrack, int trackUID, @NonNull String name) throws IOException {
        this.eventQueue.enqueue(new CamTrackEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, viewUID, parentTrack, trackUID, name));
    }

    @Override
    public void camView(int viewUID, @NonNull String name) throws IOException {
        this.stream.camView(viewUID, name);
    }

    @Override
    public void camView(long timestamp, @NonNull TaskId taskId, int viewUID, @NonNull String name) throws IOException {
        this.eventQueue.enqueue(new CamViewEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, viewUID, name));
    }

    @Override
    public void chopExternalFrame(int offset) {
    }

    @Override
    public void chopExternalHeaderFrame(int offset) {
    }

    @Override
    public void counter(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, long value) throws IOException {
        this.eventQueue.enqueue(new CounterEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), counterKey, peReference, taskId, value));
    }

    @Override
    public void createDynamicCounterSeries(@NonNull DynamicCounterSeriesKey counterKey, @NonNull String title, @NonNull String name, @NonNull String units, @NonNull String description, @NonNull CounterClass counterClass, @NonNull CounterDisplay display, @NonNull SeriesComposition seriesComposition, @NonNull GraphRenderingType renderingType, boolean averageSelection, boolean percentage, @NonNull AnnotationColour colour, double multiplier, @NonNull List<@NonNull String> activities, @NonNull List<@NonNull AnnotationColour> activityColors) throws IOException {
        this.stream.createDynamicCounterSeries(counterKey, title, name, units, description, counterClass, display, seriesComposition, renderingType, averageSelection, percentage, colour, multiplier, activities, activityColors);
    }

    @Override
    public void createKernelAnnotationsCounterSeries(@NonNull KernelAnnotationSeriesKey counterKey, @NonNull String title, @NonNull String name, @NonNull String units, @NonNull String description, @NonNull CounterClass counterClass, @NonNull CounterDisplay display, @NonNull SeriesComposition seriesComposition, @NonNull GraphRenderingType renderingType, boolean averageSelection, boolean percentage, @NonNull AnnotationColour colour, double multiplier, @NonNull List<@NonNull String> activities, @NonNull List<@NonNull AnnotationColour> activityColors) throws IOException {
        this.stream.createKernelAnnotationsCounterSeries(counterKey, title, name, units, description, counterClass, display, seriesComposition, renderingType, averageSelection, percentage, colour, multiplier, activities, activityColors);
    }

    @Override
    public void idle(long timestamp, @NonNull ProcessingElementReference peReference, boolean online) throws IOException {
        this.eventQueue.enqueue(new IdleEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), peReference, online));
    }

    @Override
    public void schedSwitch(long timestamp, @NonNull ProcessingElementReference peReference, @NonNull TaskId nextTaskId,  @NonNull IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason reason) throws IOException {
        this.eventQueue.enqueue(new SchedSwitchEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), peReference, nextTaskId, reason));
    }

    @Override
    public void speSample(int key, long timestamp, @NonNull ProcessingElementReference peReference, @NonNull TaskId taskId, long pc, @Nullable SpeOperationTypeClass opTypeClass, byte opTypeSubclass, long events, @NonNull TShortSet dataSources, @NonNull TByteShortMap counterMap) throws IOException {
        this.eventQueue.enqueue(new SpeSampleEventQueueItem(key, this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), peReference, taskId, pc, opTypeClass, opTypeSubclass, events, dataSources, counterMap));
    }

    @Override
    public void threadExec(long timestamp, @Nullable TaskId oldTaskId, @NonNull TaskId taskId, int cookieUID) throws IOException {
        this.eventQueue.enqueue(new ThreadExecEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), oldTaskId, taskId, cookieUID));
    }

    @Override
    public void threadExit(long timestamp, @NonNull TaskId taskId) throws IOException {
        this.eventQueue.enqueue(new ThreadExitEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId));
    }

    @Override
    public void threadFork(long timestamp, @Nullable TaskId parentTaskId, @NonNull TaskId taskId) throws IOException {
        this.eventQueue.enqueue(new ThreadForkEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), parentTaskId, taskId));
    }

    @Override
    public void threadLinkCookie(long timestamp, @NonNull TaskId taskId, int cookieUID) throws IOException {
        this.eventQueue.enqueue(new ThreadLinkCookieEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, cookieUID));
    }

    @Override
    public void threadMaps(long timestamp, @NonNull TaskId taskId, @NonNull String maps) throws IOException {
        this.eventQueue.enqueue(new ThreadMapsEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, maps));
    }

    @Override
    public void threadMMap(long timestamp, @NonNull TaskId taskId, long fileOffset, long mapAddress, long length, @NonNull String filename) throws IOException {
        this.eventQueue.enqueue(new ThreadMMapEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, fileOffset, mapAddress, length, filename));
    }

    @Override
    public void threadProperties(long timestamp, @Nullable TaskId parentTaskId, @NonNull TaskId taskId, @NonNull String name, @NonNull String exePath, @Nullable String linuxProcMapsContents) throws IOException {
        this.eventQueue.enqueue(new ThreadPropertiesEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), parentTaskId, taskId, name, exePath, linuxProcMapsContents));
    }

    @Override
    public void threadRename(long timestamp, @NonNull TaskId taskId, @NonNull String name, boolean exec) throws IOException {
        this.eventQueue.enqueue(new ThreadRenameEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, name, exec));
    }

    @Override
    public void tracepointEvent(long timestamp, @Nullable TaskId taskId, @NonNull TracepointFormat tracepointFormat, byte @NonNull [] raw) throws IOException {
        this.eventQueue.enqueue(new TracepointEventEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, tracepointFormat, raw));
    }

    @Override
    public void warning(long timestamp, TaskId taskId, @NonNull WarningItem warning) throws IOException {
        this.eventQueue.enqueue(new WarningMarkerEventQueueItem(this.eventQueue.clampTimestamp(timestamp), this.ordinalSupplier.getAsLong(), taskId, warning));
    }

    @Override
    public void warning(@NonNull WarningItem warning) throws IOException {
        this.stream.warning(warning);
    }

    public static final class AbsoluteBacktraceEventQueueItem
    extends AbstractEventQueueItem {
        protected final long @NonNull [] addresses;
        protected final @NonNull IBacktraceSource backtraceSource;
        protected final @NonNull ProcessingElementReference peReference;
        protected final @Nullable Integer pid;
        protected final int tid;

        public AbsoluteBacktraceEventQueueItem(long timestamp, long ordinal, @NonNull IBacktraceSource backtraceSource, @NonNull ProcessingElementReference peReference, @NonNull TaskId taskId, long @NonNull [] addresses) {
            super(timestamp, ordinal);
            this.backtraceSource = backtraceSource;
            this.peReference = peReference;
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.addresses = addresses;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.absoluteBacktrace(this.timestamp, this.backtraceSource, this.peReference, new TaskId(this.pid, this.tid), this.addresses);
        }
    }

    public static final class ActivityStopEventQueueItem
    extends AbstractEventQueueItem {
        protected final int activity;
        protected final @NonNull ICounterSeriesKey counterKey;
        protected final @NonNull ProcessingElementReference peReference;
        protected final @Nullable TaskId taskId;

        public ActivityStopEventQueueItem(long timestamp, long ordinal, @NonNull ICounterSeriesKey counterKey, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, int activity) {
            super(timestamp, ordinal);
            this.counterKey = counterKey;
            this.peReference = peReference;
            this.taskId = taskId;
            this.activity = activity;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.activityStop(this.counterKey, this.timestamp, this.peReference, this.taskId, this.activity);
        }
    }

    public static final class ActivitySwitchEventQueueItem
    extends AbstractEventQueueItem {
        protected final int activity;
        protected final @NonNull ICounterSeriesKey counterKey;
        protected final @NonNull ProcessingElementReference peReference;
        protected final int reason;
        protected final @Nullable TaskId taskId;

        public ActivitySwitchEventQueueItem(long timestamp, long ordinal, @NonNull ICounterSeriesKey counterKey, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, int activity, int reason) {
            super(timestamp, ordinal);
            this.counterKey = counterKey;
            this.peReference = peReference;
            this.taskId = taskId;
            this.activity = activity;
            this.reason = reason;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.activitySwitch(this.counterKey, this.timestamp, this.peReference, this.taskId, this.activity, this.reason);
        }
    }

    public static class AnnotationMarkerEventQueueItem
    extends AbstractEventQueueItem {
        protected final int colour;
        protected final @Nullable TaskId taskId;
        protected final @NonNull String text;

        public AnnotationMarkerEventQueueItem(long timestamp, long ordinal, @Nullable TaskId taskId, @NonNull AnnotationColour colour, @NonNull String text) {
            super(timestamp, ordinal);
            this.taskId = taskId;
            this.colour = colour.toInt();
            this.text = text;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.annotationMarker(this.timestamp, this.taskId, new AnnotationColour(this.colour), this.text);
        }
    }

    public static class AnnotationTextAsyncEndEventQueueItem
    extends AbstractEventQueueItem {
        protected final int id;
        protected final @Nullable Integer pid;
        protected final int tid;
        protected final @NonNull String title;

        public AnnotationTextAsyncEndEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, @NonNull String title, int id) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.title = title;
            this.id = id;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.annotationTextAsyncEnd(this.timestamp, new TaskId(this.pid, this.tid), this.title, this.id);
        }
    }

    public static class AnnotationTextAsyncEventQueueItem
    extends AbstractEventQueueItem {
        protected final int colour;
        protected final int id;
        protected final @Nullable Integer pid;
        protected final @NonNull String text;
        protected final int tid;
        protected final @NonNull String title;

        public AnnotationTextAsyncEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, @NonNull String title, int id, @NonNull AnnotationColour colour, @NonNull String text) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.colour = colour.toInt();
            this.title = title;
            this.id = id;
            this.text = text;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.annotationTextAsync(this.timestamp, new TaskId(this.pid, this.tid), this.title, this.id, new AnnotationColour(this.colour), this.text);
        }
    }

    public static class AnnotationTextEventQueueItem
    extends AbstractEventQueueItem {
        protected final int channel;
        protected final int colour;
        protected final @Nullable Integer pid;
        protected final @NonNull String text;
        protected final int tid;

        public AnnotationTextEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, int channel, @NonNull AnnotationColour colour, @NonNull String text) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.colour = colour.toInt();
            this.channel = channel;
            this.text = text;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.annotationText(this.timestamp, new TaskId(this.pid, this.tid), this.channel, new AnnotationColour(this.colour), this.text);
        }
    }

    public static class AnnotationTextNameChannelEventQueueItem
    extends AbstractEventQueueItem {
        protected final int channel;
        protected final int group;
        protected final @Nullable Integer pid;
        protected final @NonNull String text;
        protected final int tid;

        public AnnotationTextNameChannelEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, int channel, int group, @NonNull String text) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.channel = channel;
            this.group = group;
            this.text = text;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.annotationTextNameChannel(this.timestamp, new TaskId(this.pid, this.tid), this.channel, this.group, this.text);
        }
    }

    public static class AnnotationTextNameGroupEventQueueItem
    extends AbstractEventQueueItem {
        protected final int group;
        protected final @Nullable Integer pid;
        protected final @NonNull String text;
        protected final int tid;

        public AnnotationTextNameGroupEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, int group, @NonNull String text) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.group = group;
            this.text = text;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.annotationTextNameGroup(this.timestamp, new TaskId(this.pid, this.tid), this.group, this.text);
        }
    }

    public static class AnnotationTextPopEventQueueItem
    extends AbstractEventQueueItem {
        protected final @Nullable Integer pid;
        protected final int tid;
        protected final @NonNull String title;

        public AnnotationTextPopEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, @NonNull String title) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.title = title;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.annotationTextPop(this.timestamp, new TaskId(this.pid, this.tid), this.title);
        }
    }

    public static class AnnotationTextPushEventQueueItem
    extends AbstractEventQueueItem {
        protected final int colour;
        protected final @Nullable Integer pid;
        protected final @NonNull String text;
        protected final int tid;
        protected final @NonNull String title;

        public AnnotationTextPushEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, @NonNull String title, @NonNull AnnotationColour colour, @NonNull String text) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.colour = colour.toInt();
            this.title = title;
            this.text = text;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.annotationTextPush(this.timestamp, new TaskId(this.pid, this.tid), this.title, new AnnotationColour(this.colour), this.text);
        }
    }

    public static class AnnotationVisualEventQueueItem
    extends AbstractEventQueueItem {
        protected final byte @NonNull [] image;
        protected final @Nullable Integer pid;
        protected final @NonNull String text;
        protected final int tid;

        public AnnotationVisualEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, @NonNull String text, byte @NonNull [] image) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.image = image;
            this.text = text;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.annotationVisual(this.timestamp, new TaskId(this.pid, this.tid), this.text, this.image);
        }
    }

    public static final class AtraceCounterEventQueueItem
    extends AbstractEventQueueItem {
        protected final @NonNull String name;
        protected final @Nullable Integer pid;
        protected final int tid;
        protected final long value;

        public AtraceCounterEventQueueItem(long timestamp, long ordinal, @NonNull String name, @NonNull TaskId taskId, long value) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.name = name;
            this.value = value;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.atraceCounter(this.timestamp, this.name, new TaskId(this.pid, this.tid), this.value);
        }
    }

    public static class CamJobDependenciesEventQueueItem
    extends AbstractEventQueueItem {
        protected final int @NonNull [] dependencies;
        protected final int jobUID;
        protected final @Nullable Integer pid;
        protected final int primaryDependency;
        protected final int tid;
        protected final int viewUID;

        public CamJobDependenciesEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, int viewUID, int jobUID, int primaryDependency, int @NonNull [] dependencies) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.viewUID = viewUID;
            this.jobUID = jobUID;
            this.primaryDependency = primaryDependency;
            this.dependencies = dependencies;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.camJobDependencies(new TaskId(this.pid, this.tid), this.viewUID, this.timestamp, this.jobUID, this.primaryDependency, this.dependencies);
        }
    }

    public static class CamJobEventQueueItem
    extends AbstractEventQueueItem {
        protected final int colour;
        protected final int @NonNull [] dependencies;
        protected final long duration;
        protected final int jobUID;
        protected final @NonNull String name;
        protected final @Nullable Integer pid;
        protected final int primaryDependency;
        protected final int tid;
        protected final int track;
        protected final int viewUID;

        public CamJobEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, int viewUID, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.colour = colour.toInt();
            this.viewUID = viewUID;
            this.duration = duration;
            this.track = track;
            this.jobUID = jobUID;
            this.name = name;
            this.primaryDependency = primaryDependency;
            this.dependencies = dependencies;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.camJob(new TaskId(this.pid, this.tid), this.viewUID, this.timestamp, this.duration, this.track, this.jobUID, this.name, new AnnotationColour(this.colour), this.primaryDependency, this.dependencies);
        }
    }

    public static class CamJobStartEventQueueItem
    extends AbstractEventQueueItem {
        protected final int colour;
        protected final int jobUID;
        protected final @NonNull String name;
        protected final @Nullable Integer pid;
        protected final int tid;
        protected final int track;
        protected final int viewUID;

        public CamJobStartEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, int viewUID, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.colour = colour.toInt();
            this.viewUID = viewUID;
            this.track = track;
            this.jobUID = jobUID;
            this.name = name;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.camJobStart(new TaskId(this.pid, this.tid), this.viewUID, this.timestamp, this.track, this.jobUID, this.name, new AnnotationColour(this.colour));
        }
    }

    public static class CamJobStopEventQueueItem
    extends AbstractEventQueueItem {
        protected final int jobUID;
        protected final @Nullable Integer pid;
        protected final int tid;
        protected final int viewUID;

        public CamJobStopEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, int viewUID, int jobUID) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.viewUID = viewUID;
            this.jobUID = jobUID;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.camJobStop(new TaskId(this.pid, this.tid), this.viewUID, this.timestamp, this.jobUID);
        }
    }

    public static class CamTrackEventQueueItem
    extends AbstractEventQueueItem {
        protected final @NonNull String name;
        protected final int parentTrack;
        protected final @Nullable Integer pid;
        protected final int tid;
        protected final int trackUID;
        protected final int viewUID;

        public CamTrackEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, int viewUID, int parentTrack, int trackUID, @NonNull String name) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.viewUID = viewUID;
            this.parentTrack = parentTrack;
            this.trackUID = trackUID;
            this.name = name;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.camTrack(this.timestamp, new TaskId(this.pid, this.tid), this.viewUID, this.parentTrack, this.trackUID, this.name);
        }
    }

    public static class CamViewEventQueueItem
    extends AbstractEventQueueItem {
        protected final @NonNull String name;
        protected final @Nullable Integer pid;
        protected final int tid;
        protected final int viewUID;

        public CamViewEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, int viewUID, @NonNull String name) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.viewUID = viewUID;
            this.name = name;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.camView(this.timestamp, new TaskId(this.pid, this.tid), this.viewUID, this.name);
        }
    }

    public static final class CounterEventQueueItem
    extends AbstractEventQueueItem {
        protected final @NonNull ICounterSeriesKey counterKey;
        protected final @NonNull ProcessingElementReference peReference;
        protected final @Nullable TaskId taskId;
        protected final long value;

        public CounterEventQueueItem(long timestamp, long ordinal, @NonNull ICounterSeriesKey counterKey, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, long value) {
            super(timestamp, ordinal);
            this.counterKey = counterKey;
            this.peReference = peReference;
            this.taskId = taskId;
            this.value = value;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.counter(this.counterKey, this.timestamp, this.peReference, this.taskId, this.value);
        }
    }

    public static final class IdleEventQueueItem
    extends AbstractEventQueueItem {
        protected final boolean online;
        protected final @NonNull ProcessingElementReference peReference;

        public IdleEventQueueItem(long timestamp, long ordinal, @NonNull ProcessingElementReference peReference, boolean online) {
            super(timestamp, ordinal);
            this.peReference = peReference;
            this.online = online;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.idle(this.timestamp, this.peReference, this.online);
        }
    }

    public static final class SchedSwitchEventQueueItem
    extends AbstractEventQueueItem {
        protected final @NonNull ProcessingElementReference peReference;
        protected final @Nullable Integer pid;
        protected final  @NonNull IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason reason;
        protected final int tid;

        public SchedSwitchEventQueueItem(long timestamp, long ordinal, @NonNull ProcessingElementReference peReference, @NonNull TaskId nextTaskId,  @NonNull IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason reason) {
            super(timestamp, ordinal);
            this.peReference = peReference;
            this.pid = nextTaskId.pid;
            this.tid = nextTaskId.tid;
            this.reason = reason;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.schedSwitch(this.timestamp, this.peReference, new TaskId(this.pid, this.tid), this.reason);
        }
    }

    public static final class SpeSampleEventQueueItem
    extends AbstractEventQueueItem {
        protected final @NonNull TByteShortMap counterMap;
        protected final @NonNull TShortSet dataSources;
        protected final long events;
        protected final int key;
        protected final @Nullable SpeOperationTypeClass opTypeClass;
        protected final byte opTypeSubclass;
        protected final long pc;
        protected final @NonNull ProcessingElementReference peReference;
        protected final @NonNull TaskId taskId;

        public SpeSampleEventQueueItem(int key, long timestamp, long ordinal, @NonNull ProcessingElementReference peReference, @NonNull TaskId taskId, long pc, @Nullable SpeOperationTypeClass opTypeClass, byte opTypeSubclass, long events, @NonNull TShortSet dataSources, @NonNull TByteShortMap counterMap) {
            super(timestamp, ordinal);
            this.peReference = peReference;
            this.taskId = taskId;
            this.pc = pc;
            this.opTypeClass = opTypeClass;
            this.opTypeSubclass = opTypeSubclass;
            this.events = events;
            this.dataSources = dataSources;
            this.counterMap = counterMap;
            this.key = key;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.speSample(this.key, this.timestamp, this.peReference, this.taskId, this.pc, this.opTypeClass, this.opTypeSubclass, this.events, this.dataSources, this.counterMap);
        }
    }

    public static final class ThreadExecEventQueueItem
    extends AbstractEventQueueItem {
        protected final int cookieUID;
        protected final @Nullable TaskId oldTaskId;
        protected final @Nullable Integer pid;
        protected final int tid;

        public ThreadExecEventQueueItem(long timestamp, long ordinal, @Nullable TaskId oldTaskId, @NonNull TaskId taskId, int cookieUID) {
            super(timestamp, ordinal);
            this.oldTaskId = oldTaskId;
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.cookieUID = cookieUID;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.threadExec(this.timestamp, this.oldTaskId, new TaskId(this.pid, this.tid), this.cookieUID);
        }
    }

    public static final class ThreadExitEventQueueItem
    extends AbstractEventQueueItem {
        protected final @Nullable Integer pid;
        protected final int tid;

        public ThreadExitEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.threadExit(this.timestamp, new TaskId(this.pid, this.tid));
        }
    }

    public static final class ThreadForkEventQueueItem
    extends AbstractEventQueueItem {
        protected final @Nullable TaskId parentTaskId;
        protected final @Nullable Integer pid;
        protected final int tid;

        public ThreadForkEventQueueItem(long timestamp, long ordinal, @Nullable TaskId parentTaskId, @NonNull TaskId taskId) {
            super(timestamp, ordinal);
            this.parentTaskId = parentTaskId;
            this.pid = taskId.pid;
            this.tid = taskId.tid;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.threadFork(this.timestamp, this.parentTaskId, new TaskId(this.pid, this.tid));
        }
    }

    public static final class ThreadLinkCookieEventQueueItem
    extends AbstractEventQueueItem {
        protected final int cookieUID;
        protected final @Nullable Integer pid;
        protected final int tid;

        public ThreadLinkCookieEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, int cookieUID) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.cookieUID = cookieUID;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.threadLinkCookie(this.timestamp, new TaskId(this.pid, this.tid), this.cookieUID);
        }
    }

    public static final class ThreadMMapEventQueueItem
    extends AbstractEventQueueItem {
        protected final @NonNull String filename;
        protected final long fileOffset;
        protected final long length;
        protected final long mapAddress;
        protected final @Nullable Integer pid;
        protected final int tid;

        public ThreadMMapEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, long fileOffset, long mapAddress, long length, @NonNull String filename) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.fileOffset = fileOffset;
            this.mapAddress = mapAddress;
            this.length = length;
            this.filename = filename;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.threadMMap(this.timestamp, new TaskId(this.pid, this.tid), this.fileOffset, this.mapAddress, this.length, this.filename);
        }
    }

    public static final class ThreadMapsEventQueueItem
    extends AbstractEventQueueItem {
        protected final @NonNull String maps;
        protected final @Nullable Integer pid;
        protected final int tid;

        public ThreadMapsEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, @NonNull String maps) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.maps = maps;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.threadMaps(this.timestamp, new TaskId(this.pid, this.tid), this.maps);
        }
    }

    public static final class ThreadPropertiesEventQueueItem
    extends AbstractEventQueueItem {
        protected final @NonNull String exePath;
        protected final @Nullable String linuxProcMapsContents;
        protected final @NonNull String name;
        protected final @Nullable TaskId parentTaskId;
        protected final @Nullable Integer pid;
        protected final int tid;

        public ThreadPropertiesEventQueueItem(long timestamp, long ordinal, @Nullable TaskId parentTaskId, @NonNull TaskId taskId, @NonNull String name, @NonNull String exePath, @Nullable String linuxProcMapsContents) {
            super(timestamp, ordinal);
            this.parentTaskId = parentTaskId;
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.name = name;
            this.exePath = exePath;
            this.linuxProcMapsContents = linuxProcMapsContents;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.threadProperties(this.timestamp, this.parentTaskId, new TaskId(this.pid, this.tid), this.name, this.exePath, this.linuxProcMapsContents);
        }
    }

    public static final class ThreadRenameEventQueueItem
    extends AbstractEventQueueItem {
        protected final boolean exec;
        protected final @NonNull String name;
        protected final @Nullable Integer pid;
        protected final int tid;

        public ThreadRenameEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, @NonNull String name, boolean exec) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.name = name;
            this.exec = exec;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.threadRename(this.timestamp, new TaskId(this.pid, this.tid), this.name, this.exec);
        }
    }

    public static final class TracepointEventEventQueueItem
    extends AbstractEventQueueItem {
        protected final byte @NonNull [] raw;
        protected final @Nullable TaskId taskId;
        protected final @NonNull TracepointFormat tracepointFormat;

        public TracepointEventEventQueueItem(long timestamp, long ordinal, @Nullable TaskId taskId, @NonNull TracepointFormat tracepointFormat, byte @NonNull [] raw) {
            super(timestamp, ordinal);
            this.taskId = taskId;
            this.tracepointFormat = tracepointFormat;
            this.raw = raw;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.tracepointEvent(this.timestamp, this.taskId, this.tracepointFormat, this.raw);
        }
    }

    public static final class WarningMarkerEventQueueItem
    extends AbstractEventQueueItem {
        protected final @Nullable Integer pid;
        protected final int tid;
        protected final @NonNull WarningItem warning;

        public WarningMarkerEventQueueItem(long timestamp, long ordinal, @NonNull TaskId taskId, @NonNull WarningItem warning) {
            super(timestamp, ordinal);
            this.pid = taskId.pid;
            this.tid = taskId.tid;
            this.warning = warning;
        }

        @Override
        public void flushToOutputStream(@NonNull IGatorPassTwoEventStream stream) throws IOException {
            stream.warning(this.timestamp, new TaskId(this.pid, this.tid), this.warning);
        }
    }
}

