/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two;

import com.arm.streamline.analysis.database.api.profiling.BacktraceSource;
import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.perf.records.EventAndPmuNames;
import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.perf.records.EventHeader;
import com.arm.streamline.perf.records.ReadFormat;
import com.arm.streamline.perf.records.RecordBlob;
import com.arm.streamline.perf.records.RegisterValues;
import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoEventStream;
import com.arm.streamline.protocol.capture.apc.pass_two.IKernelTracepointProcessor;
import com.arm.streamline.protocol.capture.apc.pass_two.IMaliUserspaceSoftwareCounters;
import com.arm.streamline.protocol.capture.apc.pass_two.warnings.WarningsFactory;
import com.arm.streamline.protocol.capture.apc.protocol.IGatorPerVirtualMachineProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.external.FTraceCommon;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfAuxDataBufferReader;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfDataBufferEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfProtocolState;
import com.arm.streamline.protocol.capture.apc.protocol.perf.PerfDataBufferPassProcessor;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.capture.apc.time.ITimestampMapper;
import com.arm.streamline.protocol.misc.TaskId;
import com.arm.streamline.spe.decoders.ISpeRecord;
import com.arm.streamline.spe.decoders.SpeDecodeException;
import com.arm.utils.ArrayUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingConsumer;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongLongMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongLongHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class PerfDataBufferPassTwoEventConsumer
implements IPerfDataBufferEventConsumer<APCFrameAddress> {
    protected static final long TASK_RUNNING = 0L;
    protected static final @NonNull String TRACEPOINT_FIELD__CPU_FREQUENCY__CPU_ID = "cpu_id";
    protected static final @NonNull String TRACEPOINT_FIELD__CPU_FREQUENCY__STATE = "state";
    protected static final @NonNull String TRACEPOINT_FIELD__SCHED_SWITCH__NEXT_PID = "next_pid";
    protected static final @NonNull String TRACEPOINT_FIELD__SCHED_SWITCH__PREV_PID = "prev_pid";
    protected static final @NonNull String TRACEPOINT_FIELD__SCHED_SWITCH__PREV_STATE = "prev_state";
    protected static final @NonNull String TRACEPOINT_NAME__CPU_FREQUENCY = "cpu_frequency";
    protected static final @NonNull String TRACEPOINT_NAME__CPU_IDLE = "cpu_idle";
    protected static final @NonNull String TRACEPOINT_NAME__SCHED_SWITCH = "sched_switch";
    private static final String SPE_AUX_DATA_MISSING_CHANNEL_TEXT = "Aux data missing";
    private static final String SPE_AUX_DATA_MISSING_CHANNEL_TITLE = "Statistical Profiling\nMissing Data";
    private static final String SPE_AUX_DATA_MISSING_DATA_LOSS_MARKER = "SPE Aux data missing.\n\nSampling rate may be too high, data buffer too small, or capture output too slow.";
    private static final String SPE_COLLISION_MARKER = "SPE collision event.\n\nSampling rate may be too high.";
    private final @NonNull FTraceCommon commonFtraceProcessing;
    private final boolean allowArbitraryEbsBacktraceSources;
    private final boolean allowSchedSwitchTracepoints;
    private final @NonNull TIntObjectMap<TLongObjectMap<TaskId>> auxTraceTaskTrace = new TIntObjectHashMap(10, 0.5f, -1);
    private final @NonNull Map<@NonNull EventAndPmuNames.TypeAndConfig, @NonNull IBacktraceSource> backtraceSources = new HashMap<EventAndPmuNames.TypeAndConfig, IBacktraceSource>();
    private final @NonNull IntFunction<@Nullable ICounterSeriesKey> counterSeriesKeyMapper;
    private final @NonNull TLongLongMap counterValueTracker;
    private final @NonNull IntFunction<@Nullable ICounterSeriesKey> cpuFrequencyTracepointKeyProvider;
    private final @NonNull TIntSet cpuNumbersForWhichInitialSwitchWasSent = new TIntHashSet(10, 0.5f, -1);
    private final boolean ignoreAux;
    private final @NonNull IntPredicate isSpeKey;
    private final @NonNull IMaliUserspaceSoftwareCounters maliUserspaceSoftwareCounters;
    private final @NonNull IKernelTracepointProcessor kernelTracepointProcessor;
    private final @NonNull IGatorPassTwoEventStream output;
    private final @NonNull IPerfProtocolState perfAttributesState;
    private final @NonNull ProcessingElementReferenceSet processingElements;
    private final @NonNull ISpeDecoder speDecoder;
    private final @NonNull TIntObjectMap<TIntSet> speLostDataMarkers = new TIntObjectHashMap(10, 0.5f, -1);
    private final @NonNull TIntObjectMap<TaskId> switchOutNextTaskIdScheduler = new TIntObjectHashMap();
    private final @NonNull TIntObjectMap<TaskId> switchOutNextTaskIdSpe = new TIntObjectHashMap();
    private final @NonNull ITimestampMapper timestampMapper;
    private final @NonNull Function<@NonNull String, @Nullable ICounterSeriesKey> tracepointCounterMapper;
    private final long vmUID;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$arm$streamline$protocol$capture$apc$pass_two$PerfDataBufferPassTwoEventConsumer$GenerateFakeContextSwitchResult;

    public static @NonNull GenerateFakeContextSwitchResult shouldGenerateFakeContextSwitch(@NonNull IPerfProtocolState perfAttributesState, @Nullable EventAttribute attribute) {
        if (!perfAttributesState.isSupportsSchedulerTrace() && attribute != null) {
            if (attribute.getType() == 1 && attribute.getConfig() == 3L && !attribute.isFlagSet(EventAttribute.Flags.FREQ) && attribute.getSampleFreqOrPeriod() == 1L) {
                return GenerateFakeContextSwitchResult.GENERATE_EXIT;
            }
            return GenerateFakeContextSwitchResult.GENERATE_ENTRY;
        }
        return GenerateFakeContextSwitchResult.DO_NOT_GENERATE;
    }

    protected static long @Nullable [] cleanupCallChain(long @Nullable [] callchain, @Nullable Long ip, @NonNull RecordBlob.IRecordBlobVisitor.Abi registersAbi, long registersLr, long registersPc) {
        if (callchain != null) {
            TLongArrayList addresses = new TLongArrayList(callchain.length + 1);
            long[] lArray = callchain;
            int n = callchain.length;
            int n2 = 0;
            while (n2 < n) {
                long element = lArray[n2];
                if (element != 0L && Long.compareUnsigned(element, -4095L) <= 0) {
                    addresses.add(element);
                }
                ++n2;
            }
            if (!addresses.isEmpty()) {
                long lrToInsert;
                boolean lrIsInsertedAlready = addresses.size() > 1 && addresses.get(1) == registersLr;
                long l = lrToInsert = addresses.get(0) == registersPc && registersAbi != RecordBlob.IRecordBlobVisitor.Abi.NONE && !lrIsInsertedAlready ? registersLr : 0L;
                if (lrToInsert != 0L || addresses.size() > 1) {
                    addresses.insert(1, lrToInsert);
                }
                return addresses.toArray();
            }
        }
        if (ip != null && ip != 0L) {
            return new long[]{ip};
        }
        return null;
    }

    protected static @NonNull TaskId mapSwitchTaskId(boolean out, @NonNull TaskId taskId) {
        int tidToUse = out ? 0 : (taskId.tid != 0 ? taskId.tid : taskId.getPidOrTid());
        @Nullable Integer pidToUse = out ? null : taskId.pid;
        return new TaskId(pidToUse, tidToUse);
    }

    private static long @Nullable [] extractAbiRegisters(boolean registersHostIs64bit, @NonNull RecordBlob.IRecordBlobVisitor.Abi registersAbi, @Nullable RegisterValues registers) {
        if (registers == null) {
            return null;
        }
        switch (registersAbi) {
            case ABI_32: {
                return PerfDataBufferPassTwoEventConsumer.extractRegisters32(registers, registersHostIs64bit);
            }
            case ABI_64: {
                assert (registersHostIs64bit);
                return PerfDataBufferPassTwoEventConsumer.extractRegisters64(registers);
            }
            case NONE: {
                if (registersHostIs64bit) {
                    return PerfDataBufferPassTwoEventConsumer.extractRegisters64(registers);
                }
                return PerfDataBufferPassTwoEventConsumer.extractRegisters32(registers, false);
            }
        }
        throw new AssertionError((Object)registersAbi);
    }

    private static long @Nullable [] extractRegisters32(@NonNull RegisterValues registers, boolean registersHostIs64bit) {
        int posLr32 = ArrayUtils.indexOf((int[])registers.registerNumbers, (int)14);
        int posPc32 = ArrayUtils.indexOf((int[])registers.registerNumbers, (int)15);
        if (registersHostIs64bit) {
            int posLr64 = ArrayUtils.indexOf((int[])registers.registerNumbers, (int)30);
            int posPc64 = ArrayUtils.indexOf((int[])registers.registerNumbers, (int)32);
            if (posLr64 >= 0 && posPc64 >= 0) {
                long lr = registers.registerValues[posLr64];
                long pc = registers.registerValues[posPc64];
                if (lr != 0L && pc != 0L) {
                    assert (posLr32 >= 0 && posPc32 >= 0);
                    assert (registers.registerValues[posLr32] == registers.registerValues[posLr64]);
                    assert (registers.registerValues[posPc32] == 0L || registers.registerValues[posPc32] == registers.registerValues[posPc64]);
                    return new long[]{lr, pc};
                }
            }
        }
        if (posLr32 >= 0 && posPc32 >= 0) {
            long lr = registers.registerValues[posLr32];
            long pc = registers.registerValues[posPc32];
            if (lr != 0L && pc != 0L) {
                return new long[]{lr, pc};
            }
        }
        return null;
    }

    private static long @Nullable [] extractRegisters64(@NonNull RegisterValues registers) {
        int posLr = ArrayUtils.indexOf((int[])registers.registerNumbers, (int)30);
        int posPc = ArrayUtils.indexOf((int[])registers.registerNumbers, (int)32);
        if (posLr >= 0 && posPc >= 0) {
            long lr = registers.registerValues[posLr];
            long pc = registers.registerValues[posPc];
            if (lr != 0L && pc != 0L) {
                return new long[]{lr, pc};
            }
        }
        return null;
    }

    private static void swtchCpuWide_common(int deviceNumber, @Nullable TaskId sampleTaskId, boolean out, @NonNull TaskId prevNextTaskId, @NonNull TIntObjectMap<TaskId> switchOutNextTaskId, @NonNull IThrowingConsumer<@NonNull TaskId, IOException> mappedTaskIdConsumer) throws IOException {
        TaskId mappedTaskId;
        if (out) {
            switchOutNextTaskId.put(deviceNumber, (Object)prevNextTaskId);
            mappedTaskId = new TaskId(null, 0);
        } else {
            TaskId lastSwitchOutsNextTaskId = (TaskId)switchOutNextTaskId.get(deviceNumber);
            if (sampleTaskId != null) {
                assert (lastSwitchOutsNextTaskId == null || lastSwitchOutsNextTaskId.tid == sampleTaskId.tid);
                mappedTaskId = sampleTaskId;
            } else if (lastSwitchOutsNextTaskId != null) {
                mappedTaskId = lastSwitchOutsNextTaskId;
            } else {
                assert (false);
                mappedTaskId = new TaskId(null, 0);
            }
        }
        mappedTaskIdConsumer.accept((Object)mappedTaskId);
    }

    public PerfDataBufferPassTwoEventConsumer(long vmUID, boolean appTracingMode, @NonNull IPerfProtocolState perfAttributesState, @NonNull ITimestampMapper timestampMapper, @NonNull ProcessingElementReferenceSet processingElements, @NonNull IntFunction<@Nullable ICounterSeriesKey> counterSeriesKeyMapper, @NonNull IntFunction<@Nullable ICounterSeriesKey> cpuFrequencyTracepointKeyProvider, @NonNull Function<@NonNull String, @Nullable ICounterSeriesKey> tracepointCounterMapper, @NonNull IMaliUserspaceSoftwareCounters maliUserspaceSoftwareCounters, @NonNull IKernelTracepointProcessor kernelTracepointProcessor, @NonNull IntPredicate isSpeKey, @NonNull ISpeDecoder speDecoder, boolean ignoreAux, boolean allowArbitraryEbsBacktraceSources, @NonNull IGatorPassTwoEventStream output) {
        this.vmUID = vmUID;
        this.timestampMapper = timestampMapper;
        this.perfAttributesState = perfAttributesState;
        this.processingElements = processingElements;
        this.counterSeriesKeyMapper = counterSeriesKeyMapper;
        this.cpuFrequencyTracepointKeyProvider = cpuFrequencyTracepointKeyProvider;
        this.tracepointCounterMapper = tracepointCounterMapper;
        this.maliUserspaceSoftwareCounters = maliUserspaceSoftwareCounters;
        this.kernelTracepointProcessor = kernelTracepointProcessor;
        this.ignoreAux = ignoreAux;
        this.allowArbitraryEbsBacktraceSources = allowArbitraryEbsBacktraceSources;
        this.isSpeKey = isSpeKey;
        this.speDecoder = speDecoder;
        this.output = output;
        this.commonFtraceProcessing = new FTraceCommon(vmUID, processingElements, output);
        this.allowSchedSwitchTracepoints = !appTracingMode || !perfAttributesState.hasContextSwitchEvents();
        this.counterValueTracker = new TLongLongHashMap(10, 0.5f, 0L, 0L);
    }

    @Override
    public void aux(@NonNull APCFrameAddress userData, @NonNull ClockSource clockSource, long timestamp, final int deviceNumber, @Nullable Long attributeId, @Nullable TaskId taskId, long offset, long size, long flags) throws IOException {
        boolean isMarkedDataLost;
        if (this.ignoreAux) {
            return;
        }
        Integer possibleKey = this.perfAttributesState.getKeyByAttributeId(attributeId);
        if (possibleKey == null) {
            throw new IOException("No attribute received for id: " + String.valueOf(attributeId));
        }
        final int key = possibleKey;
        if (!this.isSpeKey.test(key)) {
            return;
        }
        final TLongObjectMap contextSwitchTimestampToIncomingTaskId = (TLongObjectMap)this.auxTraceTaskTrace.get(deviceNumber);
        if (contextSwitchTimestampToIncomingTaskId == null || contextSwitchTimestampToIncomingTaskId.isEmpty()) {
            throw new IOException("PERF_RECORD_ITRACE_START missing for deviceNumber: " + deviceNumber + ", attribute: " + String.valueOf(attributeId));
        }
        final long recordTimestamp = this.timestampMapper.mapTimestamp(clockSource, timestamp);
        if (taskId != null) {
            contextSwitchTimestampToIncomingTaskId.put(recordTimestamp, (Object)taskId);
        }
        final long[] contextSwitchTimestamps = contextSwitchTimestampToIncomingTaskId.keys();
        Arrays.sort(contextSwitchTimestamps);
        final long recordStartTimestamp = contextSwitchTimestamps[0];
        @NonNull TaskId taskIdToUse = (TaskId)NullChecking.neverNull((Object)((TaskId)contextSwitchTimestampToIncomingTaskId.get(recordStartTimestamp)));
        if (ITimestampMapper.compare(recordStartTimestamp, recordTimestamp) > 0) {
            throw new IOException("PERF_RECORD_ITRACE_START is out of order with respect to PERF_RECORD_AUX for deviceNumber: " + deviceNumber + ", attribute: " + String.valueOf(attributeId));
        }
        TIntSet dataMarkers = (TIntSet)this.speLostDataMarkers.get(deviceNumber);
        boolean bl = isMarkedDataLost = dataMarkers != null && dataMarkers.contains(taskIdToUse.tid);
        if ((flags & 7L) != 0L) {
            this.output.annotationMarker(recordTimestamp, taskIdToUse, AnnotationColour.WARNING_COLOUR, SPE_AUX_DATA_MISSING_DATA_LOSS_MARKER);
            if (!isMarkedDataLost) {
                if (dataMarkers == null) {
                    dataMarkers = new TIntHashSet(10, 0.5f, -1);
                    this.speLostDataMarkers.put(deviceNumber, (Object)dataMarkers);
                }
                dataMarkers.add(taskIdToUse.tid);
                this.output.annotationTextPush(size == 0L ? recordStartTimestamp : recordTimestamp, taskIdToUse, SPE_AUX_DATA_MISSING_CHANNEL_TITLE, AnnotationColour.WARNING_COLOUR, SPE_AUX_DATA_MISSING_CHANNEL_TEXT);
            }
        } else if (isMarkedDataLost) {
            assert (dataMarkers != null);
            long markerTimestamp = size != 0L ? recordStartTimestamp : recordTimestamp;
            this.endSpeMissingDataAnnotation(markerTimestamp, taskIdToUse, dataMarkers);
        }
        if ((flags & 8L) != 0L) {
            this.output.annotationMarker(recordTimestamp, taskIdToUse, AnnotationColour.ALT_WARNING_COLOUR, SPE_COLLISION_MARKER);
        }
        if (size == 0L) {
            return;
        }
        final @NonNull ProcessingElementReference peReference = this.mapCpuReference(deviceNumber);
        @NonNull IPerfAuxDataBufferReader reader = this.perfAttributesState.getPerfAuxBufferReader(deviceNumber);
        Throwable throwable = null;
        Object var28_24 = null;
        try (@Nullable InputStream data = reader.read(offset, size);){
            if (data == null) {
                CommonPlugin.warning((String)String.format("No data in aux buffer for deviceNumber: " + deviceNumber + "(" + size + "@" + offset + ")", new Object[0]));
                return;
            }
            try {
                final int[] currentProcessIndexRef = new int[1];
                this.speDecoder.decode(new BufferedInputStream(data), new IThrowingConsumer<ISpeRecord, IOException>(taskIdToUse){
                    private @NonNull TaskId currentTaskId;
                    private int nextProcessIndex;
                    private long nextSwitchInTimestamp;
                    {
                        this.currentTaskId = taskId;
                        this.nextProcessIndex = 1;
                        this.nextSwitchInTimestamp = this.nextProcessIndex < lArray.length ? lArray[this.nextProcessIndex] : Long.MAX_VALUE;
                    }

                    public void accept(@NonNull ISpeRecord record) throws IOException {
                        @Nullable Long pc = record.getPc();
                        @Nullable Long cntvctEl0Timestamp = record.getTimestamp();
                        if (pc == null || cntvctEl0Timestamp == null) {
                            return;
                        }
                        // Could not load outer class - annotation placement on inner may be incorrect
                        @Nullable ISpeRecord.OperationType opType = record.getOperationType();
                        long mappedSpeTimestamp = PerfDataBufferPassTwoEventConsumer.this.timestampMapper.mapSpeClock(deviceNumber, cntvctEl0Timestamp);
                        long mappedTimestamp = Math.max(Math.min(recordTimestamp, mappedSpeTimestamp), recordStartTimestamp);
                        while (mappedTimestamp >= this.nextSwitchInTimestamp && this.nextProcessIndex <= contextSwitchTimestamps.length) {
                            TaskId nextTaskId = (TaskId)contextSwitchTimestampToIncomingTaskId.get(this.nextSwitchInTimestamp);
                            if (nextTaskId != null) {
                                this.currentTaskId = nextTaskId;
                                currentProcessIndexRef[0] = this.nextProcessIndex;
                            }
                            ++this.nextProcessIndex;
                            this.nextSwitchInTimestamp = this.nextProcessIndex < contextSwitchTimestamps.length ? contextSwitchTimestamps[this.nextProcessIndex] : Long.MAX_VALUE;
                        }
                        PerfDataBufferPassTwoEventConsumer.this.output.speSample(key, mappedTimestamp, peReference, this.currentTaskId, pc, opType != null ? opType.clazz : null, opType != null ? opType.subclazz : (byte)0, record.getEvents(), record.getDataSources(), record.getCounterMap());
                    }
                });
                int i = 0;
                while (i < currentProcessIndexRef[0]) {
                    contextSwitchTimestampToIncomingTaskId.remove(contextSwitchTimestamps[i]);
                    ++i;
                }
            }
            catch (SpeDecodeException e) {
                throw new IOException("Error decoding SPE data", e);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void comm(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull TaskId taskId, @NonNull String comm, boolean exec, @Nullable Long sampleTimestampLocalClock) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, timestamp);
        this.output.threadRename(mappedTimestamp, taskId, comm, exec);
    }

    @Override
    public void exit(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull TaskId taskId) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, timestamp);
        for (TIntSet tidSet : this.speLostDataMarkers.valueCollection()) {
            if (!tidSet.contains(taskId.tid)) continue;
            this.endSpeMissingDataAnnotation(timestamp, taskId, tidSet);
        }
        this.output.threadExit(mappedTimestamp, taskId);
    }

    @Override
    public void fork(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull TaskId parentTaskId, @NonNull TaskId taskId) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, timestamp);
        this.output.threadFork(mappedTimestamp, parentTaskId, taskId);
    }

    @Override
    public void itraceStart(@NonNull APCFrameAddress userData, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @Nullable Long attributeId, @NonNull TaskId taskId) throws IOException {
        if (this.ignoreAux || !this.isSpeAttribute(attributeId)) {
            return;
        }
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, timestamp);
        this.trackAuxTaskSwitch(mappedTimestamp, deviceNumber, taskId);
    }

    @Override
    public void lost(@NonNull APCFrameAddress userData, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, long id, long lost) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, timestamp);
        if (mappedTimestamp >= 0L) {
            this.output.warning(mappedTimestamp, new TaskId(0), WarningsFactory.lostData());
        }
    }

    @Override
    public void lostSamples(@NonNull APCFrameAddress userData, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, long lost) throws IOException {
    }

    @Override
    public void mmap(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull TaskId taskId, long addr, long len, long pgOff, @NonNull String filename, boolean data) throws IOException {
        if (!data && !"//anon".equals(filename)) {
            long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, timestamp);
            this.output.threadMMap(mappedTimestamp, taskId, pgOff, addr, len, filename);
        }
    }

    @Override
    public void other(@NonNull APCFrameAddress userData, @NonNull ClockSource clockSource, long timestamp, @NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, int deviceNumber, @NonNull ByteBuffer buffer) throws IOException {
    }

    @Override
    public void read(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull TaskId taskId, @NonNull ReadFormat readFormat) throws IOException {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void sample(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, @NonNull EventHeader header, @NonNull RecordBlob.SampleRecord sampleRecord, int deviceNumber, @Nullable ReadFormat readFormat, long @Nullable [] callchain, byte @Nullable [] raw, boolean registersHostIs64bit, RecordBlob.IRecordBlobVisitor.Abi registersAbi, RegisterValues registers) throws IOException {
        block39: {
            attribute = sampleRecord.getEventAttribute();
            mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, timestamp);
            pid = sampleRecord.pid;
            tid = sampleRecord.tid;
            if (!(PerfDataBufferPassTwoEventConsumer.$assertionsDisabled || pid == null && tid == null || pid != null && tid != null)) {
                throw new AssertionError();
            }
            taskId = PerfDataBufferPassProcessor.makeTaskId(pid, tid);
            peReference = this.mapCpuReference(deviceNumber);
            periodBasedCounterKey = null;
            this.initialSwitch(mappedTimestamp, peReference, taskId);
            fakeContextSwitch = PerfDataBufferPassTwoEventConsumer.shouldGenerateFakeContextSwitch(this.perfAttributesState, attribute);
            switch (PerfDataBufferPassTwoEventConsumer.$SWITCH_TABLE$com$arm$streamline$protocol$capture$apc$pass_two$PerfDataBufferPassTwoEventConsumer$GenerateFakeContextSwitchResult()[fakeContextSwitch.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    if (taskId == null) break;
                    this.output.schedSwitch(mappedTimestamp, peReference, taskId, IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason.SCHEDULED);
                    break;
                }
                case 3: {
                    this.output.schedSwitch(mappedTimestamp, peReference, new TaskId(null, 0), IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason.SCHEDULED);
                    break;
                }
                default: {
                    throw new AssertionError((Object)fakeContextSwitch);
                }
            }
            registerForStack = PerfDataBufferPassTwoEventConsumer.extractAbiRegisters(registersHostIs64bit, registersAbi, registers);
            actualCallchain = PerfDataBufferPassTwoEventConsumer.cleanupCallChain(callchain, sampleRecord.ip, registersAbi, registerForStack != null ? registerForStack[0] : 0L, registerForStack != null ? registerForStack[1] : 0L);
            if (actualCallchain != null && actualCallchain.length > 0) {
                if (!PerfDataBufferPassTwoEventConsumer.$assertionsDisabled && taskId == null) {
                    throw new AssertionError();
                }
                backtraceSource = this.determineBacktraceSource(sampleRecord);
                this.output.absoluteBacktrace(mappedTimestamp, backtraceSource, peReference, taskId, actualCallchain);
            }
            if (attribute.getType() != 2 || (tracepointFormat = this.perfAttributesState.getTracepointFormat(attribute.getConfig())) == null) ** GOTO lbl95
            tracepointName = tracepointFormat.getName();
            if (raw == null) break block39;
            this.output.tracepointEvent(mappedTimestamp, taskId, tracepointFormat, raw);
            var27_25 = tracepointName;
            tmp = -1;
            switch (var27_25.hashCode()) {
                case -965384772: {
                    if (var27_25.equals("sched_switch")) {
                        tmp = 1;
                    }
                    break;
                }
                case 501301259: {
                    if (var27_25.equals("cpu_idle")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1241386885: {
                    if (var27_25.equals("cpu_frequency")) {
                        tmp = 3;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    if (this.allowSchedSwitchTracepoints) {
                        prevState = (int)tracepointFormat.getInt("prev_state", raw);
                        nextTid = (int)tracepointFormat.getInt("next_pid", raw);
                        reason = (long)prevState == 0L ? IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason.CONTENTION : IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason.SCHEDULED;
                        this.output.schedSwitch(mappedTimestamp, peReference, new TaskId(nextTid), reason);
                    }
                    ** GOTO lbl95
                }
                case 3: {
                    state = (int)tracepointFormat.getInt("state", raw);
                    sourceCpu = (int)tracepointFormat.getInt("cpu_id", raw);
                    key = this.cpuFrequencyTracepointKeyProvider.apply(sourceCpu);
                    if (key != null) {
                        this.commonFtraceProcessing.onCpuFrequency(key, mappedTimestamp, sourceCpu, state);
                    } else {
                        counterSeriesKey = this.tracepointCounterMapper.apply(tracepointName);
                        if (counterSeriesKey != null) {
                            this.commonFtraceProcessing.onCpuFrequency(counterSeriesKey, mappedTimestamp, sourceCpu, state);
                        }
                    }
                    ** GOTO lbl95
                }
                default: {
                    if (this.maliUserspaceSoftwareCounters.isMaliSoftwareCounterTracepoint(tracepointFormat)) {
                        this.maliUserspaceSoftwareCounters.processTracepointData(mappedTimestamp, tracepointFormat, raw);
                    } else if (this.kernelTracepointProcessor.isKernelTracepoint(tracepointFormat)) {
                        this.kernelTracepointProcessor.processTracepointData(mappedTimestamp, tracepointFormat, raw);
                    } else {
                        counterSeriesKey = this.tracepointCounterMapper.apply(tracepointName);
                        if (counterSeriesKey != null && (tracepointArg = counterSeriesKey.getTracepointArg()) != null) {
                            value = tracepointFormat.getInt(tracepointArg, raw);
                            peReferenceToUse = this.mapCounterProcessingElement(peReference, counterSeriesKey);
                            this.output.counter(counterSeriesKey, mappedTimestamp, peReferenceToUse, taskId, value);
                        } else {
                            periodBasedCounterKey = counterSeriesKey;
                        }
                    }
                    ** GOTO lbl95
                }
                case 2: {
                    ** if (readFormat == null) goto lbl-1000
                }
            }
        }
        periodBasedCounterKey = this.tracepointCounterMapper.apply(tracepointName);
lbl95:
        // 9 sources

        if (readFormat != null) lbl-1000:
        // 2 sources

        {
            this.processReadFormat(mappedTimestamp, peReference, taskId, readFormat);
        } else if (!this.isCounterReadFromTracepointRawData(attribute, sampleRecord.getAttributeId())) {
            samplePeriod = sampleRecord.period;
            if (samplePeriod != null) {
                period = samplePeriod;
            } else {
                if (!PerfDataBufferPassTwoEventConsumer.$assertionsDisabled && attribute.isFlagSet(EventAttribute.Flags.FREQ)) {
                    throw new AssertionError();
                }
                period = attribute.getSampleFreqOrPeriod();
            }
            if (periodBasedCounterKey == null && (key = this.perfAttributesState.getKeyByAttributeId(id = sampleRecord.getAttributeId())) != null) {
                periodBasedCounterKey = this.counterSeriesKeyMapper.apply(key);
            }
            if (periodBasedCounterKey != null && period != 0L) {
                peReferenceToUse = this.mapCounterProcessingElement(peReference, periodBasedCounterKey);
                this.output.counter(periodBasedCounterKey, mappedTimestamp, peReferenceToUse, taskId, period);
            }
        }
    }

    @Override
    public void simplePerfCallchain(@NonNull APCFrameAddress userData, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull TaskId taskId, long chainType, long time, long[] ips, long[] sps) throws IOException {
        if (ips.length > 0) {
            long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, timestamp);
            @NonNull ProcessingElementReference peReference = this.mapCpuReference(deviceNumber);
            @NonNull IBacktraceSource backtraceSource = IBacktraceSource.PERIODIC_SAMPLES;
            this.output.absoluteBacktrace(mappedTimestamp, backtraceSource, peReference, taskId, ips);
        }
    }

    @Override
    public void simplePerfKAllSyms(@NonNull APCFrameAddress userData, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull String kallsyms) throws IOException {
    }

    @Override
    public void swtch(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @Nullable Long attributeId, @Nullable TaskId taskId, boolean out) throws IOException {
        if (taskId != null) {
            long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, timestamp);
            @NonNull ProcessingElementReference peReference = this.mapCpuReference(deviceNumber);
            @NonNull TaskId mappedTaskId = PerfDataBufferPassTwoEventConsumer.mapSwitchTaskId(out, taskId);
            if (this.isSpeAttribute(attributeId)) {
                if (this.ignoreAux) {
                    return;
                }
                this.trackAuxTaskSwitch(mappedTimestamp, deviceNumber, mappedTaskId);
            } else {
                this.output.schedSwitch(mappedTimestamp, peReference, mappedTaskId, IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason.SCHEDULED);
            }
        }
    }

    @Override
    public void swtchCpuWide(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @Nullable Long attributeId, @Nullable TaskId sampleTaskId, boolean out, @NonNull TaskId prevNextTaskId) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, timestamp);
        @NonNull ProcessingElementReference peReference = this.mapCpuReference(deviceNumber);
        if (this.isSpeAttribute(attributeId)) {
            if (this.ignoreAux) {
                return;
            }
            PerfDataBufferPassTwoEventConsumer.swtchCpuWide_common(deviceNumber, sampleTaskId, out, prevNextTaskId, this.switchOutNextTaskIdSpe, (IThrowingConsumer<TaskId, IOException>)((IThrowingConsumer)mappedTaskId -> this.trackAuxTaskSwitch(mappedTimestamp, deviceNumber, (TaskId)mappedTaskId)));
        } else {
            PerfDataBufferPassTwoEventConsumer.swtchCpuWide_common(deviceNumber, sampleTaskId, out, prevNextTaskId, this.switchOutNextTaskIdScheduler, (IThrowingConsumer<TaskId, IOException>)((IThrowingConsumer)mappedTaskId -> this.output.schedSwitch(mappedTimestamp, peReference, (TaskId)mappedTaskId, IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason.SCHEDULED)));
        }
    }

    @Override
    public void throttle(@NonNull APCFrameAddress userData, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, long time, long id, long streamId) throws IOException {
    }

    @Override
    public void unthrottle(@NonNull APCFrameAddress userData, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, long time, long id, long streamId) throws IOException {
    }

    protected final @NonNull IBacktraceSource determineArbitraryBacktraceSource(@Nullable Long attributeId, @NonNull EventAttribute attribute, @NonNull EventAndPmuNames.TypeAndConfig typeAndConfig) {
        String result;
        Integer key;
        ICounterSeriesKey counterSeriesKey;
        TracepointFormat tracepointFormat;
        assert (attribute.getTypeAndConfig().equals(typeAndConfig));
        if (attribute.isFlagSet(EventAttribute.Flags.FREQ) || attribute.getSampleFreqOrPeriod() == 0L) {
            return IBacktraceSource.PERIODIC_SAMPLES;
        }
        if ((attribute.getSampleType() & 0x21L) == 0L) {
            return IBacktraceSource.PERIODIC_SAMPLES;
        }
        if (attribute.getType() == 1 && (attribute.getConfig() == 0L || attribute.getConfig() == 1L)) {
            return IBacktraceSource.PERIODIC_SAMPLES;
        }
        String tracepointName = null;
        if (attribute.getType() == 2 && (tracepointFormat = this.perfAttributesState.getTracepointFormat(attribute.getConfig())) != null) {
            if (TRACEPOINT_NAME__SCHED_SWITCH.equals(tracepointFormat.getName())) {
                return IBacktraceSource.PERIODIC_SAMPLES;
            }
            tracepointName = tracepointFormat.getName();
        }
        ICounterSeriesKey iCounterSeriesKey = counterSeriesKey = (key = this.perfAttributesState.getKeyByAttributeId(attributeId)) != null ? this.counterSeriesKeyMapper.apply(key) : null;
        if (counterSeriesKey != null && (result = counterSeriesKey.getArbitraryBacktraceSourceName()) != null) {
            return BacktraceSource.ebs((String)result);
        }
        if (tracepointName == null) {
            @Nullable String name = EventAndPmuNames.getPerfEventName(typeAndConfig);
            if (name != null) {
                return BacktraceSource.ebs((String)name);
            }
        } else {
            return BacktraceSource.ebs(tracepointName);
        }
        return IBacktraceSource.PERIODIC_SAMPLES;
    }

    protected final @NonNull IBacktraceSource determineBacktraceSource(@NonNull RecordBlob.SampleRecord sampleRecord) {
        EventAttribute attribute;
        String ebsCounterName;
        ICounterSeriesKey counterSeriesKey;
        Integer key;
        @Nullable Long attributeId = sampleRecord.getAttributeId();
        if (attributeId != null && (key = this.perfAttributesState.getKeyByAttributeId(attributeId)) != null && (counterSeriesKey = this.counterSeriesKeyMapper.apply(key)) != null && (ebsCounterName = counterSeriesKey.getBacktraceSourceNameIfEbsCounter()) != null) {
            return BacktraceSource.ebs((String)ebsCounterName);
        }
        if (this.allowArbitraryEbsBacktraceSources && (attribute = sampleRecord.attribute) != null) {
            return this.backtraceSources.computeIfAbsent(attribute.getTypeAndConfig(), typeAndConfig -> this.determineArbitraryBacktraceSource(attributeId, attribute, (EventAndPmuNames.TypeAndConfig)typeAndConfig));
        }
        return IBacktraceSource.PERIODIC_SAMPLES;
    }

    private void endSpeMissingDataAnnotation(long markerTimestamp, @NonNull TaskId taskIdToUse, @NonNull TIntSet tidSet) throws IOException {
        this.output.annotationTextPop(markerTimestamp, taskIdToUse, SPE_AUX_DATA_MISSING_CHANNEL_TITLE);
        tidSet.remove(taskIdToUse.tid);
    }

    private void initialSwitch(long mappedTimestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId) throws IOException {
        assert (peReference.deviceType.isCPU());
        assert (peReference.vmUID == this.vmUID);
        int deviceNumber = peReference.deviceNumber;
        if (taskId == null) {
            return;
        }
        if (!this.cpuNumbersForWhichInitialSwitchWasSent.add(deviceNumber)) {
            return;
        }
        this.output.schedSwitch(mappedTimestamp, peReference, taskId, IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason.SCHEDULED);
    }

    private boolean isCounterReadFromTracepointRawData(@NonNull EventAttribute attribute, @Nullable Long attributeId) {
        String tracepointName;
        if (attribute.getType() != 2) {
            return false;
        }
        @Nullable TracepointFormat tracepointFormat = this.perfAttributesState.getTracepointFormat(attribute.getConfig());
        if (tracepointFormat == null) {
            Integer key = this.perfAttributesState.getKeyByAttributeId(attributeId);
            if (key == null) {
                return false;
            }
            ICounterSeriesKey counterKey = this.counterSeriesKeyMapper.apply(key);
            if (counterKey == null) {
                return false;
            }
            return counterKey.getTracepointArg() != null || counterKey.getDeviceTypeOrDefault().isGPU();
        }
        switch (tracepointName = tracepointFormat.getName()) {
            case "sched_switch": {
                return false;
            }
            case "cpu_idle": {
                return false;
            }
            case "cpu_frequency": {
                return true;
            }
        }
        if (this.maliUserspaceSoftwareCounters.isMaliSoftwareCounterTracepoint(tracepointFormat)) {
            return true;
        }
        @Nullable ICounterSeriesKey counterSeriesKey = this.tracepointCounterMapper.apply(tracepointName);
        return counterSeriesKey != null && counterSeriesKey.getTracepointArg() != null;
    }

    private boolean isSpeAttribute(@Nullable Long attributeId) {
        Integer possibleKey = this.perfAttributesState.getKeyByAttributeId(attributeId);
        if (possibleKey == null) {
            return false;
        }
        int key = possibleKey;
        return this.isSpeKey.test(key);
    }

    private @NonNull ProcessingElementReference mapCounterProcessingElement(@NonNull ProcessingElementReference peReference, @NonNull ICounterSeriesKey counterKey) throws AssertionError {
        @NonNull DeviceType counterSeriesDeviceType = counterKey.getDeviceTypeOrDefault();
        if (!counterSeriesDeviceType.isCPU() && !counterSeriesDeviceType.isSystemWide()) {
            throw new AssertionError();
        }
        return counterSeriesDeviceType.isCPU() ? peReference : this.processingElements.get(counterSeriesDeviceType, this.vmUID, 0);
    }

    private @NonNull ProcessingElementReference mapCpuReference(int deviceNumber) {
        return this.processingElements.get(DeviceType.CPU, this.vmUID, deviceNumber);
    }

    private void processReadFormat(long mappedTimestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, @NonNull ReadFormat readFormat) throws IOException {
        long[] values = readFormat.getValues();
        long[] ids = readFormat.getIds();
        int i = 0;
        while (i < values.length) {
            ICounterSeriesKey counterSeriesKey;
            EventAttribute attribute;
            long id = ids[i];
            long absValue = values[i];
            @Nullable Integer key = this.perfAttributesState.getKeyByAttributeId(id);
            if (key != null && !this.isCounterReadFromTracepointRawData(attribute = this.perfAttributesState.getEventAttributeById(id), id) && (counterSeriesKey = this.counterSeriesKeyMapper.apply(key)) != null) {
                assert (!counterSeriesKey.isThreadCounter());
                long prevAbsValue = this.counterValueTracker.put(id, absValue);
                long delta = absValue - prevAbsValue;
                @NonNull ProcessingElementReference peReferenceToUse = this.mapCounterProcessingElement(peReference, counterSeriesKey);
                this.output.counter(counterSeriesKey, mappedTimestamp, peReferenceToUse, taskId, delta);
            }
            ++i;
        }
    }

    private void trackAuxTaskSwitch(long timestamp, int deviceNumber, @NonNull TaskId taskId) throws IOException {
        TLongObjectMap map = (TLongObjectMap)this.auxTraceTaskTrace.get(deviceNumber);
        if (map == null) {
            map = new TLongObjectHashMap(10, 0.5f, -1L);
            this.auxTraceTaskTrace.put(deviceNumber, (Object)map);
        }
        map.put(timestamp, (Object)taskId);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$arm$streamline$protocol$capture$apc$pass_two$PerfDataBufferPassTwoEventConsumer$GenerateFakeContextSwitchResult() {
        if ($SWITCH_TABLE$com$arm$streamline$protocol$capture$apc$pass_two$PerfDataBufferPassTwoEventConsumer$GenerateFakeContextSwitchResult != null) {
            return $SWITCH_TABLE$com$arm$streamline$protocol$capture$apc$pass_two$PerfDataBufferPassTwoEventConsumer$GenerateFakeContextSwitchResult;
        }
        int[] nArray = new int[GenerateFakeContextSwitchResult.values().length];
        try {
            nArray[GenerateFakeContextSwitchResult.DO_NOT_GENERATE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GenerateFakeContextSwitchResult.GENERATE_ENTRY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GenerateFakeContextSwitchResult.GENERATE_EXIT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$arm$streamline$protocol$capture$apc$pass_two$PerfDataBufferPassTwoEventConsumer$GenerateFakeContextSwitchResult = nArray;
        return nArray;
    }

    public static enum GenerateFakeContextSwitchResult {
        DO_NOT_GENERATE,
        GENERATE_ENTRY,
        GENERATE_EXIT;

    }

    @FunctionalInterface
    public static interface ISpeDecoder {
        public void decode(@NonNull InputStream var1, @NonNull IThrowingConsumer<@NonNull ISpeRecord, IOException> var2) throws SpeDecodeException, IOException;
    }
}

