/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two;

import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.model.DynamicCounterSeriesKey;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.KernelAnnotationSeriesKey;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterMode;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.common.xml.spe.SpeOperationTypeClass;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.protocol.capture.apc.pass_one.ICookieTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoEventStream;
import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoForAnalysisEventStream;
import com.arm.streamline.protocol.capture.apc.pass_two.IUniqueThreadTracker;
import com.arm.streamline.protocol.misc.LinuxMapsParser;
import com.arm.streamline.protocol.misc.TaskId;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TByteShortMap;
import gnu.trove.set.TShortSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GatorPassTwoSortedEventStreamConsumer
implements IGatorPassTwoEventStream {
    private final @NonNull ICookieTracker cookieTracker;
    private final @NonNull IGatorPassTwoForAnalysisEventStream output;
    private final @NonNull IUniqueThreadTracker uniqueThreadTracker;

    public static @Nullable IExecutablePath mapExecutablePath(@NonNull String filename, boolean emptyIsNone) {
        if (filename.isEmpty()) {
            return emptyIsNone ? IExecutablePath.NONE : null;
        }
        if ("//anon".equals(filename)) {
            return null;
        }
        if ("[kernel.kallsyms]_text".equals(filename)) {
            return IExecutablePath.KERNEL;
        }
        if (filename.endsWith("/")) {
            return null;
        }
        return IExecutablePath.createFromPath((String)filename);
    }

    private static @NonNull TIntArrayList mapActivityColours(@NonNull List<@NonNull AnnotationColour> activityColors) {
        int size = activityColors.size();
        @NonNull TIntArrayList result = new TIntArrayList(size);
        int i = 0;
        while (i < size) {
            @Nullable Integer colour = activityColors.get(i).mapCounterColour();
            int colourToUse = colour != null ? colour : AnnotationColour.DARK_COLOR_PALETTE[i % AnnotationColour.DARK_COLOR_PALETTE.length];
            result.add(colourToUse);
            ++i;
        }
        return result;
    }

    public GatorPassTwoSortedEventStreamConsumer(@NonNull ICookieTracker cookieTracker, @NonNull IUniqueThreadTracker uniqueThreadTracker, @NonNull IGatorPassTwoForAnalysisEventStream output) {
        this.cookieTracker = cookieTracker;
        this.uniqueThreadTracker = uniqueThreadTracker;
        this.output = output;
    }

    @Override
    public void absoluteBacktrace(long timestamp, IBacktraceSource backtraceSource, @NonNull ProcessingElementReference peReference, @NonNull TaskId taskId, long @NonNull [] addresses) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.absoluteBacktrace(timestamp, backtraceSource, peReference, uniqueThread, addresses);
    }

    @Override
    public void activityStop(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, int activity) throws IOException {
        @Nullable IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.trackNullable(timestamp, taskId);
        this.output.activityStop(counterKey, timestamp, peReference, uniqueThread, activity);
    }

    @Override
    public void activitySwitch(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, int activity, int reason) throws IOException {
        @Nullable IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.trackNullable(timestamp, taskId);
        this.output.activitySwitch(counterKey, timestamp, peReference, uniqueThread, activity, reason);
    }

    @Override
    public void annotationMarker(long timestamp, @Nullable TaskId taskId, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.trackNullableOrKernel(timestamp, taskId);
        this.output.annotationMarker(timestamp, uniqueThread, colour, text);
    }

    @Override
    public void annotationText(long timestamp, @NonNull TaskId taskId, int channel, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.annotationText(timestamp, uniqueThread, channel, colour, text);
    }

    @Override
    public void annotationTextAsync(long timestamp, @NonNull TaskId taskId, @NonNull String title, int id, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.annotationTextAsync(timestamp, uniqueThread, title, id, colour, text);
    }

    @Override
    public void annotationTextAsyncEnd(long timestamp, @NonNull TaskId taskId, @NonNull String title, int id) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.annotationTextAsyncEnd(timestamp, uniqueThread, title, id);
    }

    @Override
    public void annotationTextNameChannel(long timestamp, @NonNull TaskId taskId, int channel, int group, @NonNull String text) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.annotationTextNameChannel(timestamp, uniqueThread, channel, group, text);
    }

    @Override
    public void annotationTextNameGroup(long timestamp, @NonNull TaskId taskId, int group, @NonNull String text) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.annotationTextNameGroup(timestamp, uniqueThread, group, text);
    }

    @Override
    public void annotationTextPop(long timestamp, @NonNull TaskId taskId, @NonNull String title) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.annotationTextPop(timestamp, uniqueThread, title);
    }

    @Override
    public void annotationTextPush(long timestamp, @NonNull TaskId taskId, @NonNull String title, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.annotationTextPush(timestamp, uniqueThread, title, colour, text);
    }

    @Override
    public void annotationVisual(long timestamp, @NonNull TaskId taskId, @NonNull String text, byte @NonNull [] image) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.annotationVisual(timestamp, uniqueThread, text, image);
    }

    @Override
    public void atraceCounter(long timestamp, @NonNull String name, @NonNull TaskId taskId, long value) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.atraceCounter(timestamp, name, uniqueThread, value);
    }

    @Override
    public void attributes(long vmUID, Map<@NonNull String, @NonNull String> attributes) throws IOException {
    }

    @Override
    public void camJob(int viewUID, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.output.camJob(viewUID, startTime, duration, track, jobUID, name, colour, primaryDependency, dependencies);
    }

    @Override
    public void camJob(@NonNull TaskId taskId, int viewUID, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(startTime, taskId);
        this.output.camJob(uniqueThread, viewUID, startTime, duration, track, jobUID, name, colour, primaryDependency, dependencies);
    }

    @Override
    public void camJobDependencies(@NonNull TaskId taskId, int viewUID, long timestamp, int jobUID, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.camJobDependencies(uniqueThread, viewUID, timestamp, jobUID, primaryDependency, dependencies);
    }

    @Override
    public void camJobStart(@NonNull TaskId taskId, int viewUID, long timestamp, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.camJobStart(uniqueThread, viewUID, timestamp, track, jobUID, name, colour);
    }

    @Override
    public void camJobStop(@NonNull TaskId taskId, int viewUID, long timestamp, int jobUID) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.camJobStop(uniqueThread, viewUID, timestamp, jobUID);
    }

    @Override
    public void camTrack(int viewUID, int parentTrack, int trackUID, @NonNull String name) throws IOException {
        this.output.camTrack(viewUID, parentTrack, trackUID, name);
    }

    @Override
    public void camTrack(long timestamp, @NonNull TaskId taskId, int viewUID, int parentTrack, int trackUID, @NonNull String name) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.camTrack(uniqueThread, viewUID, timestamp, parentTrack, trackUID, name);
    }

    @Override
    public void camView(int viewUID, @NonNull String name) throws IOException {
        this.output.camView(viewUID, name);
    }

    @Override
    public void camView(long timestamp, @NonNull TaskId taskId, int viewUID, @NonNull String name) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.camView(uniqueThread, viewUID, timestamp, name);
    }

    @Override
    public void chopExternalFrame(int offset) {
    }

    @Override
    public void chopExternalHeaderFrame(int offset) {
    }

    @Override
    public void counter(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, long value) throws IOException {
        @Nullable IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.trackNullable(timestamp, taskId);
        this.output.counter(counterKey, timestamp, peReference, uniqueThread, value);
    }

    @Override
    public void createDynamicCounterSeries(@NonNull DynamicCounterSeriesKey counterKey, @NonNull String title, @NonNull String name, @NonNull String units, @NonNull String description, @NonNull CounterClass counterClass, @NonNull CounterDisplay display, @NonNull SeriesComposition seriesComposition, @NonNull GraphRenderingType renderingType, boolean averageSelection, boolean percentage, @NonNull AnnotationColour colour, double multiplier, @NonNull List<@NonNull String> activities, @NonNull List<@NonNull AnnotationColour> activityColors) throws IOException {
        this.output.createDynamicCounterSeries(counterKey, new CounterRecord(String.format("dynamic-counter-%d", counterKey.getKey()), title, name, description, units, colour.mapCounterColour(), counterKey.getKey(), counterClass, display, averageSelection, CounterMode.SYSTEM_WIDE, multiplier, seriesComposition, renderingType, false, percentage, activities, GatorPassTwoSortedEventStreamConsumer.mapActivityColours(activityColors), 0, false, true, Ternary.TRUE, null));
    }

    @Override
    public void createKernelAnnotationsCounterSeries(@NonNull KernelAnnotationSeriesKey counterKey, @NonNull String title, @NonNull String name, @NonNull String units, @NonNull String description, @NonNull CounterClass counterClass, @NonNull CounterDisplay display, @NonNull SeriesComposition seriesComposition, @NonNull GraphRenderingType renderingType, boolean averageSelection, boolean percentage, @NonNull AnnotationColour colour, double multiplier, @NonNull List<@NonNull String> activities, @NonNull List<@NonNull AnnotationColour> activityColors) throws IOException {
        this.output.createKernelAnnotationsCounterSeries(counterKey, new CounterRecord(String.format("kernel-annotation-counter-%s-%s", counterKey.getTitle(), counterKey.getName()), title, name, description, units, colour.mapCounterColour(), counterKey.hashCode(), counterClass, display, averageSelection, CounterMode.SYSTEM_WIDE, multiplier, seriesComposition, renderingType, false, percentage, activities, GatorPassTwoSortedEventStreamConsumer.mapActivityColours(activityColors), 0, false, true, Ternary.TRUE, null));
    }

    @Override
    public void idle(long timestamp, @NonNull ProcessingElementReference peReference, boolean online) throws IOException {
        this.output.idle(timestamp, peReference, online);
    }

    @Override
    public void schedSwitch(long timestamp, @NonNull ProcessingElementReference peReference, @NonNull TaskId nextTaskId,  @NonNull IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason reason) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, nextTaskId);
        this.output.schedSwitch(timestamp, peReference, uniqueThread, reason);
    }

    @Override
    public void speSample(int key, long timestamp, @NonNull ProcessingElementReference peReference, @NonNull TaskId taskId, long pc, @Nullable SpeOperationTypeClass opTypeClass, byte opTypeSubclass, long events, @NonNull TShortSet dataSources, @NonNull TByteShortMap counterMap) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.speSample(key, timestamp, peReference, uniqueThread, pc, opTypeClass, opTypeSubclass, events, dataSources, counterMap);
    }

    @Override
    public void threadExec(long timestamp, @Nullable TaskId oldTaskId, @NonNull TaskId taskId, int cookieUID) throws IOException {
        this.uniqueThreadTracker.threadExec(timestamp, oldTaskId, taskId, ICookieTracker.mapCookie(this.cookieTracker, cookieUID));
    }

    @Override
    public void threadExit(long timestamp, @NonNull TaskId taskId) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.threadExit(timestamp, taskId);
        this.output.threadExit(timestamp, uniqueThread);
    }

    @Override
    public void threadFork(long timestamp, @Nullable TaskId parentTaskId, @NonNull TaskId taskId) throws IOException {
        this.uniqueThreadTracker.threadFork(timestamp, parentTaskId, taskId);
    }

    @Override
    public void threadLinkCookie(long timestamp, @NonNull TaskId taskId, int cookieUID) throws IOException {
        this.uniqueThreadTracker.threadLinkExecutablePath(timestamp, taskId, ICookieTracker.mapCookie(this.cookieTracker, cookieUID));
    }

    @Override
    public void threadMaps(long timestamp, @NonNull TaskId taskId, @NonNull String maps) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId, false);
        LinuxMapsParser.parse(maps, (startAddress, endAddress, offset, filename) -> this.uniqueThreadTracker.threadMMap(uniqueThread, offset, startAddress, endAddress - startAddress, GatorPassTwoSortedEventStreamConsumer.mapExecutablePath(filename, false)));
    }

    @Override
    public void threadMMap(long timestamp, @NonNull TaskId taskId, long fileOffset, long mapAddress, long length, @NonNull String filename) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId, false);
        this.uniqueThreadTracker.threadMMap(uniqueThread, fileOffset, mapAddress, length, GatorPassTwoSortedEventStreamConsumer.mapExecutablePath(filename, false));
    }

    @Override
    public void threadProperties(long timestamp, @Nullable TaskId parentTaskId, @NonNull TaskId taskId, @NonNull String name, @NonNull String exePath, @Nullable String linuxProcMapsContents) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.threadProperties(timestamp, parentTaskId, taskId, name, GatorPassTwoSortedEventStreamConsumer.mapExecutablePath(exePath, true));
        if (linuxProcMapsContents != null) {
            LinuxMapsParser.parse(linuxProcMapsContents, (startAddress, endAddress, offset, filename) -> this.uniqueThreadTracker.threadMMap(uniqueThread, offset, startAddress, endAddress - startAddress, GatorPassTwoSortedEventStreamConsumer.mapExecutablePath(filename, false)));
        }
    }

    @Override
    public void threadRename(long timestamp, @NonNull TaskId taskId, @NonNull String name, boolean exec) throws IOException {
        this.uniqueThreadTracker.threadRename(timestamp, taskId, name, exec);
    }

    @Override
    public void tracepointEvent(long timestamp, @Nullable TaskId taskId, @NonNull TracepointFormat tracepointFormat, byte @NonNull [] raw) throws IOException {
        @Nullable IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.trackNullable(timestamp, taskId);
        this.output.tracepointEvent(timestamp, uniqueThread, tracepointFormat, raw);
    }

    @Override
    public void warning(long timestamp, @NonNull TaskId taskId, @NonNull WarningItem warning) throws IOException {
        @NonNull IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.output.warning(timestamp, uniqueThread, warning);
    }

    @Override
    public void warning(@NonNull WarningItem warning) throws IOException {
        this.output.warning(warning);
    }

    private @Nullable IUniqueThreadTracker.ITrackedUniqueThread trackNullable(long timestamp, @Nullable TaskId taskId) {
        if (taskId == null) {
            return null;
        }
        return this.uniqueThreadTracker.track(timestamp, taskId);
    }

    private @NonNull IUniqueThreadTracker.ITrackedUniqueThread trackNullableOrKernel(long timestamp, @Nullable TaskId taskId) {
        if (taskId == null) {
            return this.uniqueThreadTracker.track(timestamp, new TaskId(0, 0));
        }
        return this.uniqueThreadTracker.track(timestamp, taskId);
    }
}

