/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_one;

import com.arm.streamline.protocol.capture.apc.pass_one.IGatordSyncThreadTracker;
import com.arm.utils.numbers.UnsignedLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GatordModernSyncThreadTracker
implements IGatordSyncThreadTracker {
    public static final @NonNull String GATORD_SYNC_THREAD_COMM = "gator-sync-0";
    public static final @NonNull Pattern GATORD_SYNC_THREAD_COMM_COUNT_PATTERN = Pattern.compile("gds-(\\d+)-");
    private @Nullable Long detectedLocalClockBase;
    private @Nullable Integer gatordSyncTid;
    private @Nullable Long lastMaybeMonotonicDelta;
    private @Nullable Integer maybeGatordSyncTid;
    private boolean nosync = false;

    @Override
    public boolean canCalculateLocalClockBase() {
        return this.nosync || this.detectedLocalClockBase != null;
    }

    @Override
    public @Nullable Long getLocalClockBase(long monotonicDeltaBase) {
        if (this.nosync) {
            return null;
        }
        return this.detectedLocalClockBase;
    }

    @Override
    public void setNoSync(boolean nosync) {
        if (nosync) {
            this.nosync = true;
        }
    }

    @Override
    public void trackComm(int tid, @NonNull String comm, @Nullable Long localClock) {
        if (GATORD_SYNC_THREAD_COMM.equals(comm)) {
            @Nullable Integer gatordSyncTid = this.gatordSyncTid;
            if (gatordSyncTid == null) {
                this.gatordSyncTid = tid;
            } else if (gatordSyncTid != tid) {
                throw new AssertionError();
            }
        } else {
            Matcher matcher;
            @Nullable Integer gatordSyncTid = this.gatordSyncTid;
            if (gatordSyncTid == null) {
                Matcher matcher2 = GATORD_SYNC_THREAD_COMM_COUNT_PATTERN.matcher(comm);
                if (matcher2.matches()) {
                    @Nullable Integer maybeGatordSyncTid = this.maybeGatordSyncTid;
                    @Nullable Long lastMaybeMonotonicDelta = this.lastMaybeMonotonicDelta;
                    long uSecondsSinceStart = Long.parseLong(matcher2.group(1), 10);
                    if (maybeGatordSyncTid == null) {
                        this.maybeGatordSyncTid = tid;
                        this.lastMaybeMonotonicDelta = uSecondsSinceStart;
                    } else if (maybeGatordSyncTid == tid) {
                        assert (lastMaybeMonotonicDelta != null);
                        long delta = uSecondsSinceStart - lastMaybeMonotonicDelta;
                        if (delta > 0L) {
                            this.gatordSyncTid = tid;
                        }
                    } else {
                        this.maybeGatordSyncTid = null;
                    }
                }
            } else if (localClock != null && gatordSyncTid == tid && (matcher = GATORD_SYNC_THREAD_COMM_COUNT_PATTERN.matcher(comm)).matches()) {
                long uSecondsSinceStart = Long.parseLong(matcher.group(1), 10);
                long detectedBase = localClock - uSecondsSinceStart * 1000L;
                @Nullable Long detectedLocalClockBase = this.detectedLocalClockBase;
                if (detectedLocalClockBase == null || UnsignedLong.compare((long)detectedBase, (long)detectedLocalClockBase) < 0) {
                    this.detectedLocalClockBase = detectedBase;
                }
            }
        }
    }

    @Override
    public void trackSwitch(long localClock, int tid) {
    }
}

