/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_one;

import com.arm.streamline.protocol.capture.apc.pass_one.IGatordSyncThreadTracker;
import com.arm.utils.numbers.UnsignedLong;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class GatordLegacySyncThreadTracker
implements IGatordSyncThreadTracker {
    public static final @NonNull String GATORD_SYNC_THREAD_COMM = "gatord-sync";
    private static final long NS = 1000000000L;
    private @Nullable Long commEventLocalClock;
    private @Nullable Long earliestSwitchEventAfterCommEvent = null;
    private @Nullable Integer gatordSyncTid = null;
    private boolean nosync = false;
    private final @NonNull TIntObjectMap<TLongList> switchEventsByTid = new TIntObjectHashMap();

    private static @Nullable Long findEarliestSwitchEventAfterCommEvent(long commEventTimestamp, @Nullable TLongList timestamps) {
        if (timestamps == null || timestamps.isEmpty()) {
            return null;
        }
        Long result = null;
        for (long timestamp : timestamps) {
            if (UnsignedLong.compare((long)commEventTimestamp, (long)timestamp) >= 0 || result != null && UnsignedLong.compare((long)result, (long)timestamp) <= 0) continue;
            result = timestamp;
        }
        return result;
    }

    @Override
    public boolean canCalculateLocalClockBase() {
        @Nullable Integer gatordSyncTid = this.gatordSyncTid;
        if (this.nosync) {
            return true;
        }
        if (gatordSyncTid == null) {
            return false;
        }
        if (this.earliestSwitchEventAfterCommEvent != null) {
            return true;
        }
        if (this.commEventLocalClock != null) {
            return true;
        }
        int tid = gatordSyncTid;
        @Nullable TLongList switchEvents = (TLongList)this.switchEventsByTid.get(tid);
        return switchEvents != null && !switchEvents.isEmpty();
    }

    @Override
    public @Nullable Long getLocalClockBase(long monotonicTime) {
        if (this.nosync) {
            return null;
        }
        @Nullable Integer gatordSyncTid = this.gatordSyncTid;
        if (gatordSyncTid == null) {
            return null;
        }
        @Nullable Long earliestSwitchEventAfterCommEvent = this.earliestSwitchEventAfterCommEvent;
        if (earliestSwitchEventAfterCommEvent != null) {
            return earliestSwitchEventAfterCommEvent - 1000000000L;
        }
        @Nullable Long commEventLocalClock = this.commEventLocalClock;
        if (commEventLocalClock != null) {
            return commEventLocalClock;
        }
        TLongList timestamps = (TLongList)this.switchEventsByTid.get(gatordSyncTid.intValue());
        if (timestamps == null || timestamps.isEmpty()) {
            return null;
        }
        Long result = null;
        for (long timestamp : timestamps) {
            if (result != null && UnsignedLong.compare((long)result, (long)timestamp) <= 0) continue;
            result = timestamp;
        }
        if (result != null) {
            return result - 1000000000L;
        }
        return null;
    }

    public boolean isNoSync() {
        return this.nosync;
    }

    @Override
    public void setNoSync(boolean nosync) {
        if (nosync) {
            this.nosync = true;
            this.gatordSyncTid = null;
            this.switchEventsByTid.clear();
        }
    }

    @Override
    public void trackComm(int tid, @NonNull String comm, @Nullable Long localClock) {
        if (!this.nosync && GATORD_SYNC_THREAD_COMM.equals(comm)) {
            @Nullable Integer gatordSyncTid = this.gatordSyncTid;
            if (gatordSyncTid == null) {
                this.gatordSyncTid = tid;
                this.commEventLocalClock = localClock;
                if (localClock != null) {
                    this.earliestSwitchEventAfterCommEvent = GatordLegacySyncThreadTracker.findEarliestSwitchEventAfterCommEvent(localClock, (TLongList)this.switchEventsByTid.get(tid));
                    this.switchEventsByTid.clear();
                } else {
                    this.switchEventsByTid.retainEntries((k, v) -> k == tid);
                }
            } else if (gatordSyncTid == tid) {
                if (localClock != null) {
                    @Nullable Long previousCommEventLocalClock = this.commEventLocalClock;
                    if (previousCommEventLocalClock == null) {
                        this.commEventLocalClock = localClock;
                        this.earliestSwitchEventAfterCommEvent = GatordLegacySyncThreadTracker.findEarliestSwitchEventAfterCommEvent(localClock, (TLongList)this.switchEventsByTid.get(tid));
                        this.switchEventsByTid.clear();
                    } else if (previousCommEventLocalClock.longValue() != localClock.longValue()) {
                        throw new AssertionError();
                    }
                }
            } else {
                throw new AssertionError();
            }
        }
    }

    @Override
    public void trackSwitch(long localClock, int tid) {
        if (this.nosync) {
            return;
        }
        @Nullable Integer gatordSyncTid = this.gatordSyncTid;
        @Nullable Long commEventLocalClock = this.commEventLocalClock;
        if (gatordSyncTid == null || gatordSyncTid == tid) {
            if (commEventLocalClock != null) {
                assert (gatordSyncTid != null);
                @Nullable Long earliestSwitchEventAfterCommEvent = this.earliestSwitchEventAfterCommEvent;
                if (UnsignedLong.compare((long)commEventLocalClock, (long)localClock) < 0 && (earliestSwitchEventAfterCommEvent == null || UnsignedLong.compare((long)earliestSwitchEventAfterCommEvent, (long)localClock) > 0)) {
                    this.earliestSwitchEventAfterCommEvent = localClock;
                }
            } else {
                TLongList list = (TLongList)this.switchEventsByTid.get(tid);
                if (list == null) {
                    list = new TLongArrayList();
                    this.switchEventsByTid.put(tid, (Object)list);
                }
                list.add(localClock);
            }
        }
    }
}

