/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_one;

import com.arm.streamline.analysis.database.MetadataEntry;
import com.arm.streamline.analysis.database.SummaryWriter;
import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.analysis.model.IVirtualMachineProperties;
import com.arm.streamline.analysis.model.SummaryRecord;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.SpeCaptureRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.protocol.ProtocolException;
import com.arm.streamline.protocol.capture.apc.index.APCFrameAddressIndexTracker;
import com.arm.streamline.protocol.capture.apc.index.IAPCFrameAddressIndexTracker;
import com.arm.streamline.protocol.capture.apc.io.APCFrame;
import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.streamline.protocol.capture.apc.io.APCFrameLoader;
import com.arm.streamline.protocol.capture.apc.pass_one.CookieTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.DelayableFrameConsumerQueue;
import com.arm.streamline.protocol.capture.apc.pass_one.GatorPassOneGlobalStateTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.GatorPassOnePerVirtualMachineProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.pass_one.GatorPassOneProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.pass_one.GatorPassOneTimestampTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.GatordSyncThreadTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IAPCPassOne;
import com.arm.streamline.protocol.capture.apc.pass_one.ICookieTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatorPassOnePerVirtualMachineStateTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatorPassOneTimestampTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatordSyncThreadTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IPassOneGlobalStateNotificationCallbacks;
import com.arm.streamline.protocol.capture.apc.pass_one.ISpeSyncEventTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.SpeSyncEventTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.APCPassTwo;
import com.arm.streamline.protocol.capture.apc.pass_two.ExternalAPCFrameAddress;
import com.arm.streamline.protocol.capture.apc.pass_two.ExternalFramePassTwoIndexGenerator;
import com.arm.streamline.protocol.capture.apc.pass_two.ExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.protocol.DelayProcessingException;
import com.arm.streamline.protocol.capture.apc.protocol.IAPCProtocolVersionPassAdapter;
import com.arm.streamline.protocol.capture.apc.protocol.IGatorProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocols;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolProvider;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfAuxDataBufferTracker;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfProtocolStateTracker;
import com.arm.streamline.protocol.capture.apc.protocol.perf.PerfAttributesTracker;
import com.arm.streamline.protocol.capture.apc.protocol.perf.PerfAuxDataBufferTracker;
import com.arm.streamline.protocol.capture.apc.protocol.v22.APCProtocolPerfV22PassAdapter;
import com.arm.streamline.protocol.capture.apc.time.ITimestampMapper;
import com.arm.streamline.protocol.capture.apc.time.IdentityTimestampMapper;
import com.arm.streamline.protocol.capture.apc.time.TimesyncInformation;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.streamline.protocol.misc.ILinuxKAllSymsSymbolParser;
import com.arm.streamline.protocol.misc.LinuxKAllSymsSymbolParser;
import com.arm.streamline.protocol.misc.StaticCounterSerieses;
import com.arm.streamline.report.model.pe.ProcessingElementDescriptor;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingConsumer;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.IThrowingLongFunction;
import com.arm.utils.function.Throwing;
import gnu.trove.TCollections;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class APCPassOne
implements IAPCPassOne {
    private final @NonNull PerfAuxDataBufferTracker auxBufferTracker;
    private final @NonNull APCFrameAddressIndexTracker frameAddressTracker;
    private final @NonNull GatorPassOneProtocolEventConsumer globalEventConsumer;
    private final @NonNull DelayableFrameConsumerQueue passOneFrameQueue;
    private final @NonNull TLongObjectMap<APCPassOnePerVmState> perVmStateTrackers;
    private final @NonNull ProcessingElementReferenceSet processingElements;
    private final @NonNull IAPCProtocolVersionPassAdapter protocolVersionAdapter;
    private final @NonNull GatorPassOneGlobalStateTracker stateTracker;

    public static @NonNull APCPassOne forPerfProtocolV22(@NonNull IBacktraceSource backtraceSource, @NonNull File dbDirectory, boolean useModernSyncThread, int cpuCount, @NonNull IPassOneGlobalStateNotificationCallbacks callbacks, int protocolVersionNo) {
        @NonNull Supplier<@NonNull IGatordSyncThreadTracker> timesyncFactory = useModernSyncThread ? GatordSyncThreadTracker::modern : GatordSyncThreadTracker::legacy;
        return new APCPassOne(ByteOrder.LITTLE_ENDIAN, dbDirectory, new APCProtocolPerfV22PassAdapter(backtraceSource, protocolVersionNo), new ProcessingElementReferenceSet(0L, cpuCount), callbacks, timesyncFactory, SpeSyncEventTracker::new);
    }

    private APCPassOne(@NonNull ByteOrder byteOrder, @NonNull File dbDirectory, @NonNull IAPCProtocolVersionPassAdapter protocolVersionAdapter, @NonNull ProcessingElementReferenceSet processingElements, @NonNull IPassOneGlobalStateNotificationCallbacks callbacks, @NonNull Supplier<@NonNull IGatordSyncThreadTracker> gatordSyncThreadTrackerFactory, @NonNull Supplier<@NonNull ISpeSyncEventTracker> speSyncEventTrackerFactory) {
        this.protocolVersionAdapter = protocolVersionAdapter;
        this.processingElements = processingElements;
        this.auxBufferTracker = new PerfAuxDataBufferTracker(new File(dbDirectory, "perf-aux-data"));
        try {
            this.perVmStateTrackers = new TLongObjectHashMap(1, 0.5f, 0L);
            this.stateTracker = new GatorPassOneGlobalStateTracker(processingElements, callbacks);
            this.frameAddressTracker = new APCFrameAddressIndexTracker(protocolVersionAdapter.hasMixedCpuPerfFrames(), (IThrowingLongFunction<ITimestampMapper, IOException>)((IThrowingLongFunction)vmUID -> {
                @Nullable APCPassOnePerVmState perVmState = (APCPassOnePerVmState)this.perVmStateTrackers.get(vmUID);
                if (perVmState == null) {
                    throw new AssertionError();
                }
                return perVmState.getTimestampMapper();
            }));
            this.globalEventConsumer = new GatorPassOneProtocolEventConsumer(this.stateTracker, vmUID -> {
                assert (!this.perVmStateTrackers.containsKey(vmUID));
                @NonNull IGatordSyncThreadTracker gatordSyncThreadTracker = (IGatordSyncThreadTracker)gatordSyncThreadTrackerFactory.get();
                @NonNull ISpeSyncEventTracker speSyncEventTracker = (ISpeSyncEventTracker)speSyncEventTrackerFactory.get();
                @NonNull APCPassOnePerVmState perVmState = new APCPassOnePerVmState(vmUID, this.frameAddressTracker, gatordSyncThreadTracker, speSyncEventTracker, this.auxBufferTracker);
                this.perVmStateTrackers.put(vmUID, (Object)perVmState);
                return new GatorPassOnePerVirtualMachineProtocolEventConsumer(vmUID, byteOrder, this.stateTracker, perVmState, perVmState.timestampTracker, perVmState.perfAttributesTracker, perVmState.cookieTracker, perVmState.kallsymsTracker);
            });
            this.passOneFrameQueue = new DelayableFrameConsumerQueue((IThrowingConsumer<APCFrame, IOException>)((IThrowingConsumer)frame -> protocolVersionAdapter.process((IGatorProtocolEventConsumer)this.globalEventConsumer, frame.address, frame.data)));
        }
        catch (Throwable t) {
            try {
                this.auxBufferTracker.close();
            }
            catch (Throwable e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    @Override
    public void close() throws IOException {
        Throwing.closeAll((Closeable[])new Closeable[]{this.auxBufferTracker, this.globalEventConsumer});
    }

    @Override
    public void consumeNextFrame(@NonNull APCFrame frame) throws IOException {
        this.passOneFrameQueue.consumeNextFrame(frame);
    }

    public final @NonNull APCPassTwo createPassTwo(@NonNull File dbDirectory, @NonNull String captureName, boolean generateSpeSampleLog, boolean alwaysSupportMultipleClusterRewrite, boolean filterPerVmEbsCounters, @NonNull DeviceTypeCalculator deviceTypeCalculator, @NonNull Set<@NonNull SpeCaptureRecord> speCaptureRecords, @NonNull List<@NonNull CounterRecord> staticCounterRecords, @NonNull IClustersInfo clustersInfo, @NonNull IWarnings warnings, boolean hasGpuCores, boolean isAtraceEnabled, @NonNull AttachedApkEntries attachedApkEntries) throws IOException {
        @NonNull SortedMap<@NonNull ExternalProtocolChannel, @NonNull ExternalAPCFrameAddress @NonNull []> timestampedExternalIndex = this.generateExternalFrameIndex(this.frameAddressTracker.createExternalMessages(), new StaticCounterSerieses(staticCounterRecords, (TIntObjectMap<String>)clustersInfo.getClusterNames(), speCaptureRecords), ExternalProtocols::get, isAtraceEnabled);
        long duration = this.writeSummaryText(dbDirectory);
        @NonNull TLongObjectMap perVmStateTrackers = TCollections.unmodifiableMap(this.perVmStateTrackers);
        return new APCPassTwo(dbDirectory, captureName, alwaysSupportMultipleClusterRewrite, this.stateTracker.hasApplicationTracingMode(), generateSpeSampleLog, filterPerVmEbsCounters, duration, deviceTypeCalculator, speCaptureRecords, staticCounterRecords, this.processingElements, this.stateTracker.getProcessingElementProperties(), clustersInfo, (TLongObjectMap<APCPassOnePerVmState>)perVmStateTrackers, this.frameAddressTracker, this.protocolVersionAdapter, ExternalProtocols::get, warnings, attachedApkEntries, isAtraceEnabled, timestampedExternalIndex);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull SortedMap<@NonNull ExternalProtocolChannel, @NonNull ExternalAPCFrameAddress @NonNull []> generateExternalFrameIndex(@NonNull SortedMap<@NonNull ExternalProtocolChannel, @NonNull List<@NonNull APCFrameAddress>> externalIndex, @NonNull StaticCounterSerieses staticCounterSerieses, @NonNull IExternalProtocolProvider externalProtocolProvider, boolean isAtraceEnabled) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (APCFrameLoader loader = new APCFrameLoader();){
            @NonNull TLongObjectHashMap externalProtocolStates = new TLongObjectHashMap();
            @NonNull @NonNull IThrowingLongFunction stateProvider = arg_0 -> this.lambda$8((TLongObjectMap)externalProtocolStates, staticCounterSerieses, arg_0);
            @NonNull ExternalFramePassTwoIndexGenerator externalFrameIndexer = new ExternalFramePassTwoIndexGenerator(externalProtocolProvider, (IThrowingFunction<APCFrameAddress, byte[], IOException>)((IThrowingFunction)loader::load), (IThrowingLongFunction<IExternalProtocolPassTwoState, IOException>)stateProvider);
            SortedMap<ExternalProtocolChannel, IThrowingFunction<ITimestampMapper, ExternalAPCFrameAddress[], DelayProcessingException>> mappers = externalFrameIndexer.forAll(externalIndex, vmUID -> {
                GatorPassOnePerVirtualMachineProtocolEventConsumer vm = this.globalEventConsumer.getVm(vmUID);
                APCPassOnePerVmState vmState = (APCPassOnePerVmState)NullChecking.neverNull((Object)((APCPassOnePerVmState)this.perVmStateTrackers.get(vmUID)));
                return (c, t) -> aPCPassOnePerVmState.timestampTracker.updateTimeRange(c, t);
            }, (IThrowingConsumer<ExternalProtocolChannel, IOException>)((IThrowingConsumer)arg_0 -> APCPassOne.lambda$11((TLongObjectMap)externalProtocolStates, arg_0)), isAtraceEnabled);
            @NonNull TreeMap<@NonNull ExternalProtocolChannel, @NonNull ExternalAPCFrameAddress @NonNull []> result = new TreeMap<ExternalProtocolChannel, ExternalAPCFrameAddress[]>();
            for (Map.Entry<ExternalProtocolChannel, IThrowingFunction<ITimestampMapper, ExternalAPCFrameAddress[], DelayProcessingException>> e : mappers.entrySet()) {
                APCPassOnePerVmState s = (APCPassOnePerVmState)NullChecking.neverNull((Object)((APCPassOnePerVmState)this.perVmStateTrackers.get(e.getKey().vmUID)));
                ITimestampMapper m = s.getTimestampMapper();
                ExternalAPCFrameAddress[] r = (ExternalAPCFrameAddress[])e.getValue().apply((Object)m);
                if (r == null) continue;
                result.put(e.getKey(), r);
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void flushDelayedFrames() throws IOException {
        this.passOneFrameQueue.flushDelayedFrames();
    }

    private final long writeSummaryText(@NonNull File apcPath) throws IOException {
        apcPath.mkdirs();
        long latestAbsoluteTimestamp = -1L;
        long earliestAbsoluteTimestamp = -1L;
        @Nullable SummaryRecord summary = this.stateTracker.getGlobalSummary();
        Set<MetadataEntry> metadata = this.stateTracker.getMetadata();
        @NonNull Map<@NonNull String, @NonNull String> globalAttributes = this.stateTracker.getGlobalAttributes();
        @NonNull TLongObjectMap<Map<@NonNull String, @NonNull String>> perVmAttributes = this.stateTracker.getVmAttributes();
        @NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> processingElementProperties = this.stateTracker.getProcessingElementProperties();
        TLongObjectIterator it = this.perVmStateTrackers.iterator();
        while (it.hasNext()) {
            it.advance();
            @NonNull TimesyncInformation timesyncInformation = ((APCPassOnePerVmState)it.value()).getTimesyncInformation();
            long duration = timesyncInformation.duration;
            if (latestAbsoluteTimestamp >= 0L && latestAbsoluteTimestamp >= duration) continue;
            latestAbsoluteTimestamp = duration;
        }
        SummaryWriter.write((File)apcPath, (long)(latestAbsoluteTimestamp - earliestAbsoluteTimestamp), (SummaryRecord)summary, globalAttributes, perVmAttributes, processingElementProperties, metadata);
        return latestAbsoluteTimestamp;
    }

    private /* synthetic */ IExternalProtocolPassTwoState lambda$8(TLongObjectMap tLongObjectMap, StaticCounterSerieses staticCounterSerieses, long vmUID) throws IOException {
        ExternalProtocolPassTwoState state = (ExternalProtocolPassTwoState)tLongObjectMap.get(vmUID);
        if (state == null) {
            GatorPassOnePerVirtualMachineProtocolEventConsumer vm = this.globalEventConsumer.getVm(vmUID);
            APCPassOnePerVmState vmState = (APCPassOnePerVmState)NullChecking.neverNull((Object)((APCPassOnePerVmState)this.perVmStateTrackers.get(vmUID)));
            state = new ExternalProtocolPassTwoState(vmUID, new IdentityTimestampMapper(), vmState.perfAttributesTracker, this.processingElements, staticCounterSerieses);
            tLongObjectMap.put(vmUID, (Object)state);
        }
        return state;
    }

    private static /* synthetic */ void lambda$11(TLongObjectMap tLongObjectMap, ExternalProtocolChannel efc) throws IOException {
        @Nullable ExternalProtocolPassTwoState state = (ExternalProtocolPassTwoState)tLongObjectMap.remove(efc.vmUID);
        if (state != null) {
            state.close();
        }
    }

    public static class APCPassOnePerVmState
    implements IGatorPassOnePerVirtualMachineStateTracker {
        protected final @NonNull CookieTracker cookieTracker;
        protected final @NonNull ILinuxKAllSymsSymbolParser kallsymsTracker;
        protected final @NonNull PerfAttributesTracker perfAttributesTracker;
        protected final @NonNull GatorPassOneTimestampTracker timestampTracker;
        private boolean applicationTracingMode;
        private @Nullable TimesyncInformation timestampMapper;
        private @Nullable String vmName;

        public APCPassOnePerVmState(long vmUID, @NonNull IAPCFrameAddressIndexTracker frameIndex, @NonNull IGatordSyncThreadTracker gatordSyncThreadTracker, @NonNull ISpeSyncEventTracker speSyncEventTracker, @NonNull IPerfAuxDataBufferTracker auxBufferTracker) {
            this.timestampTracker = new GatorPassOneTimestampTracker(vmUID, frameIndex, gatordSyncThreadTracker, speSyncEventTracker);
            this.perfAttributesTracker = new PerfAttributesTracker(vmUID, auxBufferTracker);
            this.cookieTracker = new CookieTracker();
            this.kallsymsTracker = new LinuxKAllSymsSymbolParser();
        }

        public @NonNull ICookieTracker getCookieTracker() {
            return this.cookieTracker;
        }

        public @NonNull ILinuxKAllSymsSymbolParser getKallsymsTracker() {
            return this.kallsymsTracker;
        }

        public @NonNull IPerfProtocolStateTracker getPerfProtocolStateTracker() {
            return this.perfAttributesTracker;
        }

        public @NonNull ITimestampMapper getTimestampMapper() throws ProtocolException {
            return this.getTimesyncInformation();
        }

        public @NonNull IGatorPassOneTimestampTracker getTimestampTracker() {
            return this.timestampTracker;
        }

        public @NonNull IVirtualMachineProperties getVirtualMachineProperties() throws ProtocolException {
            final @NonNull TimesyncInformation timesyncInformation = this.getTimesyncInformation();
            return new IVirtualMachineProperties(){

                public long getDuration() {
                    return timesyncInformation.duration;
                }

                public long getMonotonicRawBase() {
                    return timesyncInformation.monotonicRawBase + timesyncInformation.earliestMonotonicDelta;
                }

                public @Nullable String getVmName() {
                    return this.getVmName();
                }

                public boolean isAnyTimesSeen() {
                    return timesyncInformation.duration > 0L;
                }

                public boolean isApplicationTracingMode() {
                    return this.isApplicationTracingMode();
                }
            };
        }

        public @Nullable String getVmName() {
            return this.vmName;
        }

        public boolean isApplicationTracingMode() {
            return this.applicationTracingMode;
        }

        @Override
        public void setApplicationTracingMode(boolean applicationTracingMode) {
            this.applicationTracingMode = applicationTracingMode;
        }

        @Override
        public void setVmName(@NonNull String name) {
            this.vmName = name;
        }

        protected @NonNull TimesyncInformation getTimesyncInformation() throws ProtocolException {
            TimesyncInformation timestampMapper = this.timestampMapper;
            if (timestampMapper == null) {
                this.timestampMapper = timestampMapper = this.timestampTracker.getTimesyncInformation();
            }
            return timestampMapper;
        }
    }
}

