/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.live;

import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.KernelSymbol;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.SpeCaptureRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.protocol.capture.apc.io.APCFrame;
import com.arm.streamline.protocol.capture.apc.live.ILiveOutputStreamFactory;
import com.arm.streamline.protocol.capture.apc.live.LiveAPCEventQueue;
import com.arm.streamline.protocol.capture.apc.live.LiveExternalProtocolChannelFrameDataQueue;
import com.arm.streamline.protocol.capture.apc.live.LiveGatorPassOneTimestampTracker;
import com.arm.streamline.protocol.capture.apc.live.LiveGatorPassTwoPerVirtualMachineProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.pass_one.CookieTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.DelayableFrameConsumerQueue;
import com.arm.streamline.protocol.capture.apc.pass_one.GatorPassOneGlobalStateTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.GatorPassOnePerVirtualMachineProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.pass_one.GatorPassOneProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.pass_one.GatordSyncThreadTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IAPCPassOne;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatorPassOnePerVirtualMachineStateTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatordSyncThreadTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IPassOneGlobalStateNotificationCallbacks;
import com.arm.streamline.protocol.capture.apc.pass_one.ISpeSyncEventTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.SpeSyncEventTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.ExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoEventStream;
import com.arm.streamline.protocol.capture.apc.pass_two.KernelTracepointProcessor;
import com.arm.streamline.protocol.capture.apc.pass_two.MaliUserspaceSoftwareCounters;
import com.arm.streamline.protocol.capture.apc.pass_two.PerfDataBufferPassTwoEventConsumer;
import com.arm.streamline.protocol.capture.apc.pass_two.event_queue.GatorPassTwoQueueingEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.IAPCProtocolVersionPassAdapter;
import com.arm.streamline.protocol.capture.apc.protocol.IGatorPerVirtualMachineProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.IGatorProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolMessageProperties;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocols;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.protocol.external.TimestampMappingExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfAuxDataBufferTracker;
import com.arm.streamline.protocol.capture.apc.protocol.perf.PerfAttributesTracker;
import com.arm.streamline.protocol.capture.apc.protocol.perf.PerfDataBufferPassProcessor;
import com.arm.streamline.protocol.capture.apc.protocol.v22.APCProtocolPerfV22PassAdapter;
import com.arm.streamline.protocol.misc.IDeviceNumberToClusterNumber;
import com.arm.streamline.protocol.misc.ILinuxKAllSymsSymbolParser;
import com.arm.streamline.protocol.misc.StaticCounterSerieses;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.spe.decoders.SpeDecoder;
import com.arm.utils.MapUtils;
import com.arm.utils.collections.Pair;
import com.arm.utils.function.IThrowingConsumer;
import com.arm.utils.function.IThrowingLongFunction;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class LiveAPCPassOne
implements IAPCPassOne,
LiveGatorPassTwoPerVirtualMachineProtocolEventConsumer.IExternalMessageConsumer {
    protected final @NonNull ByteOrder byteOrder;
    protected final @NonNull IDeviceNumberToClusterNumber clusterMapper;
    protected final @NonNull ProcessingElementReferenceSet peReferenceSet;
    protected final @NonNull TLongObjectMap<APCPassOnePerVmState> perVmStateTrackers = new TLongObjectHashMap(1, 0.5f, 0L);
    protected final @NonNull StaticCounterSerieses staticCounterSerieses;
    private final @NonNull Map<@NonNull ExternalProtocolChannel, @NonNull LiveExternalProtocolChannelFrameDataQueue> externalMessageQueues = new HashMap<ExternalProtocolChannel, LiveExternalProtocolChannelFrameDataQueue>();
    private final @NonNull DelayableFrameConsumerQueue passOneFrameQueue;
    private final @NonNull DelayableFrameConsumerQueue passTwoFrameQueue;
    private final @NonNull GatorPassOneProtocolEventConsumer passOneEventConsumer;
    final boolean hasMaxGpusCoresSpecified;
    final boolean isAtraceEnabled;
    private final @NonNull LiveGatorPassTwoProtocolEventConsumer passTwoEventConsumer;

    public static @NonNull LiveAPCPassOne forPerfProtocolV22(@NonNull IBacktraceSource ebsBacktraceSource, boolean useModernSyncThread, int cpuCount, @NonNull Set<@NonNull SpeCaptureRecord> speCaptureRecords, @NonNull List<@NonNull CounterRecord> staticCounterRecords, @NonNull IClustersInfo clusterInfo, @NonNull ILiveOutputStreamFactory outputFactory, @NonNull IPassOneGlobalStateNotificationCallbacks callbacks, boolean hasMaxNumGpusSpecified, boolean isAtraceEnabled, int protocolVersionNo) {
        @NonNull Supplier<@NonNull IGatordSyncThreadTracker> timesyncFactory = useModernSyncThread ? GatordSyncThreadTracker::modern : GatordSyncThreadTracker::legacy;
        return new LiveAPCPassOne(ByteOrder.LITTLE_ENDIAN, new APCProtocolPerfV22PassAdapter(ebsBacktraceSource, protocolVersionNo), new ProcessingElementReferenceSet(0L, cpuCount), callbacks, timesyncFactory, SpeSyncEventTracker::new, speCaptureRecords, staticCounterRecords, clusterInfo, outputFactory, hasMaxNumGpusSpecified, isAtraceEnabled);
    }

    private LiveAPCPassOne(@NonNull ByteOrder byteOrder, @NonNull IAPCProtocolVersionPassAdapter protocolVersionAdapter, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull IPassOneGlobalStateNotificationCallbacks callbacks, @NonNull Supplier<@NonNull IGatordSyncThreadTracker> syncThreadTrackerSupplier, @NonNull Supplier<@NonNull ISpeSyncEventTracker> speSyncEventTrackerSupplier, @NonNull Set<@NonNull SpeCaptureRecord> speCaptureRecords, @NonNull List<@NonNull CounterRecord> staticCounterRecords, @NonNull IClustersInfo clusterInfo, @NonNull ILiveOutputStreamFactory outputFactory, boolean hasMaxGpusCoresSpecified, boolean isAtraceEnabled) {
        this.byteOrder = byteOrder;
        this.peReferenceSet = peReferenceSet;
        this.hasMaxGpusCoresSpecified = hasMaxGpusCoresSpecified;
        this.isAtraceEnabled = isAtraceEnabled;
        this.staticCounterSerieses = new StaticCounterSerieses(staticCounterRecords, (TIntObjectMap<String>)clusterInfo.getClusterNames(), speCaptureRecords);
        this.clusterMapper = clusterInfo.hasClusters() ? (vmUID, deviceNumber) -> {
            assert (vmUID == 0L);
            assert (deviceNumber >= 0);
            return clusterInfo.getClusterIndex(deviceNumber);
        } : (vmUID, deviceNumber) -> 0;
        @NonNull GatorPassOneGlobalStateTracker stateTracker = new GatorPassOneGlobalStateTracker(peReferenceSet, callbacks);
        this.passOneEventConsumer = new GatorPassOneProtocolEventConsumer(stateTracker, vmUID -> {
            assert (!this.perVmStateTrackers.containsKey(vmUID));
            @NonNull APCPassOnePerVmState perVmState = new APCPassOnePerVmState(vmUID, (IGatordSyncThreadTracker)syncThreadTrackerSupplier.get(), (ISpeSyncEventTracker)speSyncEventTrackerSupplier.get(), peReferenceSet, this.staticCounterSerieses);
            this.perVmStateTrackers.put(vmUID, (Object)perVmState);
            return new GatorPassOnePerVirtualMachineProtocolEventConsumer(vmUID, byteOrder, stateTracker, perVmState, perVmState.timestampTracker, perVmState.perfAttributesTracker, perVmState.cookieTracker, perVmState.kallsymsTracker);
        });
        this.passTwoEventConsumer = new LiveGatorPassTwoProtocolEventConsumer(outputFactory);
        this.passTwoFrameQueue = new DelayableFrameConsumerQueue((IThrowingConsumer<APCFrame, IOException>)((IThrowingConsumer)frame -> {
            protocolVersionAdapter.process((IGatorProtocolEventConsumer)this.passTwoEventConsumer, frame.address, frame.data);
            this.processExternalFrameQueues();
        }));
        this.passOneFrameQueue = new DelayableFrameConsumerQueue((IThrowingConsumer<APCFrame, IOException>)((IThrowingConsumer)frame -> {
            protocolVersionAdapter.process((IGatorProtocolEventConsumer)this.passOneEventConsumer, frame.address, frame.data);
            this.passTwoFrameQueue.consumeNextFrame((APCFrame)frame);
        }));
    }

    @Override
    public void addExternalFrameMessage(@NonNull ExternalProtocolMessageProperties externalMessageProperties, byte @NonNull [] frameData) throws IOException {
        @NonNull LiveExternalProtocolChannelFrameDataQueue queue = (LiveExternalProtocolChannelFrameDataQueue)MapUtils.computeIfAbsentThrows(this.externalMessageQueues, (Object)externalMessageProperties.channel, this::createExternalChannelQueue);
        int offset = frameData.length - externalMessageProperties.length;
        if (offset == 0) {
            queue.append(frameData);
        } else {
            byte @NonNull [] messageData = new byte[externalMessageProperties.length];
            System.arraycopy(frameData, offset, messageData, 0, messageData.length);
            queue.append(messageData);
        }
    }

    @Override
    public void close() throws IOException {
        ArrayList<LiveExternalProtocolChannelFrameDataQueue> closeables = new ArrayList<LiveExternalProtocolChannelFrameDataQueue>(this.externalMessageQueues.values());
        closeables.add((LiveExternalProtocolChannelFrameDataQueue)((Object)this.passOneEventConsumer));
        Throwing.closeAll((Iterable[])new Iterable[]{closeables});
    }

    @Override
    public void closeExternalFrameChannel(@NonNull ExternalProtocolChannel channel) {
        @Nullable LiveExternalProtocolChannelFrameDataQueue queue = this.externalMessageQueues.get(channel);
        if (queue != null) {
            queue.setClosed();
        }
    }

    @Override
    public void consumeNextFrame(@NonNull APCFrame frame) throws IOException {
        this.passOneFrameQueue.consumeNextFrame(frame);
        this.processExternalFrameQueues();
    }

    @Override
    public void flushDelayedFrames() throws IOException {
        this.passOneFrameQueue.flushDelayedFrames();
        this.passTwoFrameQueue.flushDelayedFrames();
        this.processExternalFrameQueues();
        for (LiveAPCEventQueue liveEventQueue : this.passTwoEventConsumer.liveEventQueues) {
            liveEventQueue.flushAll();
        }
    }

    private @NonNull LiveExternalProtocolChannelFrameDataQueue createExternalChannelQueue(@NonNull ExternalProtocolChannel channel) throws IOException {
        return new LiveExternalProtocolChannelFrameDataQueue(channel, ExternalProtocols::get, (IThrowingLongFunction<IExternalProtocolPassTwoState, IOException>)((IThrowingLongFunction)this::getExternalStateObject), (IThrowingLongFunction<IExternalProtocolEventStream, IOException>)((IThrowingLongFunction)this::getExternalOutputObject), this.isAtraceEnabled);
    }

    private @NonNull IExternalProtocolEventStream getExternalOutputObject(long vmUID) throws IOException {
        @Nullable APCPassOnePerVmState perVmState = (APCPassOnePerVmState)this.perVmStateTrackers.get(vmUID);
        if (perVmState == null) {
            throw new AssertionError();
        }
        IGatorPassTwoEventStream outputStream = this.passTwoEventConsumer.getOutputStream(vmUID);
        return new TimestampMappingExternalProtocolEventStream(perVmState.timestampTracker, outputStream);
    }

    private @NonNull IExternalProtocolPassTwoState getExternalStateObject(long vmUID) {
        @Nullable APCPassOnePerVmState perVmState = (APCPassOnePerVmState)this.perVmStateTrackers.get(vmUID);
        if (perVmState == null) {
            throw new AssertionError();
        }
        return perVmState.externalProtocolPassTwoState;
    }

    private void processExternalFrameQueues() throws IOException {
        Iterator<@NonNull LiveExternalProtocolChannelFrameDataQueue> it = this.externalMessageQueues.values().iterator();
        while (it.hasNext()) {
            @NonNull LiveExternalProtocolChannelFrameDataQueue queue = it.next();
            queue.processExternalFrameQueue();
            if (!queue.isComplete()) continue;
            queue.close();
            it.remove();
        }
    }

    public static final class APCPassOnePerVmState
    implements IGatorPassOnePerVirtualMachineStateTracker {
        protected boolean applicationTracingMode;
        protected final @NonNull CookieTracker cookieTracker;
        protected final @NonNull IExternalProtocolPassTwoState externalProtocolPassTwoState;
        protected final @NonNull ILinuxKAllSymsSymbolParser kallsymsTracker;
        protected final @NonNull PerfAttributesTracker perfAttributesTracker;
        protected final @NonNull LiveGatorPassOneTimestampTracker timestampTracker;

        public APCPassOnePerVmState(long vmUID, @NonNull IGatordSyncThreadTracker syncThreadTracker, @NonNull ISpeSyncEventTracker speSyncEventTracker, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull StaticCounterSerieses staticCounterSerieses) {
            this.perfAttributesTracker = new PerfAttributesTracker(vmUID, IPerfAuxDataBufferTracker.NO_OP_AUX_BUFFER_TRACKER);
            this.cookieTracker = new CookieTracker();
            this.kallsymsTracker = new ILinuxKAllSymsSymbolParser(){

                @Override
                public void append(@NonNull String text) {
                }

                @Override
                public @NonNull List<@NonNull KernelSymbol> getAllSymbols() {
                    return Collections.emptyList();
                }
            };
            this.timestampTracker = new LiveGatorPassOneTimestampTracker(syncThreadTracker, speSyncEventTracker);
            this.externalProtocolPassTwoState = new ExternalProtocolPassTwoState(vmUID, this.timestampTracker, this.perfAttributesTracker, peReferenceSet, staticCounterSerieses);
        }

        @Override
        public void setApplicationTracingMode(boolean applicationTracingMode) {
            this.applicationTracingMode = applicationTracingMode;
        }

        @Override
        public void setVmName(@NonNull String name) {
        }
    }

    public class LiveGatorPassTwoProtocolEventConsumer
    implements IGatorProtocolEventConsumer {
        private final @NonNull Set<@NonNull LiveAPCEventQueue> liveEventQueues = new HashSet<LiveAPCEventQueue>();
        private final @NonNull ILiveOutputStreamFactory outputFactory;
        private final @NonNull TLongObjectMap<Pair<@NonNull IGatorPerVirtualMachineProtocolEventConsumer, @NonNull IGatorPassTwoEventStream>> vmEventConsumers = new TLongObjectHashMap(1, 0.5f, 0L);

        public LiveGatorPassTwoProtocolEventConsumer(ILiveOutputStreamFactory outputFactory) {
            this.outputFactory = outputFactory;
        }

        @Override
        public @NonNull IGatorPerVirtualMachineProtocolEventConsumer getVm(long vmUID) throws IOException {
            Pair<IGatorPerVirtualMachineProtocolEventConsumer, IGatorPassTwoEventStream> result = this.getVmConsumerAndStream(vmUID);
            return (IGatorPerVirtualMachineProtocolEventConsumer)result.first;
        }

        @Override
        public void globalSummary(long wallClockTime, @NonNull Map<@NonNull String, @NonNull String> attributes) {
        }

        public @NonNull IGatorPassTwoEventStream getOutputStream(long vmUID) throws IOException {
            Pair<IGatorPerVirtualMachineProtocolEventConsumer, IGatorPassTwoEventStream> result = this.getVmConsumerAndStream(vmUID);
            return (IGatorPassTwoEventStream)result.second;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private @NonNull Pair<@NonNull IGatorPerVirtualMachineProtocolEventConsumer, @NonNull IGatorPassTwoEventStream> getVmConsumerAndStream(long vmUID) throws IOException {
            Pair result = (Pair)this.vmEventConsumers.get(vmUID);
            if (result == null) {
                @Nullable APCPassOnePerVmState passOneStateTracker = (APCPassOnePerVmState)LiveAPCPassOne.this.perVmStateTrackers.get(vmUID);
                if (passOneStateTracker == null) {
                    throw new AssertionError();
                }
                @NonNull IntPredicate isSpeKey = key -> LiveAPCPassOne.this.staticCounterSerieses.getSpeCaptureRecordByKey(key) != null;
                @NonNull IntFunction<@Nullable ICounterSeriesKey> cpuFrequencyTracepointKeyProvider = deviceNumber -> {
                    int clusterNumber = LiveAPCPassOne.this.clusterMapper.map(vmUID, deviceNumber);
                    return LiveAPCPassOne.this.staticCounterSerieses.getLinuxPowerCpuFreq(clusterNumber);
                };
                @NonNull IGatorPassTwoEventStream sortedEventStream = this.outputFactory.createOutputStream(vmUID, passOneStateTracker.cookieTracker, passOneStateTracker.applicationTracingMode);
                @NonNull LiveAPCEventQueue liveEventQueue = new LiveAPCEventQueue(sortedEventStream);
                this.liveEventQueues.add(liveEventQueue);
                @NonNull GatorPassTwoQueueingEventStream output = new GatorPassTwoQueueingEventStream(sortedEventStream, liveEventQueue, new LongSupplier(){
                    private long counter = 0L;

                    @Override
                    public long getAsLong() {
                        return this.counter++;
                    }
                });
                @NonNull PerfDataBufferPassProcessor perfDataBufferPassProcessor = new PerfDataBufferPassProcessor(LiveAPCPassOne.this.byteOrder, passOneStateTracker.perfAttributesTracker);
                @NonNull IntFunction<@Nullable ICounterSeriesKey> counterSeriesFunction = LiveAPCPassOne.this.staticCounterSerieses::getStaticCounterRecordByKey;
                @NonNull Function<@NonNull String, @Nullable ICounterSeriesKey> tracepointCounterMapper = LiveAPCPassOne.this.staticCounterSerieses::getTracepointCounterSeriesKeyByName;
                @NonNull MaliUserspaceSoftwareCounters maliUserspaceSoftwareCounters = new MaliUserspaceSoftwareCounters(vmUID, LiveAPCPassOne.this.staticCounterSerieses, LiveAPCPassOne.this.peReferenceSet, output);
                KernelTracepointProcessor kernelTracepointProcessor = new KernelTracepointProcessor(vmUID, output, LiveAPCPassOne.this.peReferenceSet);
                boolean allowArbitraryEbsBacktraceSources = false;
                @NonNull @NonNull PerfDataBufferPassTwoEventConsumer perfDataBufferPassTwoEventConsumer = new PerfDataBufferPassTwoEventConsumer(vmUID, passOneStateTracker.applicationTracingMode, passOneStateTracker.perfAttributesTracker, passOneStateTracker.timestampTracker, LiveAPCPassOne.this.peReferenceSet, counterSeriesFunction, cpuFrequencyTracepointKeyProvider, tracepointCounterMapper, maliUserspaceSoftwareCounters, kernelTracepointProcessor, isSpeKey, SpeDecoder::decode, true, false, output);
                LiveGatorPassTwoPerVirtualMachineProtocolEventConsumer consumer = new LiveGatorPassTwoPerVirtualMachineProtocolEventConsumer(vmUID, LiveAPCPassOne.this.peReferenceSet, counterSeriesFunction, passOneStateTracker.timestampTracker, passOneStateTracker.perfAttributesTracker, perfDataBufferPassProcessor, perfDataBufferPassTwoEventConsumer, output, LiveAPCPassOne.this);
                result = new Pair((Object)consumer, (Object)output);
                this.vmEventConsumers.put(vmUID, (Object)result);
            }
            return result;
        }
    }
}

