/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.io;

import com.arm.streamline.protocol.ProtocolException;
import com.arm.streamline.protocol.capture.apc.APCFile;
import com.arm.streamline.protocol.capture.apc.io.APCFrame;
import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.utils.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;

public class APCCaptureFileFrameStream
implements Closeable {
    private final @NonNull InputStream inputStream;
    private final @NonNull ByteBuffer lengthBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
    private final @NonNull APCFile sourceFile;
    private long streamOffset;

    public APCCaptureFileFrameStream(@NonNull APCFile dataFile) throws IOException {
        if (!dataFile.file.isFile() || !dataFile.file.canRead()) {
            throw new IllegalArgumentException(dataFile.file.getAbsolutePath() + " is not a readable file");
        }
        this.sourceFile = dataFile;
        this.streamOffset = 0L;
        this.inputStream = FileUtils.wrapFileInputStream((File)dataFile.file, BufferedInputStream::new);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public @NonNull APCFrame nextFrame() throws IOException {
        try {
            int bytesRead = this.inputStream.read(this.lengthBuffer.array());
            if (bytesRead < 0) {
                throw new EOFException();
            }
            if (bytesRead != this.lengthBuffer.capacity()) {
                throw new ProtocolException(ProtocolException.Reason.FAILED_TO_READ_FRAME_LENGTH);
            }
            this.streamOffset += (long)this.lengthBuffer.capacity();
            int length = this.lengthBuffer.getInt(0);
            byte[] data = new byte[length];
            if (this.inputStream.read(data) != data.length) {
                throw new ProtocolException(ProtocolException.Reason.FAILED_TO_READ_FRAME_CONTENTS);
            }
            long offset = this.streamOffset;
            this.streamOffset += (long)data.length;
            return new APCFrame(new APCFrameAddress(this.sourceFile, offset, data.length), data);
        }
        catch (Throwable t) {
            try {
                this.inputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw t;
        }
    }
}

