/*
 * Decompiled with CFR 0.152.
 */
package com.arm.rosetta;

import com.arm.rosetta.NativeCallbackData;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public final class NativeCallbacks
extends Structure {
    public Pointer ctx;
    public ILabelCallback branch;
    public IPcRelLoadStoreCallback pcLoadStore;
    public ILabelCallback adr;
    public IArchSubsetCallback archSubset;

    public List<String> getFieldOrder() {
        return Arrays.asList("ctx", "branch", "pcLoadStore", "adr", "archSubset");
    }

    private static final Pointer getPtrToString(String s, Pointer bufPtr, int bufSize) {
        int index;
        if (s == null) {
            return null;
        }
        byte[] bytes = s.getBytes();
        for (index = 0; index < bytes.length && index < bufSize - 1; ++index) {
            bufPtr.setByte((long)index, bytes[index]);
        }
        bufPtr.setByte((long)index, (byte)0);
        return bufPtr;
    }

    public static abstract class PcRelLoadStoreCallback
    implements IPcRelLoadStoreCallback {
        private final int bufSize;

        public PcRelLoadStoreCallback(int bufSize) {
            this.bufSize = bufSize;
        }

        @Override
        public Pointer callback(Pointer data, int size, int store, long offset) {
            NativeCallbackData cd = new NativeCallbackData(data);
            cd.read();
            String s = this.resolveData(cd.pc + offset, size, offset, store != 0);
            return NativeCallbacks.getPtrToString(s, cd.ctx, this.bufSize);
        }

        protected abstract String resolveData(long var1, int var3, long var4, boolean var6);
    }

    public static abstract class LabelCallback
    implements ILabelCallback {
        private final int bufSize;

        public LabelCallback(int bufSize) {
            this.bufSize = bufSize;
        }

        @Override
        public Pointer callback(Pointer data, long offset) {
            NativeCallbackData cd = new NativeCallbackData(data);
            cd.read();
            String s = this.resolveLabel(cd.pc + offset);
            return NativeCallbacks.getPtrToString(s, cd.ctx, this.bufSize);
        }

        protected abstract String resolveLabel(long var1);
    }

    public static interface IArchSubsetCallback
    extends Callback {
        public int callback(Pointer var1, int var2);
    }

    public static interface IPcRelLoadStoreCallback
    extends Callback {
        public Pointer callback(Pointer var1, int var2, int var3, long var4);
    }

    public static interface ILabelCallback
    extends Callback {
        public Pointer callback(Pointer var1, long var2);
    }
}

