/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.icodec.swig;

import com.arm.debug.icodec.swig.AsmInstruction;
import com.arm.debug.icodec.swig.AsmLabel;
import com.arm.debug.icodec.swig.AsmOperand;
import com.arm.debug.icodec.swig.SWIGTYPE_p_void;
import com.arm.debug.icodec.swig.SWIGicodecJNI;

public class MemoryAllocator {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected MemoryAllocator(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MemoryAllocator obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SWIGicodecJNI.delete_MemoryAllocator(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public SWIGTYPE_p_void allocBytes(long n) {
        long cPtr = SWIGicodecJNI.MemoryAllocator_allocBytes(this.swigCPtr, this, n);
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public AsmInstruction allocAsmInstruction() {
        long cPtr = SWIGicodecJNI.MemoryAllocator_allocAsmInstruction(this.swigCPtr, this);
        return cPtr == 0L ? null : new AsmInstruction(cPtr, false);
    }

    public AsmLabel allocAsmLabel() {
        long cPtr = SWIGicodecJNI.MemoryAllocator_allocAsmLabel(this.swigCPtr, this);
        return cPtr == 0L ? null : new AsmLabel(cPtr, false);
    }

    public AsmOperand allocAsmOperand(long n) {
        long cPtr = SWIGicodecJNI.MemoryAllocator_allocAsmOperand(this.swigCPtr, this, n);
        return cPtr == 0L ? null : new AsmOperand(cPtr, false);
    }

    public void deallocBytes(SWIGTYPE_p_void x, long n) {
        SWIGicodecJNI.MemoryAllocator_deallocBytes(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(x), n);
    }

    public void deallocAsmInstruction(AsmInstruction x) {
        SWIGicodecJNI.MemoryAllocator_deallocAsmInstruction(this.swigCPtr, this, AsmInstruction.getCPtr(x), x);
    }

    public void deallocAsmLabel(AsmLabel x) {
        SWIGicodecJNI.MemoryAllocator_deallocAsmLabel(this.swigCPtr, this, AsmLabel.getCPtr(x), x);
    }

    public void deallocAsmOperand(AsmOperand x, long n) {
        SWIGicodecJNI.MemoryAllocator_deallocAsmOperand(this.swigCPtr, this, AsmOperand.getCPtr(x), x, n);
    }
}

