/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.icodec.swig;

import com.arm.debug.icodec.swig.AsmLabel;
import com.arm.debug.icodec.swig.AsmOperand;
import com.arm.debug.icodec.swig.AsmSyntaxType;
import com.arm.debug.icodec.swig.GenericInstruction;
import com.arm.debug.icodec.swig.SWIGicodecJNI;

public class AsmInstruction {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected AsmInstruction(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(AsmInstruction obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SWIGicodecJNI.delete_AsmInstruction(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setGi(GenericInstruction value) {
        SWIGicodecJNI.AsmInstruction_gi_set(this.swigCPtr, this, GenericInstruction.getCPtr(value), value);
    }

    public GenericInstruction getGi() {
        long cPtr = SWIGicodecJNI.AsmInstruction_gi_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new GenericInstruction(cPtr, false);
    }

    public void setLabels(AsmLabel value) {
        SWIGicodecJNI.AsmInstruction_labels_set(this.swigCPtr, this, AsmLabel.getCPtr(value), value);
    }

    public AsmLabel getLabels() {
        long cPtr = SWIGicodecJNI.AsmInstruction_labels_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new AsmLabel(cPtr, false);
    }

    public void setOperands(AsmOperand value) {
        SWIGicodecJNI.AsmInstruction_operands_set(this.swigCPtr, this, AsmOperand.getCPtr(value), value);
    }

    public AsmOperand getOperands() {
        long cPtr = SWIGicodecJNI.AsmInstruction_operands_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new AsmOperand(cPtr, false);
    }

    public void setOperandCount(short value) {
        SWIGicodecJNI.AsmInstruction_operandCount_set(this.swigCPtr, this, value);
    }

    public short getOperandCount() {
        return SWIGicodecJNI.AsmInstruction_operandCount_get(this.swigCPtr, this);
    }

    public boolean set(AsmOperand operand, long value) {
        return SWIGicodecJNI.AsmInstruction_set(this.swigCPtr, this, AsmOperand.getCPtr(operand), operand, value);
    }

    public boolean setExtRegList(AsmOperand operand, long regFirst, long regCount, long regIncrement) {
        return SWIGicodecJNI.AsmInstruction_setExtRegList(this.swigCPtr, this, AsmOperand.getCPtr(operand), operand, regFirst, regCount, regIncrement);
    }

    public void setError() {
        SWIGicodecJNI.AsmInstruction_setError(this.swigCPtr, this);
    }

    public boolean isError() {
        return SWIGicodecJNI.AsmInstruction_isError(this.swigCPtr, this);
    }

    public void setShortcutForm() {
        SWIGicodecJNI.AsmInstruction_setShortcutForm(this.swigCPtr, this);
    }

    public boolean isShortcutForm() {
        return SWIGicodecJNI.AsmInstruction_isShortcutForm(this.swigCPtr, this);
    }

    public void setPseudoInstruction() {
        SWIGicodecJNI.AsmInstruction_setPseudoInstruction(this.swigCPtr, this);
    }

    public boolean isPseudoInstruction() {
        return SWIGicodecJNI.AsmInstruction_isPseudoInstruction(this.swigCPtr, this);
    }

    public void setHasConditionCode() {
        SWIGicodecJNI.AsmInstruction_setHasConditionCode(this.swigCPtr, this);
    }

    public boolean hasConditionCode() {
        return SWIGicodecJNI.AsmInstruction_hasConditionCode(this.swigCPtr, this);
    }

    public void setHasDataTypes() {
        SWIGicodecJNI.AsmInstruction_setHasDataTypes(this.swigCPtr, this);
    }

    public boolean hasDataTypes() {
        return SWIGicodecJNI.AsmInstruction_hasDataTypes(this.swigCPtr, this);
    }

    public void setPreUAL() {
        SWIGicodecJNI.AsmInstruction_setPreUAL(this.swigCPtr, this);
    }

    public boolean isPreUAL() {
        return SWIGicodecJNI.AsmInstruction_isPreUAL(this.swigCPtr, this);
    }

    public void setVfpneonInstructionSyntaxType(AsmSyntaxType t) {
        SWIGicodecJNI.AsmInstruction_setVfpneonInstructionSyntaxType(this.swigCPtr, this, t.swigValue());
    }

    public AsmSyntaxType vfpneonInstructionSyntaxType() {
        return AsmSyntaxType.swigToEnum(SWIGicodecJNI.AsmInstruction_vfpneonInstructionSyntaxType(this.swigCPtr, this));
    }

    public AsmInstruction() {
        this(SWIGicodecJNI.new_AsmInstruction(), true);
    }
}

